/*
 * Decompiled with CFR 0.152.
 */
package com.crosshaircursor;

import com.crosshaircursor.CrosshairCursorConfig;
import com.google.inject.Provides;
import java.awt.Cursor;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Crosshair Cursor", description="Changes your cursor to a crosshair. Also supports animated cursors (see help page)")
public class CrosshairCursorPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CrosshairCursorPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientUI clientUI;
    @Inject
    private CrosshairCursorConfig config;

    protected void startUp() throws Exception {
        this.updateCursor();
    }

    private void updateCursor() {
        this.clientUI.setCursor(Cursor.getPredefinedCursor(1));
    }

    protected void shutDown() throws Exception {
        this.clientUI.resetCursor();
    }

    @Provides
    CrosshairCursorConfig provideConfig(ConfigManager configManager) {
        return (CrosshairCursorConfig)configManager.getConfig(CrosshairCursorConfig.class);
    }
}

