/*
 * Decompiled with CFR 0.152.
 */
package volcanicminepreresetnotifier;

import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import volcanicminepreresetnotifier.VolcanicMinePreResetNotifierConfig;
import volcanicminepreresetnotifier.VolcanicMinePreResetNotifierInfoBox;

@PluginDescriptor(name="Volcanic Mine pre-reset notifier and Cap Counter", description="Notifies on stability change 6 mins or prior for A role and B/C role and counts total number of caps", tags={"vent", "mine", "volcanic", "vm", "kitsch", "cap"})
public class VolcanicMinePreResetNotifierPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(VolcanicMinePreResetNotifierPlugin.class);
    private static final int VARBIT_STABILITY = 5938;
    private static final int VARBIT_TIME_REMAINING = 5944;
    private static final int VM_REGION_NORTH = 15263;
    private static final int VM_REGION_SOUTH = 15262;
    private static final int BLOCKING_ANIMATION = 832;
    private static final int MINING_ANIMATION = 8347;
    private static final int VARBIT_POINTS = 5934;
    private boolean Notification_Triggered = false;
    private int Stability_Reached_100 = 0;
    public static int capCount = 0;
    private int compareScore = 0;
    private int lastAnimationID = 0;
    private VolcanicMinePreResetNotifierInfoBox VMIB;
    @Inject
    private VolcanicMinePreResetNotifierConfig config;
    @Inject
    private Notifier notifier;
    @Inject
    private Client client;
    @Inject
    private InfoBoxManager infoBoxManager;

    @Provides
    VolcanicMinePreResetNotifierConfig provideConfig(ConfigManager configManager) {
        return (VolcanicMinePreResetNotifierConfig)configManager.getConfig(VolcanicMinePreResetNotifierConfig.class);
    }

    @Subscribe
    private void onVarbitChanged(VarbitChanged event) {
        if (this.config.preResetNotifier()) {
            if (this.client.getVarbitValue(5938) == 100) {
                this.Stability_Reached_100 = 100;
            } else if (this.Stability_Reached_100 - this.client.getVarbitValue(5938) > 0 && this.client.getVarbitValue(5944) > 595 && this.isInVM() && !this.Notification_Triggered) {
                this.notifier.notify("Fix your vent!");
                this.Notification_Triggered = true;
            }
        }
        if (this.config.capCounter()) {
            if (this.client.getVarbitValue(5934) - this.compareScore == 50 && (this.lastAnimationID == 832 || this.lastAnimationID == 8347)) {
                if (this.VMIB != null) {
                    this.infoBoxManager.removeInfoBox((InfoBox)this.VMIB);
                    this.VMIB = null;
                }
                this.VMIB = new VolcanicMinePreResetNotifierInfoBox(this.client, this);
                ++capCount;
                this.infoBoxManager.addInfoBox((InfoBox)this.VMIB);
            }
            this.compareScore = this.client.getVarbitValue(5934);
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged change) {
        if (change.getKey().equals("capCounter") && !this.config.capCounter()) {
            capCount = 0;
            this.infoBoxManager.removeInfoBox((InfoBox)this.VMIB);
            this.VMIB = null;
        }
    }

    protected void shutDown() throws Exception {
        this.reset();
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        if (!this.isInVM()) {
            this.reset();
            return;
        }
        if (this.client.getLocalPlayer().getAnimation() != -1) {
            this.lastAnimationID = this.client.getLocalPlayer().getAnimation();
        }
    }

    private void reset() {
        this.Notification_Triggered = false;
        this.Stability_Reached_100 = 0;
        this.lastAnimationID = 0;
        capCount = 0;
        this.compareScore = 0;
        this.infoBoxManager.removeInfoBox((InfoBox)this.VMIB);
        this.VMIB = null;
    }

    private boolean isInVM() {
        return WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation()).getRegionID() == 15263 || WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation()).getRegionID() == 15262;
    }
}

