/*
 * Decompiled with CFR 0.152.
 */
package com.transcriber;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.transcriber.TranscriberConfig;
import com.transcriber.TranscriberOverlay;
import com.transcriber.TranscriberPanel;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.OverheadTextChanged;
import net.runelite.api.events.WidgetClosed;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageUtil;

@PluginDescriptor(name="Transcriber", description="Automatically copy text in books, scrolls, parchments, flyers, etc and NPC overhead text to a panel when you see it", tags={"transcribe", "copy", "text"})
public class TranscriberPlugin
extends Plugin {
    private static final int TRANSCRIBE_OFFSET = 1;
    private static final String OVERHEAD_TEXT_DELIM = ": ";
    @Inject
    private Client client;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ConfigManager configManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private TranscriberConfig config;
    @Inject
    private TranscriberOverlay overlay;
    private int scheduledTranscribe;
    private Widget widgetBook;
    private Widget widgetLoaded;
    private TranscriberPanel pluginPanel;
    private NavigationButton navigationButton;
    private List<Integer> blacklist = new ArrayList<Integer>();

    @Provides
    TranscriberConfig providesConfig(ConfigManager configManager) {
        return (TranscriberConfig)configManager.getConfig(TranscriberConfig.class);
    }

    protected void startUp() {
        this.pluginPanel = new TranscriberPanel(this.config);
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/panel_icon.png");
        this.navigationButton = NavigationButton.builder().tooltip("Transcriber").icon(icon).priority(100).panel((PluginPanel)this.pluginPanel).build();
        this.clientToolbar.addNavigation(this.navigationButton);
        this.populateBlacklist();
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
        this.clientToolbar.removeNavigation(this.navigationButton);
        this.pluginPanel = null;
        this.navigationButton = null;
        this.blacklist.clear();
    }

    private void transcribeWidget(Widget widget) {
        if (widget == null) {
            return;
        }
        if (!widget.isHidden()) {
            String text;
            int spriteId;
            int modelId;
            int itemId;
            int animationId = widget.getAnimationId();
            if (animationId > -1 && this.config.animationIds()) {
                this.pluginPanel.appendText("<animationID=" + animationId + ">");
            }
            if ((itemId = widget.getItemId()) > -1 && this.config.itemIds()) {
                this.pluginPanel.appendText("<itemID=" + itemId + ">");
            }
            if ((modelId = widget.getModelId()) > -1 && this.config.modelIds()) {
                this.pluginPanel.appendText("<modelID=" + modelId + ">");
            }
            if ((spriteId = widget.getSpriteId()) > -1 && this.config.spriteIds()) {
                this.pluginPanel.appendText("<spriteID=" + spriteId + ">");
            }
            if (!Strings.isNullOrEmpty((String)(text = widget.getText()))) {
                int fontId = widget.getFontId();
                if (fontId > -1 && this.config.fontIds()) {
                    this.pluginPanel.appendText("<fontID=" + fontId + ">");
                }
                this.pluginPanel.appendText(text);
            }
        }
        try {
            Widget[][] childrens;
            Widget[][] widgetArrayArray = childrens = new Widget[][]{widget.getStaticChildren(), widget.getDynamicChildren(), widget.getNestedChildren()};
            int n = widgetArrayArray.length;
            for (int i = 0; i < n; ++i) {
                Widget[] children;
                for (Widget child : children = widgetArrayArray[i]) {
                    this.transcribeWidget(child);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.widgetBook != null && this.scheduledTranscribe == this.client.getTickCount()) {
            this.transcribeWidget(this.widgetBook);
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        int groupId = event.getGroupId();
        if (this.blacklist.contains(groupId)) {
            return;
        }
        this.widgetLoaded = this.client.getWidget(groupId, 0);
        if (this.widgetLoaded != null) {
            this.widgetBook = this.widgetLoaded.getParent();
        }
        this.scheduledTranscribe = this.client.getTickCount() + 1;
    }

    @Subscribe
    public void onWidgetClosed(WidgetClosed event) {
        int groupId = event.getGroupId();
        if (this.widgetLoaded != null && groupId == WidgetInfo.TO_GROUP((int)this.widgetLoaded.getId())) {
            this.widgetLoaded = null;
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if ("transcriber".equals(event.getGroup())) {
            this.populateBlacklist();
        }
    }

    @Subscribe
    public void onOverheadTextChanged(OverheadTextChanged event) {
        if (!this.config.transcribeNpcOverheadText() || !(event.getActor() instanceof NPC)) {
            return;
        }
        this.pluginPanel.appendText(event.getActor().getName() + OVERHEAD_TEXT_DELIM + event.getOverheadText());
    }

    public String[] getSelected() {
        return this.pluginPanel.getSelected();
    }

    private void populateBlacklist() {
        String[] parts = this.config.widgetBlacklist().replace(' ', ',').replace(';', ',').replace('\n', ',').split(",");
        this.blacklist.clear();
        for (String s : parts) {
            try {
                int id = Integer.parseInt(s);
                this.blacklist.add(id);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public Widget getWidgetLoaded() {
        return this.widgetLoaded;
    }
}

