/*
 * Decompiled with CFR 0.152.
 */
package com.transcriber;

import com.transcriber.TranscriberConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;

public class TranscriberPanel
extends PluginPanel {
    private final JTextArea transcriberEditor = new JTextArea();
    private final TranscriberConfig config;

    TranscriberPanel(TranscriberConfig config) {
        this.config = config;
        this.init();
    }

    private void init() {
        this.getParent().setLayout(new BorderLayout());
        this.getParent().add((Component)((Object)this), "Center");
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.transcriberEditor.setTabSize(2);
        this.transcriberEditor.setLineWrap(true);
        this.transcriberEditor.setWrapStyleWord(true);
        JPanel notesContainer = new JPanel();
        notesContainer.setLayout(new BorderLayout());
        notesContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.transcriberEditor.setOpaque(false);
        notesContainer.add((Component)this.transcriberEditor, "Center");
        notesContainer.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.add(notesContainer, "Center");
    }

    void appendText(String data) {
        data = data.replaceAll("<br>", "\n");
        if (this.config.removeUnnecessaryTags()) {
            data = data.replaceAll("<col=000000>", "");
        }
        this.transcriberEditor.append(data + "\n");
        this.transcriberEditor.setCaretPosition(this.transcriberEditor.getDocument().getLength());
    }

    String[] getSelected() {
        String text = this.transcriberEditor.getSelectedText();
        if (text == null) {
            return new String[0];
        }
        return text.split("\n");
    }
}

