/*
 * Decompiled with CFR 0.152.
 */
package com.transcriber;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.transcriber.TranscriberConfig;
import com.transcriber.TranscriberPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import net.runelite.api.widgets.Widget;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;

public class TranscriberOverlay
extends Overlay {
    private final TranscriberPlugin plugin;
    private final TranscriberConfig config;

    @Inject
    private TranscriberOverlay(TranscriberPlugin plugin, TranscriberConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ALWAYS_ON_TOP);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.showTranscriptionOutline() && this.plugin.getWidgetLoaded() != null) {
            this.outlineWidget(graphics, this.plugin.getWidgetLoaded().getParent(), this.plugin.getSelected());
        }
        return null;
    }

    private void outlineWidget(Graphics2D graphics, Widget widget, String[] selected) {
        if (widget == null) {
            return;
        }
        if (!widget.isHidden()) {
            if (widget.getAnimationId() > -1) {
                this.draw(graphics, widget, selected, "<animationID=" + widget.getAnimationId() + ">");
            } else if (widget.getItemId() > -1) {
                this.draw(graphics, widget, selected, "<itemID=" + widget.getItemId() + ">");
            } else if (widget.getModelId() > -1) {
                this.draw(graphics, widget, selected, "<modelID=" + widget.getModelId() + ">");
            } else if (widget.getSpriteId() > -1) {
                this.draw(graphics, widget, selected, "<spriteID=" + widget.getSpriteId() + ">");
            } else if (!Strings.isNullOrEmpty((String)widget.getText()) && !this.draw(graphics, widget, selected, "<fontID=" + widget.getFontId() + ">")) {
                this.draw(graphics, widget, selected, widget.getText());
            }
        }
        try {
            Widget[][] childrens;
            Widget[][] widgetArrayArray = childrens = new Widget[][]{widget.getStaticChildren(), widget.getDynamicChildren(), widget.getNestedChildren()};
            int n = widgetArrayArray.length;
            for (int i = 0; i < n; ++i) {
                Widget[] children;
                for (Widget child : children = widgetArrayArray[i]) {
                    this.outlineWidget(graphics, child, selected);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private boolean selectionContains(String[] selection, String text) {
        for (String s : selection) {
            if (!text.contains(s)) continue;
            return true;
        }
        return false;
    }

    private boolean draw(Graphics2D graphics, Widget widget, String[] selection, String text) {
        if (!this.selectionContains(selection, text)) {
            return false;
        }
        Rectangle rectangle = widget.getBounds();
        graphics.setColor(Color.CYAN);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        return true;
    }
}

