/*
 * Decompiled with CFR 0.152.
 */
package com.optimalquestguide.Panels;

import com.optimalquestguide.GuideConfig;
import com.optimalquestguide.QuestInfo;
import com.optimalquestguide.QuestRequirement;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Client;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.LinkBrowser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(QuestPanel.class);
    private final Client c;
    private final GuideConfig config;
    private final JPanel qHeader = new JPanel();
    private final JPanel qRequirements = new JPanel();
    private final JLabel qLabel = new JLabel();
    private final QuestInfo quest;
    private final HashMap<String, JLabel> skillMap = new HashMap();

    public QuestPanel(Client c, GuideConfig config, QuestInfo quest) {
        this.c = c;
        this.config = config;
        this.quest = quest;
        this.setLayout(new GridBagLayout());
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridy = 0;
        gbc.gridx = 0;
        this.qHeader.setBorder(new EmptyBorder(5, 0, 5, 0));
        this.qHeader.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.qLabel.setText(quest.getName());
        this.qLabel.setFont(FontManager.getRunescapeBoldFont());
        this.qLabel.setHorizontalAlignment(0);
        this.qLabel.setVerticalAlignment(0);
        this.qHeader.add((Component)this.qLabel, "North");
        JMenuItem openWiki = new JMenuItem("Open Wiki Guide");
        openWiki.addActionListener(e -> LinkBrowser.browse((String)quest.getUri()));
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
        popupMenu.add(openWiki);
        this.add((Component)this.qHeader, gbc);
        ++gbc.gridy;
        if (quest.getReqs().length > 0) {
            this.addSkillReqs(quest.getReqs());
            this.add((Component)this.qRequirements, gbc);
        }
        this.setComponentPopupMenu(popupMenu);
    }

    private void addSkillReqs(QuestRequirement[] requirements) {
        this.qRequirements.setLayout(new GridBagLayout());
        this.qRequirements.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.ipadx = 5;
        gbc.ipady = 5;
        for (QuestRequirement requirement : requirements) {
            JPanel reqGroup = new JPanel();
            reqGroup.setLayout(new GridBagLayout());
            reqGroup.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            GridBagConstraints c = new GridBagConstraints();
            c.ipadx = 5;
            JLabel icon = new JLabel(new ImageIcon(requirement.getIcon()));
            icon.setHorizontalAlignment(0);
            icon.setVerticalAlignment(0);
            icon.setPreferredSize(new Dimension(25, 25));
            JLabel level = new JLabel();
            level.setFont(FontManager.getRunescapeSmallFont());
            level.setText(String.valueOf(requirement.getLevel()));
            level.setHorizontalAlignment(0);
            level.setVerticalAlignment(0);
            reqGroup.add((Component)icon, c);
            reqGroup.add((Component)level, c);
            this.skillMap.put(requirement.getSkill().toLowerCase(), level);
            this.qRequirements.add((Component)reqGroup, gbc);
            ++gbc.gridx;
            if (gbc.gridx <= 4) continue;
            gbc.gridx = 0;
            ++gbc.gridy;
        }
    }

    public void update(QuestInfo quest) {
        SwingUtilities.invokeLater(() -> {
            if (quest == null) {
                return;
            }
            if (quest.getQuestState() == null) {
                return;
            }
            if (quest.getQuestState() == QuestState.IN_PROGRESS) {
                this.qLabel.setForeground(this.config.getInProgressColor());
            } else if (quest.getQuestState() == QuestState.FINISHED) {
                this.qLabel.setForeground(this.config.getCompletedColor());
            } else {
                this.qLabel.setForeground(this.config.getNotStartedColor());
            }
            for (QuestRequirement requirement : quest.getReqs()) {
                if (this.c.getLocalPlayer() == null) continue;
                String skill = requirement.getSkill();
                if (skill.equalsIgnoreCase("quest points")) {
                    this.updateRequirement(requirement, skill, this.c.getVarpValue(101));
                    continue;
                }
                if (skill.equalsIgnoreCase("combat level")) {
                    this.updateRequirement(requirement, skill, this.c.getLocalPlayer().getCombatLevel());
                    continue;
                }
                this.updateRequirement(requirement, skill, this.c.getRealSkillLevel(Skill.valueOf((String)skill.toUpperCase())));
            }
        });
    }

    private void updateRequirement(QuestRequirement requirement, String skill, int level) {
        JLabel label = this.skillMap.get(skill.toLowerCase());
        if (label == null) {
            return;
        }
        if (level >= requirement.getLevel()) {
            label.setForeground(this.config.getRequirementMetColor());
        } else if (requirement.isBoostable()) {
            label.setForeground(this.config.getRequirementBoostableColor());
        } else {
            label.setForeground(this.config.getRequirementUnmetColor());
        }
    }

    public QuestInfo getQuest() {
        return this.quest;
    }
}

