/*
 * Decompiled with CFR 0.152.
 */
package com.optimalquestguide.Panels.Listeners;

import com.optimalquestguide.GuideConfig;
import com.optimalquestguide.Panels.QuestPanel;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import javax.swing.JTextField;
import net.runelite.client.input.KeyListener;

public class SearchListener
implements KeyListener {
    private final GuideConfig config;
    private final HashMap<String, QuestPanel> qMap;
    private final HashMap<String, QuestPanel> searchMap;

    public SearchListener(GuideConfig config, HashMap<String, QuestPanel> qMap, HashMap<String, QuestPanel> searchMap) {
        this.config = config;
        this.qMap = qMap;
        this.searchMap = searchMap;
    }

    public void keyTyped(KeyEvent e) {
        JTextField searchBar = (JTextField)e.getSource();
        this.onSearch(searchBar);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void onSearch(JTextField searchBar) {
        String input = searchBar.getText().toLowerCase();
        if (this.config.searchCompletedQuests() || this.searchMap.isEmpty()) {
            this.qMap.forEach((quest, panel) -> {
                panel.setVisible(quest.toLowerCase().contains(input));
                searchBar.revalidate();
            });
        } else {
            this.searchMap.forEach((quest, panel) -> {
                panel.setVisible(quest.toLowerCase().contains(input));
                searchBar.revalidate();
            });
        }
    }
}

