/*
 * Decompiled with CFR 0.152.
 */
package com.optimalquestguide.Panels;

import com.optimalquestguide.GuideConfig;
import com.optimalquestguide.Layouts.CollapsingGridLayout;
import com.optimalquestguide.Panels.ErrorPanel;
import com.optimalquestguide.Panels.Listeners.SearchListener;
import com.optimalquestguide.Panels.QuestPanel;
import com.optimalquestguide.QuestInfo;
import com.optimalquestguide.QuestRequirement;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyListener;
import java.util.HashMap;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.IconTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuidePanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(GuidePanel.class);
    private final Client c;
    private final GuideConfig config;
    private final ErrorPanel ePanel = new ErrorPanel();
    private final IconTextField searchBar = new IconTextField();
    private final HashMap<String, QuestPanel> qMap = new HashMap();
    private final HashMap<String, QuestPanel> searchMap = new HashMap();

    @Inject
    public GuidePanel(Client c, GuideConfig config, QuestInfo[] infos) {
        this.c = c;
        this.config = config;
        this.setLayout(new CollapsingGridLayout(infos.length + 2, 1, 0, 2));
        this.ePanel.setContent("Optimal Quest Guide", "Quests will adjust after login.");
        this.add(this.ePanel);
        this.searchBar.setIcon(IconTextField.Icon.SEARCH);
        this.searchBar.setPreferredSize(new Dimension(-9, 30));
        this.searchBar.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.searchBar.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.searchBar.addClearListener(this::onSearch);
        SearchListener searchListener = new SearchListener(config, this.qMap, this.searchMap);
        this.searchBar.addKeyListener((KeyListener)((Object)searchListener));
        this.add((Component)this.searchBar);
        for (QuestInfo info : infos) {
            QuestPanel qPanel = new QuestPanel(c, config, info);
            this.qMap.put(info.getName(), qPanel);
            this.add(qPanel);
        }
    }

    private void onSearch() {
        if (this.config.searchCompletedQuests() || this.searchMap.isEmpty()) {
            this.qMap.forEach((quest, panel) -> {
                panel.setVisible(quest.toLowerCase().contains(this.searchBar.getText().toLowerCase()));
                this.revalidate();
            });
        } else {
            this.searchMap.forEach((quest, panel) -> {
                panel.setVisible(quest.toLowerCase().contains(this.searchBar.getText().toLowerCase()));
                this.revalidate();
            });
        }
    }

    public void updateQuests(QuestInfo[] infos) {
        QuestPanel qPanel;
        if (!this.searchBar.getText().isEmpty()) {
            return;
        }
        for (QuestInfo info : infos) {
            qPanel = this.qMap.get(info.getName());
            if (qPanel == null) continue;
            qPanel.update(info);
            if (this.config.showCompletedQuests()) {
                if (qPanel.isVisible()) continue;
                qPanel.setVisible(true);
                continue;
            }
            if (info.getQuestState() == QuestState.NOT_STARTED || info.getQuestState() == QuestState.IN_PROGRESS) {
                if (this.config.filterMetRequirements()) {
                    this.filterByMet(qPanel, info);
                    continue;
                }
                if (qPanel.isVisible()) continue;
                qPanel.setVisible(true);
                continue;
            }
            if (!qPanel.isVisible()) continue;
            qPanel.setVisible(false);
        }
        this.searchMap.clear();
        for (Component c : this.getComponents()) {
            if (!c.isVisible() || !(c instanceof QuestPanel)) continue;
            qPanel = (QuestPanel)c;
            this.searchMap.put(qPanel.getQuest().getName(), qPanel);
        }
        this.ePanel.setContent("Optimal Quest Guide", "Happy questing.");
        this.revalidate();
    }

    private boolean meetsRequirement(int has, int need) {
        return has >= need;
    }

    private void filterByMet(QuestPanel qPanel, QuestInfo info) {
        if (this.config.filterMetRequirements()) {
            if (this.c.getLocalPlayer() == null) {
                return;
            }
            for (QuestRequirement requirement : info.getReqs()) {
                String skill = requirement.getSkill();
                int level = requirement.getLevel();
                if (!skill.equalsIgnoreCase("quest points") ? (!skill.equalsIgnoreCase("combat level") ? this.meetsRequirement(this.c.getRealSkillLevel(Skill.valueOf((String)skill.toUpperCase())), level) : this.meetsRequirement(this.c.getLocalPlayer().getCombatLevel(), level)) : this.meetsRequirement(this.c.getVarpValue(101), level)) continue;
                if (!qPanel.isVisible()) break;
                qPanel.setVisible(false);
                break;
            }
        }
    }
}

