/*
 * Decompiled with CFR 0.152.
 */
package com.optimalquestguide;

import com.google.gson.Gson;
import com.google.inject.Provides;
import com.optimalquestguide.GuideConfig;
import com.optimalquestguide.Panels.GuidePanel;
import com.optimalquestguide.QuestInfo;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Quest;
import net.runelite.api.events.GameTick;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Optimal Quest Guide", description="I wanted this so now you get this as well. OSRS Wiki Optimal Quest Guide.", tags={"quest", "guide", "optimal"}, loadWhenOutdated=true)
public class GuidePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GuidePlugin.class);
    @Inject
    private Client c;
    @Inject
    private GuideConfig config;
    @Inject
    private ClientThread cThread;
    @Inject
    private ClientToolbar cToolbar;
    @Inject
    private Gson gson;
    private NavigationButton nBtn;
    private GuidePanel gPanel;
    private HashMap<String, QuestInfo> infoMap = new HashMap();

    protected void startUp() throws Exception {
        InputStream questDataFile = GuidePlugin.class.getResourceAsStream("/quests.json");
        QuestInfo[] infos = (QuestInfo[])this.gson.fromJson((Reader)new InputStreamReader(questDataFile), QuestInfo[].class);
        for (int i = 0; i < infos.length; ++i) {
            QuestInfo info = infos[i];
            info.setIndex(i);
            this.infoMap.put(info.getName(), info);
        }
        this.gPanel = new GuidePanel(this.c, this.config, infos);
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/panel_icon.png");
        this.nBtn = NavigationButton.builder().tooltip("Optimal Quest Guide").icon(icon).priority(7).panel((PluginPanel)this.gPanel).build();
        this.cToolbar.addNavigation(this.nBtn);
    }

    protected void shutDown() throws Exception {
        this.cToolbar.removeNavigation(this.nBtn);
    }

    @Provides
    GuideConfig provideConfig(ConfigManager configManager) {
        return (GuideConfig)configManager.getConfig(GuideConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged e) {
        if (!e.getGroup().equalsIgnoreCase("optimal-quest-guide")) {
            return;
        }
        if (!this.c.getGameState().equals((Object)GameState.LOGGED_IN)) {
            return;
        }
        this.cThread.invokeLater(this::updateQuestList);
    }

    @Subscribe
    public void onGameTick(GameTick e) {
        this.updateQuestList();
    }

    private void updateQuestList() {
        for (Quest quest : Quest.values()) {
            QuestInfo info = this.infoMap.get(quest.getName());
            if (info == null) continue;
            info.setWidget(quest);
            info.setQuestState(quest.getState(this.c));
        }
        this.gPanel.updateQuests(this.getInfoArray());
    }

    private QuestInfo[] getInfoArray() {
        QuestInfo[] infos = this.infoMap.values().toArray(new QuestInfo[0]);
        Arrays.sort(infos, (o1, o2) -> Integer.compare(o1.getIndex(), o2.getIndex()));
        return infos;
    }
}

