/*
 * Decompiled with CFR 0.152.
 */
package com.optimalquestguide;

import java.awt.Color;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;

@ConfigGroup(value="optimal-quest-guide")
public interface GuideConfig
extends Config {
    @ConfigSection(name="Quest Status Colors", description="Colors of not started, in progress and completed Quest", position=98)
    public static final String questStatusSection = "status";
    @ConfigSection(name="Quest Requirement Colors", description="Colors of met, unmet and boostable Quest Requirements", position=99)
    public static final String questRequirementSection = "requirement";

    @ConfigItem(keyName="showCompletedQuests", name="Show completed quests", description="Displays already completed quests")
    default public boolean showCompletedQuests() {
        return false;
    }

    @ConfigItem(keyName="searchCompletedQuests", name="Search completed quests", description="Have the search include completed quests")
    default public boolean searchCompletedQuests() {
        return false;
    }

    @ConfigItem(keyName="filterMetRequirements", name="Filter by met Requirements", description="Only display the quests that you have the met requirements to complete")
    default public boolean filterMetRequirements() {
        return false;
    }

    @ConfigItem(keyName="inProgressColor", name="Quest in progress color", description="Color of Quests in progress", section="status")
    default public Color getInProgressColor() {
        return new Color(240, 207, 123);
    }

    @ConfigItem(keyName="completedColor", name="Quest completed color", description="Color of Quests that have been completed", section="status")
    default public Color getCompletedColor() {
        return new Color(110, 225, 110);
    }

    @ConfigItem(keyName="notStartedColor", name="Quest not started color", description="Color of Quests that have not been started", section="status")
    default public Color getNotStartedColor() {
        return new Color(198, 198, 198);
    }

    @ConfigItem(keyName="requirementMetColor", name="Requirement level met", description="Color of Requirements that have been met or exceeded", section="requirement")
    default public Color getRequirementMetColor() {
        return new Color(110, 225, 110);
    }

    @ConfigItem(keyName="requirementUnmetColor", name="Requirement level unmet", description="Color of Requirements that have been unmet and unboostable", section="requirement")
    default public Color getRequirementUnmetColor() {
        return new Color(230, 30, 30);
    }

    @ConfigItem(keyName="requirementBoostableColor", name="Requirement boostable", description="Color of Requirements that have are unmet and boostable", section="requirement")
    default public Color getRequirementBoostableColor() {
        return new Color(50, 160, 250);
    }
}

