/*
 * Decompiled with CFR 0.152.
 */
package com.interactable;

import com.google.common.base.Strings;
import com.google.inject.Provides;
import com.interactable.InteractableConfig;
import com.interactable.InteractableOverlay;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GroundObject;
import net.runelite.api.NPC;
import net.runelite.api.NPCComposition;
import net.runelite.api.ObjectComposition;
import net.runelite.api.Player;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.TileObject;
import net.runelite.api.WallObject;
import net.runelite.api.events.ClientTick;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.HotkeyListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Interactable Hints")
public class InteractablePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(InteractablePlugin.class);
    private int MAX_DISTANCE = 2350;
    private int remainingClientTicks = -1;
    private boolean shown = false;
    private Color currentObjectColor;
    private Color currentNpcAttackColor;
    private Color currentNpcInteractColor;
    private List<TileObject> objects = new ArrayList<TileObject>();
    private List<NPC> attackNpcs = new ArrayList<NPC>();
    private List<NPC> interactNpcs = new ArrayList<NPC>();
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private InteractableOverlay interactableOverlay;
    @Inject
    private InteractableConfig config;
    @Inject
    private KeyManager keyManager;
    private final HotkeyListener hotkeyListener = new HotkeyListener(() -> this.config.toggleKeybind()){

        public void hotkeyPressed() {
            InteractablePlugin.this.currentObjectColor = InteractablePlugin.this.config.objectHighlightColor();
            InteractablePlugin.this.currentNpcAttackColor = InteractablePlugin.this.config.attackNpcColor();
            InteractablePlugin.this.currentNpcInteractColor = InteractablePlugin.this.config.interactableNpcColor();
            InteractablePlugin.this.shown = !InteractablePlugin.this.shown;
            log.debug("Interactable Hints overlay toggled to " + InteractablePlugin.this.shown);
            if (InteractablePlugin.this.shown) {
                InteractablePlugin.this.remainingClientTicks = InteractablePlugin.this.config.autoHideTimeout() * 50;
            }
        }
    };

    protected void startUp() throws Exception {
        this.shown = false;
        this.keyManager.registerKeyListener((KeyListener)this.hotkeyListener);
        this.overlayManager.add((Overlay)this.interactableOverlay);
        this.objects = new ArrayList<TileObject>();
        this.attackNpcs = new ArrayList<NPC>();
        this.interactNpcs = new ArrayList<NPC>();
    }

    protected void shutDown() throws Exception {
        this.shown = false;
        this.keyManager.unregisterKeyListener((KeyListener)this.hotkeyListener);
        this.overlayManager.remove((Overlay)this.interactableOverlay);
        this.objects = null;
        this.attackNpcs = null;
        this.interactNpcs = null;
    }

    @Subscribe
    public void onClientTick(ClientTick clientTick) {
        if (this.config.autoHideTimeout() > 0 && this.shown) {
            if (this.remainingClientTicks > 50) {
                --this.remainingClientTicks;
            } else if (this.remainingClientTicks > 0) {
                this.fadeOut();
                --this.remainingClientTicks;
            } else {
                this.shown = false;
                log.debug("Interactable Hints auto-hide triggered");
                this.currentObjectColor = this.config.objectHighlightColor();
                this.currentNpcAttackColor = this.config.attackNpcColor();
                this.currentNpcInteractColor = this.config.interactableNpcColor();
            }
        }
    }

    private void fadeOut() {
        int newObjectAlpha = this.config.objectHighlightColor().getAlpha() * this.remainingClientTicks / 50;
        this.currentObjectColor = new Color(this.config.objectHighlightColor().getRed(), this.config.objectHighlightColor().getGreen(), this.config.objectHighlightColor().getBlue(), newObjectAlpha);
        int newAttackAlpha = this.config.attackNpcColor().getAlpha() * this.remainingClientTicks / 50;
        this.currentNpcAttackColor = new Color(this.config.attackNpcColor().getRed(), this.config.attackNpcColor().getGreen(), this.config.attackNpcColor().getBlue(), newAttackAlpha);
        int newInteractAlpha = this.config.interactableNpcColor().getAlpha() * this.remainingClientTicks / 50;
        this.currentNpcInteractColor = new Color(this.config.interactableNpcColor().getRed(), this.config.interactableNpcColor().getGreen(), this.config.interactableNpcColor().getBlue(), newInteractAlpha);
    }

    @Provides
    InteractableConfig provideConfig(ConfigManager configManager) {
        return (InteractableConfig)configManager.getConfig(InteractableConfig.class);
    }

    void generateObjectLists() {
        this.objects = new ArrayList<TileObject>();
        this.attackNpcs = new ArrayList<NPC>();
        this.interactNpcs = new ArrayList<NPC>();
        for (NPC npc : this.client.getNpcs()) {
            NPCComposition npcComp = this.replaceNpcImposters(npc.getComposition());
            if (!this.npcCompCheck(npcComp) || !this.npcCheck(npc)) continue;
            if (this.npcAttackable(npcComp)) {
                this.attackNpcs.add(npc);
                continue;
            }
            if (!this.npcInteractable(npcComp)) continue;
            this.interactNpcs.add(npc);
        }
        Scene scene = this.client.getScene();
        Tile[][] tiles = scene.getTiles()[this.client.getPlane()];
        for (int x = 0; x < 104; ++x) {
            for (int y = 0; y < 104; ++y) {
                int objectId;
                ObjectComposition comp;
                GroundObject groundObject;
                int objectId2;
                ObjectComposition comp2;
                WallObject wallObject;
                Tile tile = tiles[x][y];
                if (tile == null) continue;
                for (GameObject gameObject : tile.getGameObjects()) {
                    int objectId3;
                    ObjectComposition comp3;
                    if (!this.gameObjectCheck((TileObject)gameObject) || gameObject.getRenderable() instanceof Player || gameObject.getRenderable() instanceof NPC || !this.objectCompCheck(comp3 = this.replaceObjectImposters(this.client.getObjectDefinition(objectId3 = gameObject.getId())))) continue;
                    if (this.objects.contains(gameObject)) break;
                    this.objects.add((TileObject)gameObject);
                    break;
                }
                if (this.gameObjectCheck((TileObject)(wallObject = tile.getWallObject())) && this.objectCompCheck(comp2 = this.replaceObjectImposters(this.client.getObjectDefinition(objectId2 = wallObject.getId()))) && !this.objects.contains(wallObject)) {
                    this.objects.add((TileObject)wallObject);
                }
                if (!this.gameObjectCheck((TileObject)(groundObject = tile.getGroundObject())) || !this.objectCompCheck(comp = this.replaceObjectImposters(this.client.getObjectDefinition(objectId = groundObject.getId()))) || this.objects.contains(groundObject)) continue;
                this.objects.add((TileObject)groundObject);
            }
        }
    }

    private boolean objectCompCheck(ObjectComposition comp) {
        return comp != null && !Strings.isNullOrEmpty((String)comp.getName()) && !comp.getName().equals("null") && this.objectActionCheck(comp);
    }

    private boolean npcCompCheck(NPCComposition comp) {
        return comp != null && !Strings.isNullOrEmpty((String)comp.getName()) && !comp.getName().equals("null");
    }

    private boolean gameObjectCheck(TileObject object) {
        return object != null && object.getLocalLocation().distanceTo(this.client.getLocalPlayer().getLocalLocation()) <= this.MAX_DISTANCE;
    }

    private boolean npcCheck(NPC npc) {
        return npc != null && npc.getLocalLocation().distanceTo(this.client.getLocalPlayer().getLocalLocation()) <= this.MAX_DISTANCE;
    }

    private ObjectComposition replaceObjectImposters(ObjectComposition comp) {
        return comp.getImpostorIds() != null ? comp.getImpostor() : comp;
    }

    private NPCComposition replaceNpcImposters(NPCComposition comp) {
        return comp.getConfigs() != null && comp.transform() != null ? comp.transform() : comp;
    }

    private boolean objectActionCheck(ObjectComposition comp) {
        for (String action : comp.getActions()) {
            if (Strings.isNullOrEmpty((String)action) || action.equals("null")) continue;
            return true;
        }
        return false;
    }

    private boolean npcAttackable(NPCComposition comp) {
        for (String action : comp.getActions()) {
            if (Strings.isNullOrEmpty((String)action) || !action.equals("Attack") || this.client.getVarpValue(1306) == 3) continue;
            return true;
        }
        return false;
    }

    private boolean npcInteractable(NPCComposition comp) {
        for (String action : comp.getActions()) {
            if (Strings.isNullOrEmpty((String)action) || action.equals("null") || action.equals("Attack")) continue;
            return true;
        }
        return false;
    }

    boolean isShown() {
        return this.shown;
    }

    Color getCurrentObjectColor() {
        return this.currentObjectColor;
    }

    Color getCurrentNpcAttackColor() {
        return this.currentNpcAttackColor;
    }

    Color getCurrentNpcInteractColor() {
        return this.currentNpcInteractColor;
    }

    List<TileObject> getObjects() {
        return this.objects;
    }

    List<NPC> getAttackNpcs() {
        return this.attackNpcs;
    }

    List<NPC> getInteractNpcs() {
        return this.interactNpcs;
    }
}

