/*
 * Decompiled with CFR 0.152.
 */
package com.interactable;

import com.interactable.InteractableConfig;
import com.interactable.InteractablePlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.TileObject;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.outline.ModelOutlineRenderer;

class InteractableOverlay
extends Overlay {
    private final Client client;
    private final InteractablePlugin plugin;
    private final InteractableConfig config;
    private final ModelOutlineRenderer modelOutlineRenderer;

    @Inject
    private InteractableOverlay(Client client, InteractablePlugin plugin, InteractableConfig config, ModelOutlineRenderer modelOutlineRenderer) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.modelOutlineRenderer = modelOutlineRenderer;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.setPriority(OverlayPriority.HIGH);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.isShown()) {
            this.renderObjects();
        }
        return null;
    }

    private void renderObjects() {
        this.plugin.generateObjectLists();
        if (this.config.showObject()) {
            for (TileObject object : this.plugin.getObjects()) {
                if (object == null) continue;
                this.modelOutlineRenderer.drawOutline(object, this.config.borderWidth(), this.plugin.getCurrentObjectColor(), this.config.outlineFeather());
            }
        }
        if (this.config.showAttackNpc()) {
            for (NPC npc : this.plugin.getAttackNpcs()) {
                if (npc == null) continue;
                this.modelOutlineRenderer.drawOutline(npc, this.config.borderWidth(), this.plugin.getCurrentNpcAttackColor(), this.config.outlineFeather());
            }
        }
        if (this.config.showInteractableNpc()) {
            for (NPC npc : this.plugin.getInteractNpcs()) {
                if (npc == null) continue;
                this.modelOutlineRenderer.drawOutline(npc, this.config.borderWidth(), this.plugin.getCurrentNpcInteractColor(), this.config.outlineFeather());
            }
        }
    }
}

