/*
 * Decompiled with CFR 0.152.
 */
package Posiedien_Leagues_Planner.pathfinder;

import Posiedien_Leagues_Planner.WorldPointUtil;
import Posiedien_Leagues_Planner.pathfinder.CollisionMap;
import Posiedien_Leagues_Planner.pathfinder.SplitFlagMap;
import net.runelite.api.coords.WorldPoint;

public class VisitedTiles {
    private final SplitFlagMap.RegionExtent regionExtents = SplitFlagMap.getRegionExtents();
    private final int widthInclusive = this.regionExtents.getWidth() + 1;
    private final VisitedRegion[] visitedRegions;
    private final byte[] visitedRegionPlanes;

    public VisitedTiles(CollisionMap map) {
        int heightInclusive = this.regionExtents.getHeight() + 1;
        this.visitedRegions = new VisitedRegion[this.widthInclusive * heightInclusive];
        this.visitedRegionPlanes = map.getPlanes();
    }

    public boolean get(WorldPoint point) {
        return this.get(point.getX(), point.getY(), point.getPlane());
    }

    public boolean get(int packedPoint) {
        int x = WorldPointUtil.unpackWorldX(packedPoint);
        int y = WorldPointUtil.unpackWorldY(packedPoint);
        int plane = WorldPointUtil.unpackWorldPlane(packedPoint);
        return this.get(x, y, plane);
    }

    public boolean get(int x, int y, int plane) {
        int regionIndex = this.getRegionIndex(x / 64, y / 64);
        if (regionIndex < 0 || regionIndex >= this.visitedRegions.length) {
            return true;
        }
        VisitedRegion region = this.visitedRegions[regionIndex];
        if (region == null) {
            return false;
        }
        return region.get(x % 64, y % 64, plane);
    }

    public boolean set(int packedPoint) {
        int x = WorldPointUtil.unpackWorldX(packedPoint);
        int y = WorldPointUtil.unpackWorldY(packedPoint);
        int plane = WorldPointUtil.unpackWorldPlane(packedPoint);
        return this.set(x, y, plane);
    }

    public boolean set(int x, int y, int plane) {
        int regionIndex = this.getRegionIndex(x / 64, y / 64);
        if (regionIndex < 0 || regionIndex >= this.visitedRegions.length) {
            return false;
        }
        VisitedRegion region = this.visitedRegions[regionIndex];
        if (region == null) {
            this.visitedRegions[regionIndex] = region = new VisitedRegion(this.visitedRegionPlanes[regionIndex]);
        }
        return region.set(x % 64, y % 64, plane);
    }

    public void clear() {
        for (int i = 0; i < this.visitedRegions.length; ++i) {
            if (this.visitedRegions[i] == null) continue;
            this.visitedRegions[i] = null;
        }
    }

    private int getRegionIndex(int regionX, int regionY) {
        return regionX - this.regionExtents.minX + (regionY - this.regionExtents.minY) * this.widthInclusive;
    }

    private static class VisitedRegion {
        private final long[] planes;
        private final byte planeCount;

        VisitedRegion(byte planeCount) {
            this.planeCount = planeCount;
            this.planes = new long[planeCount * 64];
        }

        public boolean set(int x, int y, int plane) {
            if (plane >= this.planeCount) {
                return false;
            }
            int index = y + plane * 64;
            boolean unique = (this.planes[index] & 1L << x) == 0L;
            int n = index;
            this.planes[n] = this.planes[n] | 1L << x;
            return unique;
        }

        public boolean get(int x, int y, int plane) {
            if (plane >= this.planeCount) {
                return true;
            }
            return (this.planes[y + plane * 64] & 1L << x) != 0L;
        }
    }
}

