/*
 * Decompiled with CFR 0.152.
 */
package Posiedien_Leagues_Planner.pathfinder;

import Posiedien_Leagues_Planner.LeaguesPlannerConfig;
import Posiedien_Leagues_Planner.PrimitiveIntHashMap;
import Posiedien_Leagues_Planner.Transport;
import Posiedien_Leagues_Planner.WorldPointUtil;
import Posiedien_Leagues_Planner.pathfinder.CollisionMap;
import Posiedien_Leagues_Planner.pathfinder.FlagMap;
import Posiedien_Leagues_Planner.pathfinder.SplitFlagMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Quest;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;

public class PathfinderConfig {
    private static final WorldArea WILDERNESS_ABOVE_GROUND = new WorldArea(2944, 3523, 448, 448, 0);
    private static final WorldArea WILDERNESS_UNDERGROUND = new WorldArea(2944, 9918, 320, 442, 0);
    private final SplitFlagMap mapData;
    private final ThreadLocal<CollisionMap> map;
    private final Map<WorldPoint, List<Transport>> allTransports;
    private Map<WorldPoint, List<Transport>> transports;
    private PrimitiveIntHashMap<List<Transport>> transportsPacked;
    private final Client client;
    final LeaguesPlannerConfig config;
    private long calculationCutoffMillis;
    private boolean avoidWilderness;
    private boolean useAgilityShortcuts;
    private boolean useGrappleShortcuts;
    private boolean useBoats;
    private boolean useCanoes;
    private boolean useCharterShips;
    private boolean useShips;
    private boolean useFairyRings;
    private boolean useGnomeGliders;
    private boolean useSpiritTrees;
    private boolean useTeleportationLevers;
    private boolean useTeleportationPortals;
    private int agilityLevel;
    private int rangedLevel;
    private int strengthLevel;
    private int prayerLevel;
    private int woodcuttingLevel;
    private Map<Quest, QuestState> questStates = new HashMap<Quest, QuestState>();

    public PathfinderConfig(SplitFlagMap mapData, Map<WorldPoint, List<Transport>> transports, Client client, LeaguesPlannerConfig config) {
        this.mapData = mapData;
        this.map = ThreadLocal.withInitial(() -> new CollisionMap(this.mapData));
        this.allTransports = transports;
        this.transports = new HashMap<WorldPoint, List<Transport>>(this.allTransports.size());
        this.transportsPacked = new PrimitiveIntHashMap(this.allTransports.size());
        this.client = client;
        this.config = config;
        if (config != null) {
            for (FlagMap regionMap : mapData.regionMaps) {
                if (regionMap == null) continue;
                for (int x = 0; x < 64; ++x) {
                    int AdjustedX = regionMap.minX + x;
                    for (int y = 0; y < 64; ++y) {
                        int AdjustedY = regionMap.minY + y;
                        for (int z = 0; z < regionMap.getPlaneCount(); ++z) {
                            if (mapData.bCanceled) {
                                return;
                            }
                            WorldPoint ConvertedPoint = new WorldPoint(AdjustedX, AdjustedY, z);
                            if (LeaguesPlannerConfig.RegionData.IsTileInUnlockedRegion(config, ConvertedPoint)) continue;
                            regionMap.set(AdjustedX, AdjustedY, z, 0, false);
                            regionMap.set(AdjustedX, AdjustedY, z, 1, false);
                        }
                    }
                }
            }
        }
    }

    public CollisionMap getMap() {
        return this.map.get();
    }

    public void refresh() {
        if (GameState.LOGGED_IN.equals((Object)this.client.getGameState())) {
            this.avoidWilderness = this.config.avoidWilderness();
            this.useAgilityShortcuts = this.config.useAgilityShortcuts();
            this.useGrappleShortcuts = this.config.useGrappleShortcuts();
            this.useBoats = this.config.useBoats();
            this.useCanoes = this.config.useCanoes();
            this.useCharterShips = this.config.useCharterShips();
            this.useShips = this.config.useShips();
            this.useFairyRings = this.config.useFairyRings();
            this.useSpiritTrees = this.config.useSpiritTrees();
            this.useGnomeGliders = this.config.useGnomeGliders();
            this.useTeleportationLevers = this.config.useTeleportationLevers();
            this.useTeleportationPortals = this.config.useTeleportationPortals();
            this.agilityLevel = this.client.getBoostedSkillLevel(Skill.AGILITY);
            this.rangedLevel = this.client.getBoostedSkillLevel(Skill.RANGED);
            this.strengthLevel = this.client.getBoostedSkillLevel(Skill.STRENGTH);
            this.prayerLevel = this.client.getBoostedSkillLevel(Skill.PRAYER);
            this.woodcuttingLevel = this.client.getBoostedSkillLevel(Skill.WOODCUTTING);
            this.refreshTransportData();
        } else {
            this.avoidWilderness = false;
            this.useAgilityShortcuts = true;
            this.useGrappleShortcuts = true;
            this.useBoats = true;
            this.useCanoes = true;
            this.useCharterShips = true;
            this.useShips = true;
            this.useFairyRings = false;
            this.useSpiritTrees = false;
            this.useGnomeGliders = false;
            this.useTeleportationLevers = false;
            this.useTeleportationPortals = false;
            this.agilityLevel = 99;
            this.rangedLevel = 99;
            this.strengthLevel = 99;
            this.prayerLevel = 99;
            this.woodcuttingLevel = 99;
            this.refreshTransportData();
        }
    }

    private void refreshTransportData() {
        if (!Thread.currentThread().equals(this.client.getClientThread())) {
            return;
        }
        this.useFairyRings &= !QuestState.NOT_STARTED.equals((Object)this.getQuestState(Quest.FAIRYTALE_II__CURE_A_QUEEN));
        this.useGnomeGliders &= QuestState.FINISHED.equals((Object)this.getQuestState(Quest.THE_GRAND_TREE));
        this.useSpiritTrees &= QuestState.FINISHED.equals((Object)this.getQuestState(Quest.TREE_GNOME_VILLAGE));
        this.transports.clear();
        this.transportsPacked.clear();
        for (Map.Entry<WorldPoint, List<Transport>> entry : this.allTransports.entrySet()) {
            ArrayList<Transport> usableTransports = new ArrayList<Transport>(entry.getValue().size());
            for (Transport transport : entry.getValue()) {
                for (Quest quest : transport.getQuests()) {
                    try {
                        this.questStates.put(quest, this.getQuestState(quest));
                    }
                    catch (NullPointerException nullPointerException) {}
                }
                if (!this.useTransport(transport)) continue;
                usableTransports.add(transport);
            }
            WorldPoint point = entry.getKey();
            this.transports.put(point, usableTransports);
            this.transportsPacked.put(WorldPointUtil.packWorldPoint(point), usableTransports);
        }
    }

    public static boolean isInWilderness(WorldPoint p) {
        return WILDERNESS_ABOVE_GROUND.distanceTo(p) == 0 || WILDERNESS_UNDERGROUND.distanceTo(p) == 0;
    }

    public static boolean isInWilderness(int packedPoint) {
        return WorldPointUtil.distanceToArea(packedPoint, WILDERNESS_ABOVE_GROUND) == 0 || WorldPointUtil.distanceToArea(packedPoint, WILDERNESS_UNDERGROUND) == 0;
    }

    public boolean avoidWilderness(int packedPosition, int packedNeightborPosition, boolean targetInWilderness) {
        return this.avoidWilderness && !PathfinderConfig.isInWilderness(packedPosition) && PathfinderConfig.isInWilderness(packedNeightborPosition) && !targetInWilderness;
    }

    public QuestState getQuestState(Quest quest) {
        if (this.client == null) {
            return QuestState.FINISHED;
        }
        return quest.getState(this.client);
    }

    private boolean completedQuests(Transport transport) {
        for (Quest quest : transport.getQuests()) {
            if (QuestState.FINISHED.equals((Object)this.questStates.getOrDefault(quest, QuestState.NOT_STARTED))) continue;
            return false;
        }
        return true;
    }

    private boolean useTransport(Transport transport) {
        int transportAgilityLevel = transport.getRequiredLevel(Skill.AGILITY);
        int transportRangedLevel = transport.getRequiredLevel(Skill.RANGED);
        int transportStrengthLevel = transport.getRequiredLevel(Skill.STRENGTH);
        int transportPrayerLevel = transport.getRequiredLevel(Skill.PRAYER);
        int transportWoodcuttingLevel = transport.getRequiredLevel(Skill.WOODCUTTING);
        boolean isAgilityShortcut = transport.isAgilityShortcut();
        boolean isGrappleShortcut = transport.isGrappleShortcut();
        boolean isBoat = transport.isBoat();
        boolean isCanoe = transport.isCanoe();
        boolean isCharterShip = transport.isCharterShip();
        boolean isShip = transport.isShip();
        boolean isFairyRing = transport.isFairyRing();
        boolean isGnomeGlider = transport.isGnomeGlider();
        boolean isSpiritTree = transport.isSpiritTree();
        boolean isTeleportationLever = transport.isTeleportationLever();
        boolean isTeleportationPortal = transport.isTeleportationPortal();
        boolean isPrayerLocked = transportPrayerLevel > 1;
        boolean isQuestLocked = transport.isQuestLocked();
        if (isAgilityShortcut) {
            if (!this.useAgilityShortcuts || this.agilityLevel < transportAgilityLevel) {
                return false;
            }
            if (isGrappleShortcut && (!this.useGrappleShortcuts || this.rangedLevel < transportRangedLevel || this.strengthLevel < transportStrengthLevel)) {
                return false;
            }
        }
        if (isBoat && !this.useBoats) {
            return false;
        }
        if (isCanoe && (!this.useCanoes || this.woodcuttingLevel < transportWoodcuttingLevel)) {
            return false;
        }
        if (isCharterShip && !this.useCharterShips) {
            return false;
        }
        if (isShip && !this.useShips) {
            return false;
        }
        if (isFairyRing && !this.useFairyRings) {
            return false;
        }
        if (isGnomeGlider && !this.useGnomeGliders) {
            return false;
        }
        if (isSpiritTree && !this.useSpiritTrees) {
            return false;
        }
        if (isTeleportationLever && !this.useTeleportationLevers) {
            return false;
        }
        if (isTeleportationPortal && !this.useTeleportationPortals) {
            return false;
        }
        if (isPrayerLocked && this.prayerLevel < transportPrayerLevel) {
            return false;
        }
        return !isQuestLocked || this.completedQuests(transport);
    }

    public Map<WorldPoint, List<Transport>> getTransports() {
        return this.transports;
    }

    public PrimitiveIntHashMap<List<Transport>> getTransportsPacked() {
        return this.transportsPacked;
    }

    public long getCalculationCutoffMillis() {
        return this.calculationCutoffMillis;
    }

    public boolean isAvoidWilderness() {
        return this.avoidWilderness;
    }
}

