/*
 * Decompiled with CFR 0.152.
 */
package Posiedien_Leagues_Planner.pathfinder;

import Posiedien_Leagues_Planner.WorldPointUtil;
import Posiedien_Leagues_Planner.pathfinder.CollisionMap;
import Posiedien_Leagues_Planner.pathfinder.Node;
import Posiedien_Leagues_Planner.pathfinder.PathfinderConfig;
import Posiedien_Leagues_Planner.pathfinder.TransportNode;
import Posiedien_Leagues_Planner.pathfinder.VisitedTiles;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import net.runelite.api.coords.WorldPoint;

public class Pathfinder
implements Runnable {
    private PathfinderStats stats;
    private volatile boolean done = false;
    private volatile boolean cancelled = false;
    private final WorldPoint start;
    private final WorldPoint target;
    private final int targetPacked;
    private final PathfinderConfig config;
    private final CollisionMap map;
    private final boolean targetInWilderness;
    private final Deque<Node> boundary = new ArrayDeque<Node>(4096);
    private final Queue<Node> pending = new PriorityQueue<Node>(256);
    private final VisitedTiles visited;
    private List<WorldPoint> path = Collections.EMPTY_LIST;
    private boolean pathNeedsUpdate = false;
    private Node bestLastNode;
    private boolean bJustFindOverworld = false;

    public Pathfinder(PathfinderConfig config, WorldPoint start, WorldPoint target, boolean bInJustFindOverworld) {
        this.stats = new PathfinderStats();
        this.config = config;
        this.map = config.getMap();
        this.map.bJustFindingOverworld = bInJustFindOverworld;
        this.start = start;
        this.target = target;
        this.visited = new VisitedTiles(this.map);
        this.targetPacked = WorldPointUtil.packWorldPoint(target);
        this.targetInWilderness = PathfinderConfig.isInWilderness(target);
        this.bJustFindOverworld = bInJustFindOverworld;
    }

    public boolean isDone() {
        return this.done;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public PathfinderStats getStats() {
        if (this.stats.started && this.stats.ended) {
            return this.stats;
        }
        return null;
    }

    public List<WorldPoint> getPath() {
        Node lastNode = this.bestLastNode;
        if (lastNode == null) {
            return this.path;
        }
        if (this.pathNeedsUpdate) {
            this.path = lastNode.getPath();
            this.pathNeedsUpdate = false;
        }
        return this.path;
    }

    private Node addNeighbors(Node node) {
        List<Node> nodes = this.map.getNeighbors(node, this.visited, this.config);
        for (int i = 0; i < nodes.size(); ++i) {
            Node neighbor = nodes.get(i);
            if (neighbor.packedPosition == this.targetPacked) {
                return neighbor;
            }
            if (this.config.isAvoidWilderness() && this.config.avoidWilderness(node.packedPosition, neighbor.packedPosition, this.targetInWilderness)) continue;
            this.visited.set(neighbor.packedPosition);
            if (neighbor instanceof TransportNode) {
                this.pending.add(neighbor);
                ++this.stats.transportsChecked;
                continue;
            }
            this.boundary.addLast(neighbor);
            ++this.stats.nodesChecked;
        }
        return null;
    }

    public boolean IsOverworldLocation(WorldPoint testPoint) {
        if (testPoint.getPlane() == 0 && testPoint.getX() > 1022 && testPoint.getX() < 3968) {
            return testPoint.getY() > 2494 && testPoint.getY() < 4160;
        }
        return false;
    }

    @Override
    public void run() {
        this.stats.start();
        this.boundary.addFirst(new Node(this.start, null));
        int bestDistance = Integer.MAX_VALUE;
        long bestHeuristic = Integer.MAX_VALUE;
        long cutoffDurationMillis = 0L;
        long cutoffTimeMillis = System.currentTimeMillis() + cutoffDurationMillis;
        while (!(this.cancelled || this.boundary.isEmpty() && this.pending.isEmpty())) {
            Node node = this.boundary.peekFirst();
            Node p = this.pending.peek();
            if (p != null && (node == null || p.cost < node.cost)) {
                this.boundary.addFirst(p);
                this.pending.poll();
            }
            node = this.boundary.removeFirst();
            if (node.packedPosition == this.targetPacked) {
                this.bestLastNode = node;
                this.pathNeedsUpdate = true;
                break;
            }
            int distance = WorldPointUtil.distanceBetween(node.packedPosition, this.targetPacked);
            long heuristic = distance + WorldPointUtil.distanceBetween(node.packedPosition, this.targetPacked, 2);
            if (heuristic < bestHeuristic || heuristic <= bestHeuristic && distance < bestDistance) {
                this.bestLastNode = node;
                this.pathNeedsUpdate = true;
                bestDistance = distance;
                bestHeuristic = heuristic;
                cutoffTimeMillis = System.currentTimeMillis() + cutoffDurationMillis;
            }
            if (System.currentTimeMillis() > cutoffTimeMillis) {
                // empty if block
            }
            if ((p = this.addNeighbors(node)) == null && (!this.bJustFindOverworld || !this.IsOverworldLocation(WorldPointUtil.unpackWorldPoint(node.packedPosition)))) continue;
            this.bestLastNode = p != null ? p : node;
            this.pathNeedsUpdate = true;
            break;
        }
        this.done = !this.cancelled;
        this.boundary.clear();
        this.visited.clear();
        this.pending.clear();
        this.stats.end();
    }

    public WorldPoint getStart() {
        return this.start;
    }

    public WorldPoint getTarget() {
        return this.target;
    }

    public static class PathfinderStats {
        private int nodesChecked = 0;
        private int transportsChecked = 0;
        private long startNanos;
        private long endNanos;
        private volatile boolean started = false;
        private volatile boolean ended = false;

        public int getTotalNodesChecked() {
            return this.nodesChecked + this.transportsChecked;
        }

        public long getElapsedTimeNanos() {
            return this.endNanos - this.startNanos;
        }

        private void start() {
            this.started = true;
            this.nodesChecked = 0;
            this.transportsChecked = 0;
            this.startNanos = System.nanoTime();
        }

        private void end() {
            this.endNanos = System.nanoTime();
            this.ended = true;
        }

        public int getNodesChecked() {
            return this.nodesChecked;
        }

        public int getTransportsChecked() {
            return this.transportsChecked;
        }
    }
}

