/*
 * Decompiled with CFR 0.152.
 */
package Posiedien_Leagues_Planner.pathfinder;

import java.util.BitSet;
import java.util.Locale;

public class FlagMap {
    private static final byte FLAG_COUNT = 2;
    private final BitSet flags;
    private final byte planeCount;
    public final int minX;
    public final int minY;

    public FlagMap(int minX, int minY, byte planeCount) {
        this.minX = minX;
        this.minY = minY;
        this.planeCount = planeCount;
        this.flags = new BitSet(4096 * planeCount * 2);
    }

    public FlagMap(int minX, int minY, byte[] bytes) {
        this.minX = minX;
        this.minY = minY;
        this.flags = BitSet.valueOf(bytes);
        int scale = 8192;
        this.planeCount = (byte)((this.flags.size() + scale - 1) / scale);
    }

    public byte[] toBytes() {
        return this.flags.toByteArray();
    }

    public boolean get(int x, int y, int z, int flag) {
        if (x < this.minX || x >= this.minX + 64 || y < this.minY || y >= this.minY + 64 || z < 0 || z >= this.planeCount) {
            return false;
        }
        return this.flags.get(this.index(x, y, z, flag));
    }

    public void set(int x, int y, int z, int flag, boolean value) {
        this.flags.set(this.index(x, y, z, flag), value);
    }

    private int index(int x, int y, int z, int flag) {
        if (x < this.minX || x >= this.minX + 64 || y < this.minY || y >= this.minY + 64 || z < 0 || z >= this.planeCount || flag < 0 || flag >= 2) {
            throw new IndexOutOfBoundsException(String.format(Locale.ENGLISH, "[%d,%d,%d,%d] when extents are [>=%d,>=%d,>=%d,>=%d] - [<=%d,<=%d,<%d,<%d]", x, y, z, flag, this.minX, this.minY, 0, 0, this.minX + 64 - 1, this.minY + 64 - 1, this.planeCount, (byte)2));
        }
        return (z * 64 * 64 + (y - this.minY) * 64 + (x - this.minX)) * 2 + flag;
    }

    public byte getPlaneCount() {
        return this.planeCount;
    }
}

