/*
 * Decompiled with CFR 0.152.
 */
package Posiedien_Leagues_Planner.pathfinder;

import Posiedien_Leagues_Planner.Transport;
import Posiedien_Leagues_Planner.WorldPointUtil;
import Posiedien_Leagues_Planner.pathfinder.Node;
import Posiedien_Leagues_Planner.pathfinder.OrdinalDirection;
import Posiedien_Leagues_Planner.pathfinder.PathfinderConfig;
import Posiedien_Leagues_Planner.pathfinder.SplitFlagMap;
import Posiedien_Leagues_Planner.pathfinder.TransportNode;
import Posiedien_Leagues_Planner.pathfinder.VisitedTiles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CollisionMap {
    PathfinderConfig CachedConfig = null;
    public boolean bJustFindingOverworld = false;
    private static final OrdinalDirection[] ORDINAL_VALUES = OrdinalDirection.values();
    private final SplitFlagMap collisionData;
    private final List<Node> neighbors = new ArrayList<Node>(16);
    private final boolean[] traversable = new boolean[8];

    public byte[] getPlanes() {
        return this.collisionData.getRegionMapPlaneCounts();
    }

    public CollisionMap(SplitFlagMap collisionData) {
        this.collisionData = collisionData;
    }

    private boolean get(int x, int y, int z, int flag) {
        return this.collisionData.get(x, y, z, flag);
    }

    public boolean n(int x, int y, int z) {
        return this.get(x, y, z, 0);
    }

    public boolean s(int x, int y, int z) {
        return this.n(x, y - 1, z);
    }

    public boolean e(int x, int y, int z) {
        return this.get(x, y, z, 1);
    }

    public boolean w(int x, int y, int z) {
        return this.e(x - 1, y, z);
    }

    private boolean ne(int x, int y, int z) {
        return this.n(x, y, z) && this.e(x, y + 1, z) && this.e(x, y, z) && this.n(x + 1, y, z);
    }

    private boolean nw(int x, int y, int z) {
        return this.n(x, y, z) && this.w(x, y + 1, z) && this.w(x, y, z) && this.n(x - 1, y, z);
    }

    private boolean se(int x, int y, int z) {
        return this.s(x, y, z) && this.e(x, y - 1, z) && this.e(x, y, z) && this.s(x + 1, y, z);
    }

    private boolean sw(int x, int y, int z) {
        return this.s(x, y, z) && this.w(x, y - 1, z) && this.w(x, y, z) && this.s(x - 1, y, z);
    }

    public boolean isBlocked(int x, int y, int z) {
        return !this.n(x, y, z) && !this.s(x, y, z) && !this.e(x, y, z) && !this.w(x, y, z);
    }

    private static int packedPointFromOrdinal(int startPacked, OrdinalDirection direction) {
        int x = WorldPointUtil.unpackWorldX(startPacked);
        int y = WorldPointUtil.unpackWorldY(startPacked);
        int plane = WorldPointUtil.unpackWorldPlane(startPacked);
        return WorldPointUtil.packWorldPoint(x + direction.x, y + direction.y, plane);
    }

    public List<Node> getNeighbors(Node node, VisitedTiles visited, PathfinderConfig config) {
        int i;
        int x = WorldPointUtil.unpackWorldX(node.packedPosition);
        int y = WorldPointUtil.unpackWorldY(node.packedPosition);
        int z = WorldPointUtil.unpackWorldPlane(node.packedPosition);
        this.neighbors.clear();
        List<Transport> transports = config.getTransportsPacked().getOrDefault(node.packedPosition, Collections.EMPTY_LIST);
        this.CachedConfig = config;
        for (i = 0; i < transports.size(); ++i) {
            Transport transport = transports.get(i);
            if (visited.get(transport.getDestination())) continue;
            this.neighbors.add(new TransportNode(transport.getDestination(), node, transport.getWait()));
        }
        if (this.isBlocked(x, y, z)) {
            boolean westBlocked = this.isBlocked(x - 1, y, z);
            boolean eastBlocked = this.isBlocked(x + 1, y, z);
            boolean southBlocked = this.isBlocked(x, y - 1, z);
            boolean northBlocked = this.isBlocked(x, y + 1, z);
            boolean southWestBlocked = this.isBlocked(x - 1, y - 1, z);
            boolean southEastBlocked = this.isBlocked(x + 1, y - 1, z);
            boolean northWestBlocked = this.isBlocked(x - 1, y + 1, z);
            boolean northEastBlocked = this.isBlocked(x + 1, y + 1, z);
            this.traversable[0] = !westBlocked;
            this.traversable[1] = !eastBlocked;
            this.traversable[2] = !southBlocked;
            this.traversable[3] = !northBlocked;
            this.traversable[4] = !southWestBlocked && !westBlocked && !southBlocked;
            this.traversable[5] = !southEastBlocked && !eastBlocked && !southBlocked;
            this.traversable[6] = !northWestBlocked && !westBlocked && !northBlocked;
            this.traversable[7] = !northEastBlocked && !eastBlocked && !northBlocked;
        } else {
            this.traversable[0] = this.w(x, y, z);
            this.traversable[1] = this.e(x, y, z);
            this.traversable[2] = this.s(x, y, z);
            this.traversable[3] = this.n(x, y, z);
            this.traversable[4] = this.sw(x, y, z);
            this.traversable[5] = this.se(x, y, z);
            this.traversable[6] = this.nw(x, y, z);
            this.traversable[7] = this.ne(x, y, z);
        }
        for (i = 0; i < this.traversable.length; ++i) {
            OrdinalDirection d = ORDINAL_VALUES[i];
            int neighborPacked = CollisionMap.packedPointFromOrdinal(node.packedPosition, d);
            if (visited.get(neighborPacked)) continue;
            if (this.traversable[i]) {
                this.neighbors.add(new Node(neighborPacked, node));
                continue;
            }
            if (Math.abs(d.x + d.y) != 1 || !this.isBlocked(x + d.x, y + d.y, z)) continue;
            List<Transport> neighborTransports = config.getTransportsPacked().getOrDefault(neighborPacked, Collections.EMPTY_LIST);
            for (int t = 0; t < neighborTransports.size(); ++t) {
                Transport transport = neighborTransports.get(t);
                if (visited.get(transport.getOrigin())) continue;
                this.neighbors.add(new Node(transport.getOrigin(), node));
            }
        }
        return this.neighbors;
    }
}

