/*
 * Decompiled with CFR 0.152.
 */
package Posiedien_Leagues_Planner;

import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;

public class WorldPointUtil {
    public static int packWorldPoint(WorldPoint point) {
        return WorldPointUtil.packWorldPoint(point.getX(), point.getY(), point.getPlane());
    }

    public static int packWorldPoint(int x, int y, int plane) {
        return x & Short.MAX_VALUE | (y & Short.MAX_VALUE) << 15 | (plane & 3) << 30;
    }

    public static WorldPoint unpackWorldPoint(int packedPoint) {
        int x = WorldPointUtil.unpackWorldX(packedPoint);
        int y = WorldPointUtil.unpackWorldY(packedPoint);
        int plane = WorldPointUtil.unpackWorldPlane(packedPoint);
        return new WorldPoint(x, y, plane);
    }

    public static int unpackWorldX(int packedPoint) {
        return packedPoint & Short.MAX_VALUE;
    }

    public static int unpackWorldY(int packedPoint) {
        return packedPoint >> 15 & Short.MAX_VALUE;
    }

    public static int unpackWorldPlane(int packedPoint) {
        return packedPoint >> 30 & 3;
    }

    public static int distanceBetween(int previousPacked, int currentPacked) {
        return WorldPointUtil.distanceBetween(previousPacked, currentPacked, 1);
    }

    public static int distanceBetween(int previousPacked, int currentPacked, int diagonal) {
        int previousX = WorldPointUtil.unpackWorldX(previousPacked);
        int previousY = WorldPointUtil.unpackWorldY(previousPacked);
        int currentX = WorldPointUtil.unpackWorldX(currentPacked);
        int currentY = WorldPointUtil.unpackWorldY(currentPacked);
        int dx = Math.abs(previousX - currentX);
        int dy = Math.abs(previousY - currentY);
        if (diagonal == 1) {
            return Math.max(dx, dy);
        }
        if (diagonal == 2) {
            return dx + dy;
        }
        return Integer.MAX_VALUE;
    }

    public static int distanceBetween(WorldPoint previous, WorldPoint current) {
        return WorldPointUtil.distanceBetween(previous, current, 1);
    }

    public static int distanceBetween(WorldPoint previous, WorldPoint current, int diagonal) {
        int dx = Math.abs(previous.getX() - current.getX());
        int dy = Math.abs(previous.getY() - current.getY());
        if (diagonal == 1) {
            return Math.max(dx, dy);
        }
        if (diagonal == 2) {
            return dx + dy;
        }
        return Integer.MAX_VALUE;
    }

    public static int distanceToArea(int packedPoint, WorldArea area) {
        int plane = WorldPointUtil.unpackWorldPlane(packedPoint);
        if (area.getPlane() != plane) {
            return Integer.MAX_VALUE;
        }
        int y = WorldPointUtil.unpackWorldY(packedPoint);
        int x = WorldPointUtil.unpackWorldX(packedPoint);
        int areaMaxX = area.getX() + area.getWidth() - 1;
        int areaMaxY = area.getY() + area.getHeight() - 1;
        int dx = Math.max(Math.max(area.getX() - x, 0), x - areaMaxX);
        int dy = Math.max(Math.max(area.getY() - y, 0), y - areaMaxY);
        return Math.max(dx, dy);
    }
}

