/*
 * Decompiled with CFR 0.152.
 */
package Posiedien_Leagues_Planner;

import Posiedien_Leagues_Planner.LeaguesPlannerConfig;
import Posiedien_Leagues_Planner.PosiedienLeaguesPlannerPlugin;
import Posiedien_Leagues_Planner.TaskData;
import Posiedien_Leagues_Planner.TaskDifficulty;
import Posiedien_Leagues_Planner.TaskSortData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Map;
import java.util.UUID;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.FontUIResource;
import net.runelite.api.Player;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.ImageUtil;

public class TaskSelectPanel
extends JPanel {
    private static final ImageIcon START_ICON = new ImageIcon(ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/start.png"));
    private static final ImageIcon UNCHECKED_ICON = new ImageIcon(ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/unchecked.png"));
    private static final ImageIcon CHECKED_ICON = new ImageIcon(ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/checked.png"));
    private static final ImageIcon HIDDEN_ICON = new ImageIcon(ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/HIDDEN.png"));
    private static final ImageIcon SHOWN_ICON = new ImageIcon(ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/SHOWN.png"));
    private static final ImageIcon LOCATE_ICON = new ImageIcon(ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/taskMarker.png"));
    private static final ImageIcon LOCATE_BEGINNER_ICON = new ImageIcon(ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/taskMarkerBeginner.png"));
    private static final ImageIcon LOCATE_EASY_ICON = new ImageIcon(ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/taskMarkerEasy.png"));
    private static final ImageIcon LOCATE_MEDIUM_ICON = new ImageIcon(ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/taskMarkerMedium.png"));
    private static final ImageIcon LOCATE_HARD_ICON = new ImageIcon(ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/taskMarkerHard.png"));
    private static final ImageIcon LOCATE_ELITE_ICON = new ImageIcon(ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/taskMarkerElite.png"));
    private static final ImageIcon LOCATE_MASTER_ICON = new ImageIcon(ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/taskMarkerMaster.png"));
    private static final ImageIcon LOCATE_CUSTOM_ICON = new ImageIcon(ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/taskMarker.png"));
    private static final ImageIcon CLOSE_ICON = new ImageIcon(ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/close.png"));
    public PosiedienLeaguesPlannerPlugin plugin;
    public TaskData taskData;

    public TaskSelectPanel(PosiedienLeaguesPlannerPlugin InPlugin, TaskData inTask) {
        double DistanceFromPlayer;
        this.plugin = InPlugin;
        this.taskData = inTask;
        this.setLayout(new BorderLayout(3, 0));
        this.setPreferredSize(new Dimension(225, 70));
        double ShortestDistance = 1000000.0;
        Player player = this.plugin.client.getLocalPlayer();
        if (player != null) {
            double TaskDistance;
            WorldPoint playerLocation = player.getWorldLocation();
            for (WorldPoint CurrentLocation : this.taskData.Locations) {
                TaskDistance = CurrentLocation.distanceTo(playerLocation);
                if (!(TaskDistance < ShortestDistance)) continue;
                ShortestDistance = TaskDistance;
            }
            for (WorldPoint CurrentLocation : this.taskData.OverworldLocations) {
                TaskDistance = CurrentLocation.distanceTo(playerLocation);
                if (!(TaskDistance < ShortestDistance)) continue;
                ShortestDistance = TaskDistance;
            }
        }
        if ((DistanceFromPlayer = ShortestDistance) > 900000.0) {
            DistanceFromPlayer = 0.0;
        }
        String DistanceText = DistanceFromPlayer == 0.0 ? "?" : String.valueOf(DistanceFromPlayer);
        Color color = Color.LIGHT_GRAY;
        JPanel ButtonCombo = new JPanel();
        ButtonCombo.setBorder(new EmptyBorder(0, 0, 0, 0));
        ButtonCombo.setLayout(new BorderLayout());
        JButton markHiddenButton = new JButton();
        markHiddenButton.setBorder(new EmptyBorder(10, 0, 10, 0));
        LeaguesPlannerConfig cfr_ignored_0 = this.plugin.config;
        boolean bIsPlanned = LeaguesPlannerConfig.UserData.PlannedTasks.containsKey(this.taskData.GUID);
        if (bIsPlanned) {
            color = TaskDifficulty.GetTaskDifficultyColor(this.taskData.Difficulty);
        }
        LeaguesPlannerConfig cfr_ignored_1 = this.plugin.config;
        boolean bIsCompleted = LeaguesPlannerConfig.UserData.CompletedTasks.contains(this.taskData.GUID);
        if (bIsCompleted) {
            color = Color.GREEN;
        }
        LeaguesPlannerConfig cfr_ignored_2 = this.plugin.config;
        boolean bIsHidden = LeaguesPlannerConfig.UserData.HiddenTasks.contains(this.taskData.GUID);
        if (bIsHidden) {
            markHiddenButton.setIcon(HIDDEN_ICON);
            color = Color.BLACK;
        } else {
            markHiddenButton.setIcon(SHOWN_ICON);
        }
        if (this.taskData.bIsCustomTask.booleanValue()) {
            TextField editableText = new TextField();
            editableText.setText(String.valueOf(this.taskData.TaskName));
            editableText.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            FontUIResource EditTestFont = new FontUIResource("EditTestFont", 0, 10);
            editableText.setFont(EditTestFont);
            editableText.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TaskSelectPanel.this.plugin.QueueRefresh();
                }
            });
            editableText.addTextListener(new TextListener(){

                @Override
                public void textValueChanged(TextEvent e) {
                    TaskSelectPanel.this.taskData.TaskName = ((TextField)e.getSource()).getText();
                }
            });
            this.add((Component)editableText, "Center");
        } else {
            String LabelString = "Dist: " + DistanceText + ", " + this.taskData.TaskName;
            JLabel nameLabel = new JLabel("<html>" + LabelString + "</html>");
            nameLabel.setForeground(color);
            this.add((Component)nameLabel, "Center");
        }
        markHiddenButton.addActionListener(e -> {
            LeaguesPlannerConfig cfr_ignored_0 = this.plugin.config;
            boolean bLocalIsHidden = LeaguesPlannerConfig.UserData.HiddenTasks.contains(this.taskData.GUID);
            if (bLocalIsHidden) {
                LeaguesPlannerConfig cfr_ignored_1 = this.plugin.config;
                LeaguesPlannerConfig.UserData.HiddenTasks.remove(this.taskData.GUID);
            } else {
                LeaguesPlannerConfig cfr_ignored_2 = this.plugin.config;
                LeaguesPlannerConfig.UserData.HiddenTasks.add(this.taskData.GUID);
                LeaguesPlannerConfig cfr_ignored_3 = this.plugin.config;
                LeaguesPlannerConfig.UserData.PlannedTasks.remove(this.taskData.GUID);
            }
            this.plugin.QueueRefresh();
        });
        ButtonCombo.add((Component)markHiddenButton, "North");
        JPanel ButtonComboContainer = new JPanel();
        ButtonComboContainer.setBorder(new EmptyBorder(0, 0, 0, 0));
        ButtonComboContainer.setLayout(new BorderLayout());
        JPanel ButtonCombo2 = new JPanel();
        ButtonCombo2.setBorder(new EmptyBorder(0, 0, 0, 0));
        ButtonCombo2.setLayout(new BorderLayout());
        JButton locateTaskButton = new JButton();
        locateTaskButton.setBorder(new EmptyBorder(3, 0, 3, 0));
        switch (this.taskData.Difficulty) {
            case BEGINNER: {
                locateTaskButton.setIcon(LOCATE_BEGINNER_ICON);
                break;
            }
            case EASY: {
                locateTaskButton.setIcon(LOCATE_EASY_ICON);
                break;
            }
            case MEDIUM: {
                locateTaskButton.setIcon(LOCATE_MEDIUM_ICON);
                break;
            }
            case HARD: {
                locateTaskButton.setIcon(LOCATE_HARD_ICON);
                break;
            }
            case ELITE: {
                locateTaskButton.setIcon(LOCATE_ELITE_ICON);
                break;
            }
            case MASTER: {
                locateTaskButton.setIcon(LOCATE_MASTER_ICON);
                break;
            }
            case CUSTOM: {
                locateTaskButton.setIcon(LOCATE_ICON);
            }
        }
        locateTaskButton.addActionListener(e -> this.plugin.FocusOnTaskOnWorldMap(this.taskData));
        JButton removeTaskFromPlanButton = new JButton();
        removeTaskFromPlanButton.setBorder(new EmptyBorder(3, 0, 3, 0));
        removeTaskFromPlanButton.setIcon(CLOSE_ICON);
        removeTaskFromPlanButton.addActionListener(e -> {
            LeaguesPlannerConfig cfr_ignored_0 = this.plugin.config;
            boolean bLocalIsPlanned = LeaguesPlannerConfig.UserData.PlannedTasks.containsKey(this.taskData.GUID);
            if (bLocalIsPlanned) {
                LeaguesPlannerConfig cfr_ignored_1 = this.plugin.config;
                LeaguesPlannerConfig.UserData.PlannedTasks.remove(this.taskData.GUID);
            } else if (this.taskData.bIsCustomTask.booleanValue()) {
                LeaguesPlannerConfig cfr_ignored_2 = this.plugin.config;
                LeaguesPlannerConfig.UserData.CustomTasks.remove(this.taskData.GUID);
                LeaguesPlannerConfig cfr_ignored_3 = this.plugin.config;
                LeaguesPlannerConfig.UserData.PlannedTasks.remove(this.taskData.GUID);
                this.plugin.bMapDisplayPointsDirty = true;
            }
            this.plugin.QueueRefresh();
        });
        ButtonCombo2.add((Component)locateTaskButton, "North");
        if (bIsPlanned || this.taskData.bIsCustomTask.booleanValue()) {
            ButtonCombo2.add((Component)removeTaskFromPlanButton, "South");
        }
        if (bIsPlanned) {
            TextField activeOrder = new TextField();
            activeOrder.setPreferredSize(new Dimension(markHiddenButton.getWidth(), 30));
            activeOrder.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            LeaguesPlannerConfig cfr_ignored_3 = this.plugin.config;
            activeOrder.setText(String.valueOf(LeaguesPlannerConfig.UserData.PlannedTasks.get((Object)this.taskData.GUID).SortPriority));
            activeOrder.addTextListener(new TextListener(){

                @Override
                public void textValueChanged(TextEvent e) {
                    try {
                        int n = Integer.parseInt(((TextField)e.getSource()).getText());
                    }
                    catch (NumberFormatException nfe) {
                        TaskSelectPanel.this.plugin.QueueRefresh();
                        return;
                    }
                    LeaguesPlannerConfig cfr_ignored_0 = TaskSelectPanel.this.plugin.config;
                    LeaguesPlannerConfig.UserData.PlannedTasks.remove(TaskSelectPanel.this.taskData.GUID);
                    LeaguesPlannerConfig cfr_ignored_1 = TaskSelectPanel.this.plugin.config;
                    LeaguesPlannerConfig.UserData.PlannedTasks.put(TaskSelectPanel.this.taskData.GUID, new TaskSortData(Integer.valueOf(((TextField)e.getSource()).getText()), TaskSelectPanel.this.taskData.bIsCustomTask));
                    LeaguesPlannerConfig cfr_ignored_2 = TaskSelectPanel.this.plugin.config;
                    LeaguesPlannerConfig.UserData.HiddenTasks.remove(TaskSelectPanel.this.taskData.GUID);
                    TaskSelectPanel.this.plugin.QueueRefresh();
                }
            });
            ButtonCombo.add((Component)activeOrder, "South");
        } else {
            JButton startButton = new JButton();
            startButton.setBorder(new EmptyBorder(10, 0, 10, 0));
            startButton.setIcon(START_ICON);
            startButton.addActionListener(e -> {
                int CurrentOrder = 0;
                LeaguesPlannerConfig cfr_ignored_0 = this.plugin.config;
                for (Map.Entry<UUID, TaskSortData> mapElement : LeaguesPlannerConfig.UserData.PlannedTasks.entrySet()) {
                    if (mapElement.getValue().SortPriority <= CurrentOrder) continue;
                    CurrentOrder = mapElement.getValue().SortPriority;
                }
                LeaguesPlannerConfig cfr_ignored_1 = this.plugin.config;
                LeaguesPlannerConfig.UserData.PlannedTasks.put(this.taskData.GUID, new TaskSortData(CurrentOrder + 1, this.taskData.bIsCustomTask));
                LeaguesPlannerConfig cfr_ignored_2 = this.plugin.config;
                LeaguesPlannerConfig.UserData.HiddenTasks.remove(this.taskData.GUID);
                this.plugin.bMapDisplayPointsDirty = true;
                this.plugin.QueueRefresh();
            });
            ButtonCombo.add((Component)startButton, "South");
        }
        ButtonComboContainer.add((Component)ButtonCombo, "East");
        ButtonComboContainer.add((Component)ButtonCombo2, "West");
        this.add((Component)ButtonComboContainer, "After");
    }
}

