/*
 * Decompiled with CFR 0.152.
 */
package Posiedien_Leagues_Planner;

import Posiedien_Leagues_Planner.FilterRequirements;
import Posiedien_Leagues_Planner.LeaguesPlannerConfig;
import Posiedien_Leagues_Planner.OtherFilter;
import Posiedien_Leagues_Planner.PosiedienLeaguesPlannerPlugin;
import Posiedien_Leagues_Planner.RegionType;
import Posiedien_Leagues_Planner.SortedTask;
import Posiedien_Leagues_Planner.TaskData;
import Posiedien_Leagues_Planner.TaskDifficulty;
import Posiedien_Leagues_Planner.TaskDisplayPoint;
import Posiedien_Leagues_Planner.pathfinder.Pathfinder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.inject.Inject;
import javax.swing.plaf.FontUIResource;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.api.worldmap.WorldMap;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.worldmap.WorldMapOverlay;
import net.runelite.client.util.ImageUtil;

public class TaskOverlay
extends Overlay {
    private final Client client;
    private final PosiedienLeaguesPlannerPlugin plugin;
    private final LeaguesPlannerConfig config;
    public WorldMapOverlay worldMapOverlay;
    private Area WorldMapClipArea;
    HashMap<UUID, TaskDisplayPoint> CachedTaskDisplayPoints = new HashMap();
    HashMap<UUID, HashSet<UUID>> TaskToDisplayPoints = new HashMap();
    float CachedZoomLevel = -100.0f;
    public TaskDifficulty DiffFilter = TaskDifficulty.NONE;
    public OtherFilter OthFilter = OtherFilter.NONE;
    public FilterRequirements ReqFilter = FilterRequirements.NONE;
    public HashSet<RegionType> RegionsUnlocked = new HashSet();
    public HashSet<RegionType> TempRegionsUnlocked = new HashSet();
    boolean bDisplayPointTaskInProgress = false;
    boolean bCancelDisplayPointTaskInProgress = false;
    private static final BufferedImage TASK_IMAGE = ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/TaskIcon.png");
    private static final BufferedImage HIGHLIGHTED_TASK_IMAGE = ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/HighlightedTaskIcon.png");
    private static final BufferedImage PLANNED_TASK_IMAGE = ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/PlannedTaskIcon.png");
    private static final BufferedImage PLANNED_HIGHLIGHTED_TASK_IMAGE = ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/HighlightedPlannedTaskIcon.png");
    private static final BufferedImage TASK_IMAGE_DUNGEON = ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/TaskIconDungeon.png");
    private static final BufferedImage HIGHLIGHTED_TASK_IMAGE_DUNGEON = ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/HighlightedTaskIconDungeon.png");
    private static final BufferedImage PLANNED_TASK_IMAGE_DUNGEON = ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/PlannedTaskIconDungeon.png");
    private static final BufferedImage PLANNED_HIGHLIGHTED_TASK_IMAGE_DUNGEON = ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/HighlightedPlannedTaskIconDungeon.png");
    private static final BufferedImage BEGINNER_IMAGE = ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/Beginner.png");
    private static final BufferedImage EASY_IMAGE = ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/Easy.png");
    private static final BufferedImage MEDIUM_IMAGE = ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/Medium.png");
    private static final BufferedImage HARD_IMAGE = ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/Hard.png");
    private static final BufferedImage ELITE_IMAGE = ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/Elite.png");
    private static final BufferedImage MASTER_IMAGE = ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/Master.png");
    private static final BufferedImage CUSTOM_IMAGE = ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/Custom.png");
    private static final BufferedImage DUNGEON_IMAGE = ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/DungeonIcon.png");
    private static final BufferedImage BLANK_IMAGE = ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/BlankIcon.png");

    public ArrayList<TaskDisplayPoint> GetClickedDisplayPoint(WorldPoint ClickedPoint) {
        ArrayList<TaskDisplayPoint> OutDisplayPointsClicked = new ArrayList<TaskDisplayPoint>();
        Point ClickedGraphicsPoint = this.worldMapOverlay.mapWorldPointToGraphicsPoint(ClickedPoint);
        for (Map.Entry<UUID, TaskDisplayPoint> CurrentTaskPair : this.CachedTaskDisplayPoints.entrySet()) {
            TaskDisplayPoint CurrentDisplayPoint = CurrentTaskPair.getValue();
            Point DisplayGraphicsPoint = this.worldMapOverlay.mapWorldPointToGraphicsPoint(CurrentDisplayPoint.MapDisplayPoint);
            if (DisplayGraphicsPoint == null) continue;
            int TaskIconSize = this.config.TaskMapIconSize();
            int TaskCount = Math.min(CurrentDisplayPoint.Tasks.size(), 5);
            if (this.config.ScaleTaskMapIconBasedOnCount()) {
                TaskIconSize += (int)((float)(this.config.TaskMapIconSize() * TaskCount) * (1.0f / (float)this.config.ScaleTaskMapIconBasedOnCountInvRate()));
            }
            if (ClickedGraphicsPoint.distanceTo(DisplayGraphicsPoint) >= TaskIconSize) continue;
            OutDisplayPointsClicked.add(CurrentDisplayPoint);
        }
        return OutDisplayPointsClicked;
    }

    private boolean ShouldMergeIntoDisplayPoint(TaskDisplayPoint DisplayPoint, WorldPoint InWorldPoint) {
        float MaxStackingDistance;
        if (DisplayPoint.MapDisplayPoint.getPlane() != InWorldPoint.getPlane()) {
            return false;
        }
        Point GraphicsPoint = this.worldMapOverlay.mapWorldPointToGraphicsPoint(InWorldPoint);
        Point DisplayGraphicsPoint = this.worldMapOverlay.mapWorldPointToGraphicsPoint(DisplayPoint.MapDisplayPoint);
        if (GraphicsPoint == null) {
            return false;
        }
        if (DisplayGraphicsPoint == null) {
            return false;
        }
        float DistanceBetweenPoints = GraphicsPoint.distanceTo(DisplayGraphicsPoint);
        return DistanceBetweenPoints < (MaxStackingDistance = (float)this.config.TaskMapStackingDistance());
    }

    private void AddTaskWorldPointToDisplayPoints(UUID TaskGUID, boolean bIsCustomTask, WorldPoint InWorldPoint, boolean IsOverworldDungeon) {
        for (Map.Entry<UUID, TaskDisplayPoint> CurrentTaskPair : this.CachedTaskDisplayPoints.entrySet()) {
            TaskDisplayPoint CurrentDisplayPoint = CurrentTaskPair.getValue();
            if (!this.ShouldMergeIntoDisplayPoint(CurrentDisplayPoint, InWorldPoint)) continue;
            CurrentDisplayPoint.TaskWorldPoints.add(InWorldPoint);
            CurrentDisplayPoint.Tasks.put(TaskGUID, bIsCustomTask);
            if (IsOverworldDungeon) {
                CurrentDisplayPoint.DungeonTasks.put(TaskGUID, bIsCustomTask);
            }
            CurrentDisplayPoint.UpdateMapDisplayPoint();
            this.TaskToDisplayPoints.putIfAbsent(TaskGUID, new HashSet<UUID>(Collections.singleton(CurrentDisplayPoint.DisplayPointGUID)));
            this.TaskToDisplayPoints.get(TaskGUID).add(CurrentDisplayPoint.DisplayPointGUID);
            return;
        }
        TaskDisplayPoint NewDisplayPoint = new TaskDisplayPoint();
        NewDisplayPoint.TaskWorldPoints.add(InWorldPoint);
        NewDisplayPoint.Tasks.put(TaskGUID, bIsCustomTask);
        if (IsOverworldDungeon) {
            NewDisplayPoint.DungeonTasks.put(TaskGUID, bIsCustomTask);
        }
        NewDisplayPoint.UpdateMapDisplayPoint();
        NewDisplayPoint.DisplayPointGUID = UUID.randomUUID();
        this.CachedTaskDisplayPoints.put(NewDisplayPoint.DisplayPointGUID, NewDisplayPoint);
        this.TaskToDisplayPoints.putIfAbsent(TaskGUID, new HashSet<UUID>(Collections.singleton(NewDisplayPoint.DisplayPointGUID)));
        this.TaskToDisplayPoints.get(TaskGUID).add(NewDisplayPoint.DisplayPointGUID);
    }

    private void AddTaskListToDisplayPointCache(HashMap<UUID, TaskData> TaskCache) {
        for (Map.Entry<UUID, TaskData> CurrentTaskPair : TaskCache.entrySet()) {
            boolean bIsPartOfPlan = LeaguesPlannerConfig.UserData.PlannedTasks.containsKey(CurrentTaskPair.getKey());
            if (!bIsPartOfPlan && this.DiffFilter != TaskDifficulty.NONE && this.DiffFilter != CurrentTaskPair.getValue().Difficulty) continue;
            LeaguesPlannerConfig cfr_ignored_0 = this.plugin.config;
            boolean bIsHidden = LeaguesPlannerConfig.UserData.HiddenTasks.contains(CurrentTaskPair.getKey());
            if (bIsHidden) continue;
            LeaguesPlannerConfig cfr_ignored_1 = this.plugin.config;
            boolean bIsCompleted = LeaguesPlannerConfig.UserData.CompletedTasks.contains(CurrentTaskPair.getKey());
            if (bIsCompleted) continue;
            int ReqDifferent = CurrentTaskPair.getValue().CalculateNeededRequirementsForTask(this.plugin.client);
            if (this.ReqFilter != FilterRequirements.MEETS_REQ ? this.ReqFilter == FilterRequirements.NEAR_REQ && ReqDifferent > 10 : ReqDifferent != 0) continue;
            if ((this.OthFilter == OtherFilter.ONLY_MAP_PLAN || this.OthFilter == OtherFilter.ONLY_PLAN) && !bIsPartOfPlan && !CurrentTaskPair.getValue().bIsCustomTask.booleanValue()) continue;
            boolean bSkipTask = false;
            for (RegionType ReqRegion : CurrentTaskPair.getValue().Regions) {
                if (RegionType.GetRegionUnlocked(this.config, ReqRegion)) continue;
                bSkipTask = true;
                break;
            }
            if (bSkipTask) continue;
            if (this.bCancelDisplayPointTaskInProgress) {
                return;
            }
            for (WorldPoint TaskWorldPoint : CurrentTaskPair.getValue().Locations) {
                if (!LeaguesPlannerConfig.RegionData.IsTileInUnlockedRegion(this.config, TaskWorldPoint)) continue;
                this.AddTaskWorldPointToDisplayPoints(CurrentTaskPair.getKey(), CurrentTaskPair.getValue().bIsCustomTask, TaskWorldPoint, false);
            }
            for (WorldPoint TaskOverworldWorldPoint : CurrentTaskPair.getValue().OverworldLocations) {
                if (!LeaguesPlannerConfig.RegionData.IsTileInUnlockedRegion(this.config, TaskOverworldWorldPoint)) continue;
                this.AddTaskWorldPointToDisplayPoints(CurrentTaskPair.getKey(), CurrentTaskPair.getValue().bIsCustomTask, TaskOverworldWorldPoint, true);
            }
        }
    }

    private void CacheDisplayPointsIfDirty() {
        WorldMap worldMap = this.client.getWorldMap();
        float zoom = worldMap.getWorldMapZoom();
        this.TempRegionsUnlocked.clear();
        for (RegionType CurrentRegion : RegionType.values()) {
            if (!RegionType.GetRegionUnlocked(this.config, CurrentRegion)) continue;
            this.TempRegionsUnlocked.add(CurrentRegion);
        }
        if (this.plugin.bMapDisplayPointsDirty || zoom != this.CachedZoomLevel || this.DiffFilter != this.config.FilteredDifficulty() || this.OthFilter != this.config.FilteredOther() || this.ReqFilter != this.config.FilteredRequirements() || !this.RegionsUnlocked.containsAll(this.TempRegionsUnlocked) || !this.TempRegionsUnlocked.containsAll(this.RegionsUnlocked)) {
            if (!this.bDisplayPointTaskInProgress) {
                this.plugin.bMapDisplayPointsDirty = false;
                this.CachedZoomLevel = zoom;
                this.DiffFilter = this.config.FilteredDifficulty();
                this.OthFilter = this.config.FilteredOther();
                this.ReqFilter = this.config.FilteredRequirements();
                this.RegionsUnlocked.clear();
                this.RegionsUnlocked.addAll(this.TempRegionsUnlocked);
                this.bDisplayPointTaskInProgress = true;
                this.plugin.getClientThread().invokeLater(() -> {
                    this.CachedTaskDisplayPoints.clear();
                    this.TaskToDisplayPoints.clear();
                    this.AddTaskListToDisplayPointCache(LeaguesPlannerConfig.TaskData.LeaguesTaskList);
                    this.AddTaskListToDisplayPointCache(LeaguesPlannerConfig.UserData.CustomTasks);
                    LeaguesPlannerConfig.UserData.CacheSortedPlannedTasks();
                    this.bCancelDisplayPointTaskInProgress = false;
                    this.bDisplayPointTaskInProgress = false;
                });
            } else {
                this.bCancelDisplayPointTaskInProgress = true;
            }
        }
    }

    @Inject
    public TaskOverlay(Client Inclient, PosiedienLeaguesPlannerPlugin InPlugin, LeaguesPlannerConfig Inconfig) {
        this.client = Inclient;
        this.plugin = InPlugin;
        this.config = Inconfig;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
    }

    private BufferedImage GetImageFromDifficulty(TaskDifficulty difficulty) {
        switch (difficulty) {
            case BEGINNER: {
                return BEGINNER_IMAGE;
            }
            case EASY: {
                return EASY_IMAGE;
            }
            case MEDIUM: {
                return MEDIUM_IMAGE;
            }
            case HARD: {
                return HARD_IMAGE;
            }
            case ELITE: {
                return ELITE_IMAGE;
            }
            case MASTER: {
                return MASTER_IMAGE;
            }
            case CUSTOM: {
                return CUSTOM_IMAGE;
            }
        }
        return BEGINNER_IMAGE;
    }

    public void RenderingChangingIconUI(Graphics2D graphics) {
        Point HighlightGraphicsPoint = new Point(0, 0);
        if (this.plugin.getSelectedWorldPoint() != null && (HighlightGraphicsPoint = this.worldMapOverlay.mapWorldPointToGraphicsPoint(this.plugin.getSelectedWorldPoint())) == null) {
            HighlightGraphicsPoint = new Point(0, 0);
        }
        int TotalIconCount = this.plugin.CustomIconsMap.size();
        int IconSize = 30;
        int IconSizeHalf = IconSize / 2;
        Rectangle2D Bounds = this.WorldMapClipArea.getBounds2D();
        int RowAndHeightSize = (int)Math.sqrt(TotalIconCount);
        int i = 0;
        for (Map.Entry<String, BufferedImage> CustomIcon : this.plugin.CustomIconsMap.entrySet()) {
            int OffsetX = (int)(Bounds.getCenterX() - (double)(RowAndHeightSize / 2 * IconSize));
            int OffsetY = (int)(Bounds.getCenterY() - (double)(RowAndHeightSize / 2 * IconSize));
            Point IconPoint = new Point(OffsetX += i % RowAndHeightSize * IconSize, OffsetY += i / RowAndHeightSize * IconSize);
            if (HighlightGraphicsPoint.distanceTo(IconPoint) < IconSizeHalf) {
                int HighlightedSize = (int)((float)IconSize * 1.5f);
                int HighlightedHalf = HighlightedSize / 2;
                graphics.drawImage(PosiedienLeaguesPlannerPlugin.BOUNDS_SELECTED, OffsetX - HighlightedHalf, OffsetY - HighlightedHalf, HighlightedSize, HighlightedSize, null);
            }
            graphics.drawImage(CustomIcon.getValue(), OffsetX - IconSizeHalf, OffsetY - IconSizeHalf, IconSize, IconSize, null);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension render(Graphics2D graphics) {
        if (this.plugin.bIsInitializing) {
            return null;
        }
        if (this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW) == null) {
            return null;
        }
        this.WorldMapClipArea = this.plugin.ObtainWorldMapClipArea(Objects.requireNonNull(this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW)).getBounds());
        graphics.setClip(this.WorldMapClipArea);
        if (this.plugin.CustomTask_ChangingIcon != null) {
            this.RenderingChangingIconUI(graphics);
            return null;
        }
        this.CacheDisplayPointsIfDirty();
        if (this.bDisplayPointTaskInProgress) {
            return null;
        }
        ArrayList<OverlayQueuedText> QueuedTextCommands = new ArrayList<OverlayQueuedText>();
        Color taskIconFontColor = new Color(31, 58, 70, 255);
        Color highlightnamecolor2 = new Color(0, 0, 0, 255);
        boolean bSetHighlighted = false;
        for (Map.Entry<UUID, TaskDisplayPoint> CurrentTaskPair : this.CachedTaskDisplayPoints.entrySet()) {
            TaskDisplayPoint CurrentDisplayPoint = CurrentTaskPair.getValue();
            Point GraphicsPoint = this.worldMapOverlay.mapWorldPointToGraphicsPoint(CurrentDisplayPoint.MapDisplayPoint);
            if (GraphicsPoint == null || !this.WorldMapClipArea.contains(GraphicsPoint.getX(), GraphicsPoint.getY())) continue;
            ArrayList<BufferedImage> ImageModifiers = new ArrayList<BufferedImage>();
            HashSet<TaskDifficulty> DisplayPointDifficulties = new HashSet<TaskDifficulty>();
            BufferedImage OverrideImage = null;
            for (Map.Entry<UUID, Boolean> mapElement : CurrentDisplayPoint.Tasks.entrySet()) {
                TaskData CurrentTask = this.plugin.GetTaskData(mapElement.getKey(), mapElement.getValue());
                if (CurrentTask != null && !DisplayPointDifficulties.contains((Object)CurrentTask.Difficulty)) {
                    ImageModifiers.add(this.GetImageFromDifficulty(CurrentTask.Difficulty));
                    DisplayPointDifficulties.add(CurrentTask.Difficulty);
                }
                if (CurrentTask == null || CurrentTask.CustomIcon == null) continue;
                OverrideImage = this.plugin.CustomIconsMap.get(CurrentTask.CustomIcon);
            }
            int TaskCount = Math.min(CurrentDisplayPoint.Tasks.size(), 5);
            int TaskIconSize = this.config.TaskMapIconSize();
            if (this.config.ScaleTaskMapIconBasedOnCount()) {
                TaskIconSize += (int)((float)(this.config.TaskMapIconSize() * TaskCount) * (1.0f / (float)this.config.ScaleTaskMapIconBasedOnCountInvRate()));
            }
            int TaskIconSizeHalf = TaskIconSize / 2;
            String TaskWorldPointCountSize = String.valueOf(TaskCount);
            if (CurrentDisplayPoint.Tasks.size() > 9) {
                TaskWorldPointCountSize = "9+";
            }
            int TaskCharacterSize = TaskWorldPointCountSize.length();
            Object HighlightGraphicsPoint = new Point(0, 0);
            if (this.plugin.getSelectedWorldPoint() != null && (HighlightGraphicsPoint = this.worldMapOverlay.mapWorldPointToGraphicsPoint(this.plugin.getSelectedWorldPoint())) == null) {
                HighlightGraphicsPoint = new Point(0, 0);
            }
            boolean bIsTaskPlanned = false;
            for (Map.Entry<UUID, Boolean> mapElement : CurrentDisplayPoint.Tasks.entrySet()) {
                if (!LeaguesPlannerConfig.UserData.PlannedTasks.containsKey(mapElement.getKey())) continue;
                bIsTaskPlanned = true;
            }
            BufferedImage DrawImage = null;
            int HighlightedSize = (int)((float)TaskIconSize * 1.5f);
            int HighlightedHalf = HighlightedSize / 2;
            boolean bIsHighlighted = false;
            if (!bSetHighlighted && HighlightGraphicsPoint.distanceTo(GraphicsPoint) < TaskIconSize) {
                bIsHighlighted = true;
                bSetHighlighted = true;
                DrawImage = CurrentDisplayPoint.Tasks.size() == CurrentDisplayPoint.DungeonTasks.size() ? (bIsTaskPlanned ? PLANNED_HIGHLIGHTED_TASK_IMAGE_DUNGEON : HIGHLIGHTED_TASK_IMAGE_DUNGEON) : (bIsTaskPlanned ? PLANNED_HIGHLIGHTED_TASK_IMAGE : HIGHLIGHTED_TASK_IMAGE);
                if (OverrideImage != null) {
                    graphics.drawImage(PosiedienLeaguesPlannerPlugin.BOUNDS_SELECTED, GraphicsPoint.getX() - HighlightedHalf, GraphicsPoint.getY() - HighlightedHalf, HighlightedSize, HighlightedSize, null);
                }
            } else if (CurrentDisplayPoint.Tasks.size() == CurrentDisplayPoint.DungeonTasks.size()) {
                if (bIsTaskPlanned) {
                    DrawImage = PLANNED_TASK_IMAGE_DUNGEON;
                    if (OverrideImage != null) {
                        graphics.drawImage(PosiedienLeaguesPlannerPlugin.BOUNDS_SELECTED, GraphicsPoint.getX() - HighlightedHalf, GraphicsPoint.getY() - HighlightedHalf, HighlightedSize, HighlightedSize, null);
                    }
                } else {
                    DrawImage = TASK_IMAGE_DUNGEON;
                }
            } else if (bIsTaskPlanned) {
                DrawImage = PLANNED_TASK_IMAGE;
                if (OverrideImage != null) {
                    graphics.drawImage(PosiedienLeaguesPlannerPlugin.BOUNDS_SELECTED, GraphicsPoint.getX() - HighlightedHalf, GraphicsPoint.getY() - HighlightedHalf, HighlightedSize, HighlightedSize, null);
                }
            } else {
                DrawImage = TASK_IMAGE;
            }
            if (OverrideImage != null) {
                DrawImage = OverrideImage;
            }
            graphics.drawImage(DrawImage, GraphicsPoint.getX() - TaskIconSizeHalf, GraphicsPoint.getY() - TaskIconSizeHalf, TaskIconSize, TaskIconSize, null);
            int TaskIconModifierSize = TaskIconSize / 3;
            int RowCount = 4;
            for (int i = 0; i < ImageModifiers.size(); ++i) {
                BufferedImage Image2 = (BufferedImage)ImageModifiers.get(i);
                graphics.drawImage(Image2, GraphicsPoint.getX() + (i % RowCount - 2) * TaskIconModifierSize, GraphicsPoint.getY() - TaskIconSize + TaskIconModifierSize / 2 - i / RowCount * TaskIconModifierSize, TaskIconModifierSize, TaskIconModifierSize, null);
            }
            if (!CurrentDisplayPoint.DungeonTasks.isEmpty()) {
                graphics.drawImage(DUNGEON_IMAGE, GraphicsPoint.getX(), GraphicsPoint.getY(), (int)((float)TaskIconModifierSize * 2.0f), (int)((float)TaskIconModifierSize * 2.0f), null);
            }
            FontUIResource taskIconFont = new FontUIResource("TaskCountFont", 1, TaskIconSizeHalf);
            int TextIconTextOffsetY = -TaskIconSizeHalf / 2;
            int TextIconTextOffsetX = TaskIconSizeHalf / 4;
            QueuedTextCommands.add(new OverlayQueuedText(TaskWorldPointCountSize, 0, GraphicsPoint.getX() - TextIconTextOffsetX, GraphicsPoint.getY() - TextIconTextOffsetY, taskIconFont, taskIconFontColor));
            boolean bIsCloseToMouse = bIsHighlighted;
            if (!bIsTaskPlanned && !bIsCloseToMouse) continue;
            FontUIResource taskhighlightFont2 = new FontUIResource("taskhighlightFont2", 1, 15);
            int TaskNum2 = 0;
            for (Map.Entry<UUID, Boolean> mapElement : CurrentDisplayPoint.Tasks.entrySet()) {
                TaskData CurrentTask = this.plugin.GetTaskData(mapElement.getKey(), mapElement.getValue());
                Object ModifiedString = CurrentTask.TaskName;
                if (LeaguesPlannerConfig.UserData.PlannedTasks.containsKey(CurrentTask.GUID)) {
                    ModifiedString = (String)ModifiedString + " (" + LeaguesPlannerConfig.UserData.PlannedTasks.get((Object)CurrentTask.GUID).LastSortOrder + ")";
                }
                if (bIsCloseToMouse) {
                    QueuedTextCommands.add(new OverlayQueuedText((String)ModifiedString, 0, HighlightGraphicsPoint.getX() - 1, HighlightGraphicsPoint.getY() - TaskNum2 * 15 + 1, taskhighlightFont2, highlightnamecolor2));
                    ++TaskNum2;
                    continue;
                }
                if (!LeaguesPlannerConfig.UserData.PlannedTasks.containsKey(CurrentTask.GUID)) continue;
                QueuedTextCommands.add(new OverlayQueuedText((String)ModifiedString, 0, GraphicsPoint.getX() - 1, GraphicsPoint.getY() - TaskNum2 * 15 + 1, taskhighlightFont2, highlightnamecolor2));
                ++TaskNum2;
            }
            FontUIResource taskhighlightFont = new FontUIResource("taskhighlightFont", 1, 15);
            int TaskNum = 0;
            for (Map.Entry<UUID, Boolean> mapElement : CurrentDisplayPoint.Tasks.entrySet()) {
                TaskData CurrentTask = this.plugin.GetTaskData(mapElement.getKey(), mapElement.getValue());
                Object ModifiedString = CurrentTask.TaskName;
                if (LeaguesPlannerConfig.UserData.PlannedTasks.containsKey(CurrentTask.GUID)) {
                    ModifiedString = (String)ModifiedString + " (" + LeaguesPlannerConfig.UserData.PlannedTasks.get((Object)CurrentTask.GUID).LastSortOrder + ")";
                }
                if (bIsCloseToMouse) {
                    QueuedTextCommands.add(new OverlayQueuedText((String)ModifiedString, 0, HighlightGraphicsPoint.getX(), HighlightGraphicsPoint.getY() - TaskNum * 15, taskhighlightFont, TaskDifficulty.GetTaskDifficultyColor(CurrentTask.Difficulty)));
                    ++TaskNum;
                    continue;
                }
                if (!LeaguesPlannerConfig.UserData.PlannedTasks.containsKey(CurrentTask.GUID)) continue;
                QueuedTextCommands.add(new OverlayQueuedText((String)ModifiedString, 0, GraphicsPoint.getX(), GraphicsPoint.getY() - TaskNum * 15, taskhighlightFont, TaskDifficulty.GetTaskDifficultyColor(CurrentTask.Difficulty)));
                ++TaskNum;
            }
        }
        Player player = this.plugin.client.getLocalPlayer();
        ArrayList<Pathfinder> pathfinderArray = this.plugin.panel.getPathfinderArray();
        if (player != null) {
            graphics.setColor(new Color(255, 226, 1, 255));
            WorldPoint LastWorldPoint = player.getWorldLocation();
            WorldPoint LastActualWorldPoint = player.getWorldLocation();
            int SortTaskIter = 0;
            for (SortedTask SortedTaskIter : LeaguesPlannerConfig.UserData.SortedPlannedTasks) {
                TaskData CurrentTask = this.plugin.GetTaskData(SortedTaskIter.TaskGUID, SortedTaskIter.bIsCustomTask);
                float ClosestDistance = 9000000.0f;
                float ClosestActualDistance = 9000000.0f;
                WorldPoint ClosestWorldPoint = null;
                WorldPoint ClosestActualWorldPoint = null;
                if (CurrentTask == null || !this.TaskToDisplayPoints.containsKey(CurrentTask.GUID)) continue;
                for (UUID DisplayPointGUID : this.TaskToDisplayPoints.get(CurrentTask.GUID)) {
                    WorldPoint CurrentWorldPoint = this.CachedTaskDisplayPoints.get((Object)DisplayPointGUID).MapDisplayPoint;
                    float NextDistance = LastWorldPoint.distanceTo(CurrentWorldPoint);
                    if (!(NextDistance < ClosestDistance)) continue;
                    ClosestDistance = NextDistance;
                    ClosestWorldPoint = CurrentWorldPoint;
                }
                for (Object ActualLocation : CurrentTask.Locations) {
                    float NextDistance = LastActualWorldPoint.distanceTo(ActualLocation);
                    if (!(NextDistance < ClosestActualDistance)) continue;
                    ClosestActualDistance = NextDistance;
                    ClosestActualWorldPoint = ActualLocation;
                }
                if (this.plugin.panel.CurrentPathfinderIndex == SortTaskIter && pathfinderArray != null) {
                    Object ActualLocation;
                    boolean bIsCurrentPathfindingDone = false;
                    ActualLocation = this.plugin.panel.pathfinderMutex;
                    synchronized (ActualLocation) {
                        bIsCurrentPathfindingDone = pathfinderArray.isEmpty() || pathfinderArray.get(SortTaskIter - 1).isDone();
                    }
                    if (bIsCurrentPathfindingDone) {
                        ++this.plugin.panel.CurrentPathfinderIndex;
                        WorldPoint finalLastWorldPoint = LastActualWorldPoint;
                        WorldPoint finalClosestWorldPoint = ClosestActualWorldPoint;
                        this.plugin.getClientThread().invokeLater(() -> {
                            this.plugin.pathfinderConfig.refresh();
                            Object object = this.plugin.panel.pathfinderMutex;
                            synchronized (object) {
                                Pathfinder NewPathfinder = new Pathfinder(this.plugin.pathfinderConfig, finalLastWorldPoint, finalClosestWorldPoint, false);
                                this.plugin.panel.pathfinderArray.add(NewPathfinder);
                                this.plugin.panel.pathfinderFuture = this.plugin.panel.pathfindingExecutor.submit(NewPathfinder);
                            }
                        });
                    }
                }
                ++SortTaskIter;
                LastActualWorldPoint = ClosestActualWorldPoint;
                Point GraphicsStart = this.worldMapOverlay.mapWorldPointToGraphicsPoint(ClosestWorldPoint);
                if (GraphicsStart == null) {
                    LastWorldPoint = ClosestWorldPoint;
                    continue;
                }
                Point GraphicsEnd = this.worldMapOverlay.mapWorldPointToGraphicsPoint(LastWorldPoint);
                if (GraphicsEnd == null) {
                    LastWorldPoint = ClosestWorldPoint;
                    continue;
                }
                graphics.drawLine(GraphicsStart.getX(), GraphicsStart.getY(), GraphicsEnd.getX(), GraphicsEnd.getY());
                LastWorldPoint = ClosestWorldPoint;
            }
        }
        for (OverlayQueuedText CurrentTextCommand : QueuedTextCommands) {
            graphics.setFont(CurrentTextCommand.FontValue);
            graphics.setColor(CurrentTextCommand.ColorValue);
            graphics.drawChars(CurrentTextCommand.TextValue.toCharArray(), CurrentTextCommand.Offset, CurrentTextCommand.TextValue.length(), CurrentTextCommand.X, CurrentTextCommand.Y);
        }
        return null;
    }

    static class OverlayQueuedText {
        String TextValue;
        Font FontValue;
        Color ColorValue;
        int Offset;
        int X;
        int Y;

        public OverlayQueuedText(String taskWorldPointCountSize, int InOffset, int InX, int InY, Font taskIconFont, Color taskIconFontColor) {
            this.TextValue = taskWorldPointCountSize;
            this.FontValue = taskIconFont;
            this.ColorValue = taskIconFontColor;
            this.Offset = InOffset;
            this.X = InX;
            this.Y = InY;
        }
    }
}

