/*
 * Decompiled with CFR 0.152.
 */
package Posiedien_Leagues_Planner;

import Posiedien_Leagues_Planner.RegionType;
import Posiedien_Leagues_Planner.TaskDifficulty;
import java.util.ArrayList;
import java.util.UUID;
import net.runelite.api.Client;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.achievementdiary.CombatLevelRequirement;
import net.runelite.client.plugins.achievementdiary.Requirement;
import net.runelite.client.plugins.achievementdiary.SkillRequirement;

public class TaskData {
    UUID GUID = null;
    TaskDifficulty Difficulty;
    String TaskName = "Blank";
    String TaskDescription = "Blank";
    Boolean bIsCustomTask = false;
    String CustomIcon = null;
    ArrayList<RegionType> Regions = new ArrayList();
    ArrayList<WorldPoint> Locations = new ArrayList();
    ArrayList<WorldPoint> OverworldLocations = new ArrayList();
    ArrayList<Requirement> Requirements = new ArrayList();

    int CalculateNeededRequirementsForTask(Client client) {
        int OutReqDiff = 0;
        for (Requirement req : this.Requirements) {
            int SkillDiff;
            if (req.getClass() == SkillRequirement.class) {
                SkillRequirement SkillReq = (SkillRequirement)req;
                SkillDiff = SkillReq.getLevel() - client.getRealSkillLevel(SkillReq.getSkill());
                if (SkillDiff <= 0) continue;
                OutReqDiff += SkillDiff;
                continue;
            }
            if (req.getClass() == CombatLevelRequirement.class) {
                CombatLevelRequirement CombatReq = (CombatLevelRequirement)req;
                SkillDiff = CombatReq.getLevel() - client.getLocalPlayer().getCombatLevel();
                if (SkillDiff <= 0) continue;
                OutReqDiff += SkillDiff;
                continue;
            }
            if (req.satisfiesRequirement(client)) continue;
            ++OutReqDiff;
        }
        return OutReqDiff;
    }

    public String ExportUserDataFormat() {
        StringBuilder Converted = new StringBuilder();
        Converted.append(this.TaskName);
        Converted.append(",");
        Converted.append((Object)this.Difficulty);
        Converted.append(",");
        Converted.append(this.TaskDescription);
        Converted.append(",");
        Converted.append(this.GUID);
        Converted.append(",");
        Converted.append(this.bIsCustomTask);
        Converted.append(",");
        Converted.append(this.CustomIcon);
        Converted.append(",");
        Converted.append(this.Regions.size());
        Converted.append(",");
        for (RegionType CurrentRegion : this.Regions) {
            Converted.append((Object)CurrentRegion);
            Converted.append(",");
        }
        Converted.append(this.OverworldLocations.size());
        Converted.append(",");
        for (WorldPoint CurrentPoint : this.OverworldLocations) {
            Converted.append(CurrentPoint.getX());
            Converted.append(",");
            Converted.append(CurrentPoint.getY());
            Converted.append(",");
            Converted.append(CurrentPoint.getPlane());
            Converted.append(",");
        }
        Converted.append(this.Locations.size());
        Converted.append(",");
        for (WorldPoint CurrentPosition : this.Locations) {
            Converted.append(CurrentPosition.getX());
            Converted.append(",");
            Converted.append(CurrentPosition.getY());
            Converted.append(",");
            Converted.append(CurrentPosition.getPlane());
            Converted.append(",");
        }
        Converted.append(this.Requirements.size());
        Converted.append(",");
        for (Requirement CurrentRequirement : this.Requirements) {
            if (CurrentRequirement.getClass() == SkillRequirement.class) {
                SkillRequirement SkillReq = (SkillRequirement)CurrentRequirement;
                Converted.append(SkillReq.getSkill());
                Converted.append(",");
                Converted.append(SkillReq.getLevel());
            } else if (CurrentRequirement.getClass() == CombatLevelRequirement.class) {
                CombatLevelRequirement CombatReq = (CombatLevelRequirement)CurrentRequirement;
                Converted.append("COMBAT");
                Converted.append(",");
                Converted.append(CombatReq.getLevel());
            }
            Converted.append(",");
            Converted.append("\r\n");
        }
        return Converted.toString();
    }

    public String ExportData() {
        StringBuilder Converted = new StringBuilder();
        Converted.append(this.TaskName);
        Converted.append(",");
        Converted.append((Object)this.Difficulty);
        Converted.append(",");
        Converted.append(this.TaskDescription);
        Converted.append(",");
        Converted.append(this.GUID);
        Converted.append(",");
        Converted.append(this.bIsCustomTask);
        Converted.append(",");
        Converted.append(this.CustomIcon);
        Converted.append(",");
        Converted.append("Regions Count: ,");
        Converted.append(this.Regions.size());
        Converted.append(",");
        for (RegionType CurrentRegion : this.Regions) {
            Converted.append((Object)CurrentRegion);
            Converted.append(",");
        }
        Converted.append("Overworld Location Count (Auto-generated): ,");
        Converted.append(this.OverworldLocations.size());
        Converted.append(",");
        for (WorldPoint CurrentPoint : this.OverworldLocations) {
            Converted.append(CurrentPoint.getX());
            Converted.append(",");
            Converted.append(CurrentPoint.getY());
            Converted.append(",");
            Converted.append(CurrentPoint.getPlane());
            Converted.append(",");
        }
        Converted.append(",");
        Converted.append("\r\n");
        Converted.append("POSITIONS_START,");
        if (this.Locations.size() == 0) {
            Converted.append("NO_POSITIONS");
        } else {
            Converted.append("HAS_POSITIONS");
        }
        Converted.append(",");
        Converted.append("\r\n");
        Converted.append("X");
        Converted.append(",");
        Converted.append("Y");
        Converted.append(",");
        Converted.append("Z");
        Converted.append("\r\n");
        Converted.append(",");
        if (this.Locations.isEmpty()) {
            Converted.append("\r\n");
            Converted.append(",");
        }
        for (WorldPoint CurrentPosition : this.Locations) {
            Converted.append(CurrentPosition.getX());
            Converted.append(",");
            Converted.append(CurrentPosition.getY());
            Converted.append(",");
            Converted.append(CurrentPosition.getPlane());
            Converted.append(",");
            Converted.append("\r\n");
        }
        Converted.append("POSITIONS_END");
        Converted.append(",");
        Converted.append("\r\n");
        Converted.append(",");
        Converted.append("\r\n");
        Converted.append("REQUIREMENTS_START");
        Converted.append(",");
        Converted.append("\r\n");
        Converted.append("SKILL NAME");
        Converted.append(",");
        Converted.append("LEVEL REQUIREMENT");
        Converted.append(",");
        Converted.append("\r\n");
        for (Requirement CurrentRequirement : this.Requirements) {
            if (CurrentRequirement.getClass() == SkillRequirement.class) {
                SkillRequirement SkillReq = (SkillRequirement)CurrentRequirement;
                Converted.append(SkillReq.getSkill());
                Converted.append(",");
                Converted.append(SkillReq.getLevel());
            } else if (CurrentRequirement.getClass() == CombatLevelRequirement.class) {
                CombatLevelRequirement CombatReq = (CombatLevelRequirement)CurrentRequirement;
                Converted.append("COMBAT");
                Converted.append(",");
                Converted.append(CombatReq.getLevel());
            }
            Converted.append(",");
            Converted.append("\r\n");
        }
        Converted.append("REQUIREMENTS_END");
        Converted.append(",");
        Converted.append("\r\n");
        Converted.append(",");
        Converted.append("\r\n");
        return Converted.toString();
    }
}

