/*
 * Decompiled with CFR 0.152.
 */
package Posiedien_Leagues_Planner;

import Posiedien_Leagues_Planner.GraphicsLine;
import Posiedien_Leagues_Planner.LeagueRegionBounds;
import Posiedien_Leagues_Planner.LeaguesPlannerConfig;
import Posiedien_Leagues_Planner.PosiedienLeaguesPlannerPlugin;
import Posiedien_Leagues_Planner.RegionLine;
import Posiedien_Leagues_Planner.RegionType;
import Posiedien_Leagues_Planner.WorldPointPolygon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Area;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.worldmap.WorldMapOverlay;

public class RegionBoundOverlay
extends Overlay {
    private final Client client;
    private final PosiedienLeaguesPlannerPlugin plugin;
    private final LeaguesPlannerConfig config;
    @Inject
    private WorldMapOverlay worldMapOverlay;
    private Area WorldMapClipArea;

    @Inject
    public RegionBoundOverlay(Client Inclient, PosiedienLeaguesPlannerPlugin InPlugin, LeaguesPlannerConfig Inconfig) {
        this.client = Inclient;
        this.plugin = InPlugin;
        this.config = Inconfig;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
    }

    private Area ObtainWorldMapClipArea(Rectangle baseRectangle) {
        Widget overview = this.client.getWidget(WidgetInfo.WORLD_MAP_OVERVIEW_MAP);
        Widget surfaceSelector = this.client.getWidget(WidgetInfo.WORLD_MAP_SURFACE_SELECTOR);
        Area clipArea = new Area(baseRectangle);
        if (overview != null && !overview.isHidden()) {
            clipArea.subtract(new Area(overview.getBounds()));
        }
        if (surfaceSelector != null && !surfaceSelector.isHidden()) {
            clipArea.subtract(new Area(surfaceSelector.getBounds()));
        }
        return clipArea;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.bIsInitializing) {
            return null;
        }
        if (this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW) == null) {
            return null;
        }
        this.WorldMapClipArea = this.ObtainWorldMapClipArea(this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW).getBounds());
        graphics.setClip(this.WorldMapClipArea);
        for (LeagueRegionBounds regionDatum : LeaguesPlannerConfig.RegionData.RegionData) {
            Color DrawColor = RegionType.GetRegionColor(this.config, regionDatum.Type, true);
            graphics.setColor(DrawColor);
            if (this.config.GetEditRegion() != RegionType.NONE) {
                for (RegionLine line : regionDatum.RegionLines) {
                    GraphicsLine convertedLine = line.ConvertToGraphicsLine(this.worldMapOverlay);
                    if (convertedLine == null) continue;
                    graphics.drawLine(convertedLine.x1, convertedLine.y1, convertedLine.x2, convertedLine.y2);
                }
            }
            for (WorldPointPolygon WorldPointPoly : regionDatum.RegionPolygons) {
                Polygon convertedPoly = WorldPointPoly.ConvertToGraphicsPolygon(this.worldMapOverlay);
                if (convertedPoly == null) continue;
                graphics.fillPolygon(convertedPoly);
            }
        }
        return null;
    }
}

