/*
 * Decompiled with CFR 0.152.
 */
package Posiedien_Leagues_Planner;

import java.util.Arrays;

public class PrimitiveIntHashMap<V> {
    private static final int MINIMUM_SIZE = 8;
    private static final int DEFAULT_BUCKET_SIZE = 4;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private IntNode<V>[][] buckets;
    private int size;
    private int capacity;
    private int maxSize;
    private int mask;
    private final float loadFactor;

    public PrimitiveIntHashMap(int initialSize) {
        this(initialSize, 0.75f);
    }

    public PrimitiveIntHashMap(int initialSize, float loadFactor) {
        if (loadFactor < 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("Load factor must be between 0 and 1");
        }
        this.loadFactor = loadFactor;
        this.size = 0;
        this.setNewSize(initialSize);
        this.recreateArrays();
    }

    public int size() {
        return this.size;
    }

    public V get(int key) {
        return this.getOrDefault(key, null);
    }

    public V getOrDefault(int key, V defaultValue) {
        int bucket = this.getBucket(key);
        int index = this.bucketIndex(key, bucket);
        if (index == -1) {
            return defaultValue;
        }
        return this.buckets[bucket][index].value;
    }

    public V put(int key, V value) {
        if (value == null) {
            throw new IllegalArgumentException("Cannot insert a null value");
        }
        int bucketIndex = this.getBucket(key);
        IntNode<V>[] bucket = this.buckets[bucketIndex];
        if (bucket == null) {
            this.buckets[bucketIndex] = this.createBucket(4);
            this.buckets[bucketIndex][0] = new IntNode<V>(key, value);
            this.incrementSize();
            return null;
        }
        for (int i = 0; i < bucket.length; ++i) {
            if (bucket[i] == null) {
                bucket[i] = new IntNode<V>(key, value);
                this.incrementSize();
                return null;
            }
            if (bucket[i].key != key) continue;
            Object previous = bucket[i].value;
            bucket[i].value = value;
            return previous;
        }
        this.growBucket((int)bucketIndex)[bucket.length] = new IntNode<V>(key, value);
        this.incrementSize();
        return null;
    }

    private static int hash(int value) {
        return value ^ value >>> 5 ^ value >>> 25;
    }

    private int getBucket(int key) {
        return PrimitiveIntHashMap.hash(key) & Integer.MAX_VALUE & this.mask;
    }

    private int bucketIndex(int key, int bucketIndex) {
        IntNode<V>[] bucket = this.buckets[bucketIndex];
        if (bucket == null) {
            return -1;
        }
        for (int i = 0; i < bucket.length && bucket[i] != null; ++i) {
            if (bucket[i].key != key) continue;
            return i;
        }
        return -1;
    }

    private void incrementSize() {
        ++this.size;
        if (this.size >= this.capacity) {
            this.rehash();
        }
    }

    private IntNode<V>[] growBucket(int bucketIndex) {
        IntNode<V>[] oldBucket = this.buckets[bucketIndex];
        IntNode<V>[] newBucket = this.createBucket(oldBucket.length * 2);
        System.arraycopy(oldBucket, 0, newBucket, 0, oldBucket.length);
        this.buckets[bucketIndex] = newBucket;
        return newBucket;
    }

    private int getNewMaxSize(int size) {
        int nextPow2 = -1 >>> Integer.numberOfLeadingZeros(size);
        if (nextPow2 >= 0x3FFFFFFF) {
            return 0x40000000;
        }
        return nextPow2 + 1;
    }

    private void setNewSize(int size) {
        if (size < 8) {
            size = 7;
        }
        this.maxSize = this.getNewMaxSize(size);
        this.mask = this.maxSize - 1;
        this.capacity = (int)((float)this.maxSize * this.loadFactor);
    }

    private void growCapacity() {
        this.setNewSize(this.maxSize);
    }

    private void rehash() {
        this.growCapacity();
        IntNode<V>[][] oldBuckets = this.buckets;
        this.recreateArrays();
        for (int i = 0; i < oldBuckets.length; ++i) {
            IntNode<V>[] oldBucket = oldBuckets[i];
            if (oldBucket == null) continue;
            for (int ind = 0; ind < oldBucket.length && oldBucket[ind] != null; ++ind) {
                int bInd;
                int bucketIndex = this.getBucket(oldBucket[ind].key);
                IntNode<V>[] newBucket = this.buckets[bucketIndex];
                if (newBucket == null) {
                    newBucket = this.createBucket(4);
                    newBucket[0] = oldBucket[ind];
                    this.buckets[bucketIndex] = newBucket;
                    continue;
                }
                for (bInd = 0; bInd < newBucket.length; ++bInd) {
                    if (newBucket[bInd] != null) continue;
                    newBucket[bInd] = oldBucket[ind];
                    break;
                }
                if (bInd < newBucket.length) continue;
                this.growBucket((int)bucketIndex)[newBucket.length] = oldBucket[ind];
                return;
            }
        }
    }

    private void recreateArrays() {
        IntNode[][] temp = new IntNode[this.maxSize][];
        this.buckets = temp;
    }

    private IntNode<V>[] createBucket(int size) {
        IntNode[] temp = new IntNode[size];
        return temp;
    }

    public double calculateFullness() {
        int size = 0;
        int usedSize = 0;
        block0: for (int i = 0; i < this.buckets.length; ++i) {
            if (this.buckets[i] == null) continue;
            size += this.buckets[i].length;
            for (int j = 0; j < this.buckets[i].length; ++j) {
                if (this.buckets[i][j] != null) continue;
                usedSize += j;
                continue block0;
            }
        }
        return 100.0 * (double)usedSize / (double)size;
    }

    public void clear() {
        this.size = 0;
        Arrays.fill(this.buckets, null);
    }

    private static class IntNode<V> {
        private int key;
        private V value;

        private IntNode(int key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

