/*
 * Decompiled with CFR 0.152.
 */
package Posiedien_Leagues_Planner;

import Posiedien_Leagues_Planner.DebugOverlayPanel;
import Posiedien_Leagues_Planner.LeagueRegionBounds;
import Posiedien_Leagues_Planner.LeagueRegionPoint;
import Posiedien_Leagues_Planner.LeaguesPlannerConfig;
import Posiedien_Leagues_Planner.LeaguesPlannerPanel;
import Posiedien_Leagues_Planner.PathMapOverlay;
import Posiedien_Leagues_Planner.PathMapTooltipOverlay;
import Posiedien_Leagues_Planner.PathMinimapOverlay;
import Posiedien_Leagues_Planner.PathTileOverlay;
import Posiedien_Leagues_Planner.PluginInitializer;
import Posiedien_Leagues_Planner.RegionBoundOverlay;
import Posiedien_Leagues_Planner.RegionLine;
import Posiedien_Leagues_Planner.RegionType;
import Posiedien_Leagues_Planner.TaskData;
import Posiedien_Leagues_Planner.TaskDifficulty;
import Posiedien_Leagues_Planner.TaskDisplayPoint;
import Posiedien_Leagues_Planner.TaskOverlay;
import Posiedien_Leagues_Planner.TaskSortData;
import Posiedien_Leagues_Planner.Transport;
import Posiedien_Leagues_Planner.WorldPointPolygon;
import Posiedien_Leagues_Planner.pathfinder.CollisionMap;
import Posiedien_Leagues_Planner.pathfinder.Pathfinder;
import Posiedien_Leagues_Planner.pathfinder.PathfinderConfig;
import Posiedien_Leagues_Planner.pathfinder.SplitFlagMap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.google.inject.Provides;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.RenderOverview;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.api.worldmap.WorldMap;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.input.MouseListener;
import net.runelite.client.input.MouseManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.JagexColors;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.worldmap.WorldMapOverlay;
import net.runelite.client.ui.overlay.worldmap.WorldMapPoint;
import net.runelite.client.ui.overlay.worldmap.WorldMapPointManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;

@PluginDescriptor(name="Posiedien Leagues Planner", description="The plugin allows people to put in their own custom tasks or hook into tasks I've manually added into the planning.", tags={"leagues", "trailblazer", "posiedien", "planning", "pathfinder", "map", "waypoint", "navigation"})
public class PosiedienLeaguesPlannerPlugin
extends Plugin {
    protected static final String CONFIG_GROUP = "Posiedien_Leagues_Planner";
    private static final String ADD_START = "Add start";
    private static final String ADD_END = "Add end";
    private static final String CLEAR = "Clear";
    private static final String PATH = ColorUtil.wrapWithColorTag((String)"Path", (Color)JagexColors.MENU_TARGET);
    private static final String SET = "Set";
    private static final String START = ColorUtil.wrapWithColorTag((String)"Pathfinding Start", (Color)JagexColors.MENU_TARGET);
    private static final String TARGET = ColorUtil.wrapWithColorTag((String)"Pathfinding Target", (Color)JagexColors.MENU_TARGET);
    private static final String TRANSPORT = ColorUtil.wrapWithColorTag((String)"Transport", (Color)JagexColors.MENU_TARGET);
    private static final String WALK_HERE = "Walk here";
    private static final BufferedImage MARKER_IMAGE = ImageUtil.loadImageResource(PosiedienLeaguesPlannerPlugin.class, (String)"/marker.png");
    private static final BufferedImage TASK_IMAGE = ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/TaskIcon.png");
    public boolean enableAutoRecalculate = false;
    @Inject
    public Client client;
    public boolean bMapDisplayPointsDirty;
    @Inject
    ConfigManager configManager;
    @Inject
    private MouseManager mouseManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    public LeaguesPlannerConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private PathTileOverlay pathOverlay;
    @Inject
    private PathMinimapOverlay pathMinimapOverlay;
    @Inject
    private PathMapOverlay pathMapOverlay;
    @Inject
    private PathMapTooltipOverlay pathMapTooltipOverlay;
    @Inject
    private DebugOverlayPanel debugOverlayPanel;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private WorldMapPointManager worldMapPointManager;
    @Inject
    private WorldMapOverlay worldMapOverlay;
    private Point lastMenuOpenedPoint;
    private WorldMapPoint marker;
    private WorldPoint transportStart;
    private WorldPoint lastLocation = new WorldPoint(0, 0, 0);
    private MenuEntry lastClick;
    private Shape minimapClipFixed;
    private Shape minimapClipResizeable;
    private BufferedImage minimapSpriteFixed;
    private BufferedImage minimapSpriteResizeable;
    private Rectangle minimapRectangle = new Rectangle();
    private ExecutorService pathfindingExecutor = Executors.newSingleThreadExecutor();
    private ExecutorService initExecutor = Executors.newSingleThreadExecutor();
    private Future<?> pathfinderFuture;
    private final Object pathfinderMutex = new Object();
    private Pathfinder pathfinder;
    public PathfinderConfig pathfinderConfig;
    private boolean startPointSet = false;
    public LeaguesPlannerPanel panel;
    public NavigationButton navButton;
    public volatile boolean bIsInitializing = false;
    public boolean bQueuedPathfinderTask = false;
    private final Pattern TRANSPORT_OPTIONS_REGEX = Pattern.compile("^(avoidWilderness|use\\w+)$");
    Player CachedPlayer = null;
    float Timer = 0.0f;
    double SinceLastInputTimer = 0.0;
    boolean bWasTaskWindowOpen = false;
    MouseListener MouseListenerObject = new MouseListener(){

        public MouseEvent mouseClicked(MouseEvent e) {
            if (PosiedienLeaguesPlannerPlugin.this.CustomTask_ChangingIcon == null) {
                return e;
            }
            if (PosiedienLeaguesPlannerPlugin.this.SinceLastInputTimer < (double)0.7f) {
                return e;
            }
            PosiedienLeaguesPlannerPlugin.this.getClientThread().invokeLater(() -> {
                Area WorldMapClipArea = PosiedienLeaguesPlannerPlugin.this.ObtainWorldMapClipArea(Objects.requireNonNull(PosiedienLeaguesPlannerPlugin.this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW)).getBounds());
                Point HighlightGraphicsPoint = new Point(0, 0);
                if (PosiedienLeaguesPlannerPlugin.this.getSelectedWorldPoint() != null && (HighlightGraphicsPoint = PosiedienLeaguesPlannerPlugin.this.worldMapOverlay.mapWorldPointToGraphicsPoint(PosiedienLeaguesPlannerPlugin.this.getSelectedWorldPoint())) == null) {
                    HighlightGraphicsPoint = new Point(0, 0);
                }
                int TotalIconCount = PosiedienLeaguesPlannerPlugin.this.CustomIconsMap.size();
                int IconSize = 30;
                int IconSizeHalf = IconSize / 2;
                Rectangle2D Bounds = WorldMapClipArea.getBounds2D();
                int RowAndHeightSize = (int)Math.sqrt(TotalIconCount);
                int i = 0;
                for (Map.Entry<String, BufferedImage> CustomIcon : PosiedienLeaguesPlannerPlugin.this.CustomIconsMap.entrySet()) {
                    int OffsetX = (int)(Bounds.getCenterX() - (double)(RowAndHeightSize / 2 * IconSize));
                    int OffsetY = (int)(Bounds.getCenterY() - (double)(RowAndHeightSize / 2 * IconSize));
                    Point IconPoint = new Point(OffsetX += i % RowAndHeightSize * IconSize, OffsetY += i / RowAndHeightSize * IconSize);
                    if (HighlightGraphicsPoint.distanceTo(IconPoint) < IconSizeHalf) {
                        PosiedienLeaguesPlannerPlugin.this.CustomTask_ChangingIcon.CustomIcon = CustomIcon.getKey();
                        break;
                    }
                    ++i;
                }
                PosiedienLeaguesPlannerPlugin.this.CustomTask_ChangingIcon = null;
            });
            return e;
        }

        public MouseEvent mousePressed(MouseEvent mouseEvent) {
            return mouseEvent;
        }

        public MouseEvent mouseReleased(MouseEvent mouseEvent) {
            return mouseEvent;
        }

        public MouseEvent mouseEntered(MouseEvent mouseEvent) {
            return mouseEvent;
        }

        public MouseEvent mouseExited(MouseEvent mouseEvent) {
            return mouseEvent;
        }

        public MouseEvent mouseDragged(MouseEvent mouseEvent) {
            return mouseEvent;
        }

        public MouseEvent mouseMoved(MouseEvent mouseEvent) {
            return mouseEvent;
        }
    };
    public LeagueRegionBounds CurrentRegion = null;
    public LeagueRegionPoint LastClickedRegionPoint = null;
    @Inject
    public RegionBoundOverlay regionBoundOverlay = new RegionBoundOverlay(this.client, this, this.config);
    @Inject
    public TaskOverlay taskOverlay = null;
    public LeagueRegionPoint CurrentFocusedPoint;
    private boolean bLoadRawWikiData = false;
    private boolean bCalculateOverworldPositions = false;
    private boolean bSaveTaskData = false;
    private boolean bSaveRegionData = false;
    public WorldPoint LastDisplayedWorldPoint;
    private static final BufferedImage ACTIVE_MARKER_IMAGE = ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/activemarker.png");
    public static final BufferedImage BOUNDS_SELECTED = ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/BoundPoint_Selected.png");
    private static final BufferedImage BOUNDS_MISTHALIN = ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/BoundPoint_Misthalin.png");
    private static final BufferedImage BOUNDS_KARAMJA = ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/BoundPoint_Karamja.png");
    private static final BufferedImage BOUNDS_KANDARIN = ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/BoundPoint_Kandarin.png");
    private static final BufferedImage BOUNDS_ASGARNIA = ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/BoundPoint_Asgarnia.png");
    private static final BufferedImage BOUNDS_FREMENNIK = ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/BoundPoint_Fremennik.png");
    private static final BufferedImage BOUNDS_KOUREND = ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/BoundPoint_Kourend.png");
    private static final BufferedImage BOUNDS_WILDERNESS = ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/BoundPoint_Wilderness.png");
    private static final BufferedImage BOUNDS_MORYTANIA = ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/BoundPoint_Morytania.png");
    private static final BufferedImage BOUNDS_TIRANNWN = ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/BoundPoint_Tirannwn.png");
    private static final BufferedImage BOUNDS_DESERT = ImageUtil.getResourceStreamFromClass(PosiedienLeaguesPlannerPlugin.class, (String)"/BoundPoint_Desert.png");
    private final Consumer<MenuEntry> SetNextRegionPointEntryCallback = n -> {
        UUID uuid;
        LeagueRegionPoint LastRegionPoint = this.CurrentFocusedPoint;
        LeagueRegionPoint NewRegionPoint = new LeagueRegionPoint();
        NewRegionPoint.GUID = uuid = UUID.randomUUID();
        NewRegionPoint.Region = this.CurrentRegion.Type;
        this.CurrentRegion.RegionPoints.put(NewRegionPoint.GUID, NewRegionPoint);
        this.SetMarkerActivation(NewRegionPoint, true);
        if (LastRegionPoint != null) {
            if (LastRegionPoint.ConnectedPoints.size() == 2) {
                LastRegionPoint.ConnectedPoints.get((int)1).ConnectedPoints.remove(LastRegionPoint);
                LastRegionPoint.ConnectedPoints.remove(1);
            }
            LastRegionPoint.ConnectedPoints.add(NewRegionPoint);
            NewRegionPoint.ConnectedPoints.add(LastRegionPoint);
        }
        this.RefreshRegionBounds();
    };
    HashMap<Integer, TaskData> HashCodeToHash = new HashMap();
    private final Consumer<MenuEntry> AddTaskToBackOfPlan = n -> {
        TaskData CurrentTask = this.HashCodeToHash.get(n.getParam0());
        int CurrentOrder = -1;
        for (Map.Entry<UUID, TaskSortData> mapElement : LeaguesPlannerConfig.UserData.PlannedTasks.entrySet()) {
            if (mapElement.getValue().SortPriority <= CurrentOrder) continue;
            CurrentOrder = mapElement.getValue().SortPriority;
        }
        LeaguesPlannerConfig.UserData.PlannedTasks.put(CurrentTask.GUID, new TaskSortData(CurrentOrder + 1, CurrentTask.bIsCustomTask));
        LeaguesPlannerConfig.UserData.HiddenTasks.remove(CurrentTask.GUID);
        this.QueueRefresh();
    };
    ArrayList<UUID> TempArray = new ArrayList();
    private final Consumer<MenuEntry> AddTaskToFrontOfPlan = n -> {
        TaskData CurrentTask = this.HashCodeToHash.get(n.getParam0());
        int CurrentOrder = 9000000;
        this.TempArray.clear();
        for (Map.Entry<UUID, TaskSortData> mapElement : LeaguesPlannerConfig.UserData.PlannedTasks.entrySet()) {
            if (mapElement.getValue().SortPriority < CurrentOrder) {
                CurrentOrder = mapElement.getValue().SortPriority;
            }
            this.TempArray.add(mapElement.getKey());
        }
        for (UUID SearchingTaskGUID : this.TempArray) {
            int OldOrder = LeaguesPlannerConfig.UserData.PlannedTasks.get((Object)SearchingTaskGUID).SortPriority;
            Boolean bOldIsCustomTask = LeaguesPlannerConfig.UserData.PlannedTasks.get((Object)SearchingTaskGUID).bIsCustomTask;
            LeaguesPlannerConfig.UserData.PlannedTasks.remove(SearchingTaskGUID);
            LeaguesPlannerConfig.UserData.PlannedTasks.put(SearchingTaskGUID, new TaskSortData(OldOrder + 1, bOldIsCustomTask));
            LeaguesPlannerConfig.UserData.HiddenTasks.remove(SearchingTaskGUID);
        }
        if (CurrentOrder == 9000000) {
            CurrentOrder = 0;
        }
        LeaguesPlannerConfig.UserData.PlannedTasks.put(CurrentTask.GUID, new TaskSortData(CurrentOrder, CurrentTask.bIsCustomTask));
        LeaguesPlannerConfig.UserData.HiddenTasks.remove(CurrentTask.GUID);
        this.QueueRefresh();
    };
    private final Consumer<MenuEntry> RemoveTaskFromPlan = n -> {
        TaskData CurrentTask = this.HashCodeToHash.get(n.getParam0());
        LeaguesPlannerConfig.UserData.PlannedTasks.remove(CurrentTask.GUID);
        this.QueueRefresh();
    };
    private final Consumer<MenuEntry> MoveForwardOnPlan = n -> {
        TaskData CurrentTask = this.HashCodeToHash.get(n.getParam0());
        int CurrentHighest = -1;
        int CurrentOrder = LeaguesPlannerConfig.UserData.PlannedTasks.get((Object)CurrentTask.GUID).SortPriority;
        UUID ClosestTask = null;
        this.TempArray.clear();
        for (Map.Entry<UUID, TaskSortData> mapElement : LeaguesPlannerConfig.UserData.PlannedTasks.entrySet()) {
            if (!mapElement.getKey().equals(CurrentTask.GUID) && mapElement.getValue().SortPriority <= CurrentOrder && mapElement.getValue().SortPriority > CurrentHighest) {
                CurrentHighest = mapElement.getValue().SortPriority;
                ClosestTask = mapElement.getKey();
            }
            this.TempArray.add(mapElement.getKey());
        }
        if (ClosestTask != null) {
            LeaguesPlannerConfig.UserData.PlannedTasks.remove(CurrentTask.GUID);
            LeaguesPlannerConfig.UserData.PlannedTasks.put(CurrentTask.GUID, new TaskSortData(CurrentHighest, CurrentTask.bIsCustomTask));
            LeaguesPlannerConfig.UserData.HiddenTasks.remove(CurrentTask.GUID);
            for (UUID SearchingTaskGUID : this.TempArray) {
                if (SearchingTaskGUID.equals(CurrentTask.GUID)) continue;
                int OldOrder = LeaguesPlannerConfig.UserData.PlannedTasks.get((Object)SearchingTaskGUID).SortPriority;
                Boolean bOldCustomTask = LeaguesPlannerConfig.UserData.PlannedTasks.get((Object)SearchingTaskGUID).bIsCustomTask;
                if (OldOrder < CurrentHighest) continue;
                LeaguesPlannerConfig.UserData.PlannedTasks.remove(SearchingTaskGUID);
                LeaguesPlannerConfig.UserData.PlannedTasks.put(SearchingTaskGUID, new TaskSortData(OldOrder + 1, bOldCustomTask));
                LeaguesPlannerConfig.UserData.HiddenTasks.remove(SearchingTaskGUID);
            }
            this.QueueRefresh();
        }
    };
    private final Consumer<MenuEntry> MoveBackOnPlan = n -> {
        TaskData CurrentTask = this.HashCodeToHash.get(n.getParam0());
        int CurrentLowest = 900000;
        int CurrentOrder = LeaguesPlannerConfig.UserData.PlannedTasks.get((Object)CurrentTask.GUID).SortPriority;
        UUID ClosestTask = null;
        this.TempArray.clear();
        for (Map.Entry<UUID, TaskSortData> mapElement : LeaguesPlannerConfig.UserData.PlannedTasks.entrySet()) {
            if (!mapElement.getKey().equals(CurrentTask.GUID) && mapElement.getValue().SortPriority >= CurrentOrder && mapElement.getValue().SortPriority < CurrentLowest) {
                CurrentLowest = mapElement.getValue().SortPriority;
                ClosestTask = mapElement.getKey();
            }
            this.TempArray.add(mapElement.getKey());
        }
        if (ClosestTask != null) {
            Boolean bOldCustomTaskClosest = LeaguesPlannerConfig.UserData.PlannedTasks.get(ClosestTask).bIsCustomTask;
            LeaguesPlannerConfig.UserData.PlannedTasks.remove(ClosestTask);
            LeaguesPlannerConfig.UserData.PlannedTasks.put(ClosestTask, new TaskSortData(CurrentLowest - 1, bOldCustomTaskClosest));
            LeaguesPlannerConfig.UserData.HiddenTasks.remove(ClosestTask);
            LeaguesPlannerConfig.UserData.PlannedTasks.remove(CurrentTask.GUID);
            LeaguesPlannerConfig.UserData.PlannedTasks.put(CurrentTask.GUID, new TaskSortData(CurrentLowest, CurrentTask.bIsCustomTask));
            LeaguesPlannerConfig.UserData.HiddenTasks.remove(CurrentTask.GUID);
            for (UUID SearchingTaskGUID : this.TempArray) {
                if (SearchingTaskGUID.equals(CurrentTask.GUID)) continue;
                int OldOrder = LeaguesPlannerConfig.UserData.PlannedTasks.get((Object)SearchingTaskGUID).SortPriority;
                Boolean bOldCustomTask = LeaguesPlannerConfig.UserData.PlannedTasks.get((Object)SearchingTaskGUID).bIsCustomTask;
                if (OldOrder < CurrentLowest) continue;
                LeaguesPlannerConfig.UserData.PlannedTasks.remove(SearchingTaskGUID);
                LeaguesPlannerConfig.UserData.PlannedTasks.put(SearchingTaskGUID, new TaskSortData(OldOrder + 1, bOldCustomTask));
                LeaguesPlannerConfig.UserData.HiddenTasks.remove(SearchingTaskGUID);
            }
            this.QueueRefresh();
        }
    };
    private final Consumer<MenuEntry> FocusOnTaskLocation = n -> {
        TaskData CurrentTask = this.HashCodeToHash.get(n.getParam0());
        this.FocusOnTaskOnWorldMap(CurrentTask);
    };
    private final Consumer<MenuEntry> CreateCustomTask = n -> {
        UUID newCustomTaskGUID = UUID.randomUUID();
        TaskData newTask = new TaskData();
        newTask.GUID = newCustomTaskGUID;
        newTask.Locations.add(this.LastDisplayedWorldPoint);
        newTask.Difficulty = TaskDifficulty.CUSTOM;
        newTask.TaskName = "Edit task in Panel";
        newTask.bIsCustomTask = true;
        LeaguesPlannerConfig.UserData.CustomTasks.put(newCustomTaskGUID, newTask);
        this.bMapDisplayPointsDirty = true;
        this.QueueRefresh();
    };
    private final Consumer<MenuEntry> DestroyCustomTask = n -> {
        TaskData CurrentTask = this.HashCodeToHash.get(n.getParam0());
        LeaguesPlannerConfig.UserData.CustomTasks.remove(CurrentTask.GUID);
        LeaguesPlannerConfig.UserData.PlannedTasks.remove(CurrentTask.GUID);
        this.bMapDisplayPointsDirty = true;
        this.QueueRefresh();
    };
    HashMap<String, BufferedImage> CustomIconsMap = new HashMap();
    TaskData CustomTask_ChangingIcon = null;
    private final Consumer<MenuEntry> ChangeIconCustomTask = n -> {
        this.CustomTask_ChangingIcon = this.HashCodeToHash.get(n.getParam0());
        this.SinceLastInputTimer = 0.0;
    };
    private final Consumer<MenuEntry> SetActiveRegionPointEntryCallback = n -> {
        this.SetMarkerActivation(this.LastClickedRegionPoint, true);
        this.RefreshRegionBounds();
    };
    private final Consumer<MenuEntry> DeleteRegionPointEntryCallback = n -> {
        for (LeagueRegionPoint ConnectedPoint : this.LastClickedRegionPoint.ConnectedPoints) {
            ConnectedPoint.ConnectedPoints.remove(this.LastClickedRegionPoint);
        }
        this.LastClickedRegionPoint.ConnectedPoints.clear();
        this.worldMapPointManager.removeIf(x -> x == this.LastClickedRegionPoint.OurPoint);
        this.CurrentRegion.RegionPoints.remove(this.LastClickedRegionPoint.GUID);
        if (this.LastClickedRegionPoint == this.CurrentFocusedPoint) {
            this.CurrentFocusedPoint = null;
        }
        this.RefreshRegionBounds();
    };
    private final Consumer<MenuEntry> ConnectRegionPointEntryCallback = n -> {
        for (LeagueRegionPoint ConnectedPoint : this.CurrentFocusedPoint.ConnectedPoints) {
            if (ConnectedPoint != this.LastClickedRegionPoint) continue;
            ConnectedPoint.ConnectedPoints.remove(this.CurrentFocusedPoint);
            this.CurrentFocusedPoint.ConnectedPoints.remove(ConnectedPoint);
            this.RefreshRegionBounds();
            return;
        }
        if (this.CurrentFocusedPoint.ConnectedPoints.size() == 2) {
            this.CurrentFocusedPoint.ConnectedPoints.get((int)1).ConnectedPoints.remove(this.CurrentFocusedPoint);
            this.CurrentFocusedPoint.ConnectedPoints.remove(1);
        }
        this.CurrentFocusedPoint.ConnectedPoints.add(this.LastClickedRegionPoint);
        if (this.LastClickedRegionPoint.ConnectedPoints.size() == 2) {
            this.LastClickedRegionPoint.ConnectedPoints.get((int)1).ConnectedPoints.remove(this.LastClickedRegionPoint);
            this.LastClickedRegionPoint.ConnectedPoints.remove(1);
        }
        this.LastClickedRegionPoint.ConnectedPoints.add(this.CurrentFocusedPoint);
        this.RefreshRegionBounds();
    };

    private boolean isTaskWindowOpen() {
        Widget widget = this.client.getWidget(657, 10);
        return widget != null && !widget.isHidden();
    }

    public void InitializeFromOtherThread() {
        this.taskOverlay = new TaskOverlay(this.client, this, this.config);
        this.taskOverlay.worldMapOverlay = this.worldMapOverlay;
        HashMap<WorldPoint, List<Transport>> transports = Transport.loadAllFromResources();
        if (this.bCalculateOverworldPositions) {
            SplitFlagMap map = SplitFlagMap.fromResources(null, null);
            this.pathfinderConfig = new PathfinderConfig(map, transports, this.client, this.config);
        }
        this.overlayManager.add((Overlay)this.pathOverlay);
        this.overlayManager.add((Overlay)this.pathMinimapOverlay);
        this.overlayManager.add((Overlay)this.pathMapOverlay);
        this.overlayManager.add((Overlay)this.pathMapTooltipOverlay);
        if (this.config.drawDebugPanel()) {
            this.overlayManager.add((Overlay)this.debugOverlayPanel);
        }
        try {
            this.InitializeRegionData();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            this.InitializeTaskData();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.InitializeCustomIconsMap();
        this.mouseManager.registerMouseListener(this.MouseListenerObject);
        SplitFlagMap NewMap = SplitFlagMap.fromResources(this, this.config);
        this.pathfinderConfig = new PathfinderConfig(NewMap, transports, this.client, this.config);
        EventQueue.invokeLater(() -> {
            this.panel = new LeaguesPlannerPanel(this);
            this.navButton = NavigationButton.builder().tooltip("Posiedien's Leagues Planner").icon(TASK_IMAGE).priority(7).panel((PluginPanel)this.panel).build();
            this.clientToolbar.addNavigation(this.navButton);
            this.panel.refresh();
            this.bIsInitializing = false;
        });
    }

    protected void startUp() throws Exception {
        this.bIsInitializing = true;
        PluginInitializer newPluginInitializer = new PluginInitializer(this);
        if (this.initExecutor == null) {
            this.initExecutor = Executors.newSingleThreadExecutor();
        }
        this.initExecutor.submit(newPluginInitializer);
    }

    protected void shutDown() throws IOException {
        this.SaveRegionBounds();
        this.SaveTaskData();
        this.ShutdownRegionData();
        this.ShutdownTaskData();
        this.overlayManager.remove((Overlay)this.pathOverlay);
        this.overlayManager.remove((Overlay)this.pathMinimapOverlay);
        this.overlayManager.remove((Overlay)this.pathMapOverlay);
        this.overlayManager.remove((Overlay)this.pathMapTooltipOverlay);
        this.overlayManager.remove((Overlay)this.debugOverlayPanel);
        this.mouseManager.unregisterMouseListener(this.MouseListenerObject);
        if (this.initExecutor != null) {
            this.initExecutor.shutdownNow();
            this.initExecutor = null;
        }
        if (this.pathfindingExecutor != null) {
            this.pathfindingExecutor.shutdownNow();
            this.pathfindingExecutor = null;
        }
        if (this.panel.pathfindingExecutor != null) {
            this.panel.pathfindingExecutor.shutdownNow();
            this.panel.pathfindingExecutor = null;
        }
        this.clientToolbar.removeNavigation(this.navButton);
        this.taskOverlay = null;
        this.panel = null;
        this.navButton = null;
    }

    private void SaveTaskData() throws IOException {
        File targ;
        if (this.bSaveTaskData) {
            targ = new File("TaskData.csv");
            LeaguesPlannerConfig.TaskData.exportToConverted(targ, this);
        }
        targ = new File("UserData.csv");
        LeaguesPlannerConfig.UserData.exportTo(targ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartPathfinding(WorldPoint start, WorldPoint end, boolean bJustFindOverworld) {
        Object object = this.pathfinderMutex;
        synchronized (object) {
            if (this.pathfinder != null) {
                this.bQueuedPathfinderTask = true;
                this.pathfinder.cancel();
                this.pathfinderFuture.cancel(true);
            }
            if (this.pathfindingExecutor == null) {
                ThreadFactory shortestPathNaming = new ThreadFactoryBuilder().setNameFormat("shortest-path-%d").build();
                this.pathfindingExecutor = Executors.newSingleThreadExecutor(shortestPathNaming);
            }
        }
        this.getClientThread().invokeLater(() -> {
            this.bQueuedPathfinderTask = false;
            this.pathfinderConfig.refresh();
            Object object = this.pathfinderMutex;
            synchronized (object) {
                this.pathfinder = new Pathfinder(this.pathfinderConfig, start, end, bJustFindOverworld);
                this.pathfinderFuture = this.pathfindingExecutor.submit(this.pathfinder);
            }
        });
    }

    public boolean isNearPath(WorldPoint location) {
        if (this.pathfinder == null || this.pathfinder.getPath() == null || this.pathfinder.getPath().isEmpty() || this.config.recalculateDistance() < 0 || (this.lastLocation = location).equals((Object)this.lastLocation)) {
            return true;
        }
        for (WorldPoint point : this.pathfinder.getPath()) {
            if (location.distanceTo2D(point) >= this.config.recalculateDistance()) continue;
            return true;
        }
        return false;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (this.bIsInitializing) {
            return;
        }
        this.CurrentRegion = this.GetRegionBounds(this.config.GetEditRegion());
        if (event.getKey().equals("GetEditRegion")) {
            if (this.config.GetEditRegion() == RegionType.NONE) {
                this.worldMapPointManager.removeIf(x -> x.getName() != null && x.getName().contains("LP: Region Bounds:"));
            } else {
                for (LeagueRegionBounds LocalCurrentRegion : LeaguesPlannerConfig.RegionData.RegionData) {
                    LocalCurrentRegion.RegionPoints.forEach((key, value) -> this.SetMarkerActivation((LeagueRegionPoint)value, false));
                }
            }
        }
        if (!CONFIG_GROUP.equals(event.getGroup())) {
            return;
        }
        if ("drawDebugPanel".equals(event.getKey())) {
            if (this.config.drawDebugPanel()) {
                this.overlayManager.add((Overlay)this.debugOverlayPanel);
            } else {
                this.overlayManager.remove((Overlay)this.debugOverlayPanel);
            }
            return;
        }
        if (this.TRANSPORT_OPTIONS_REGEX.matcher(event.getKey()).find() && this.pathfinder != null) {
            this.restartPathfinding(this.pathfinder.getStart(), this.pathfinder.getTarget(), false);
        }
    }

    @Subscribe
    public void onMenuOpened(MenuOpened event) {
        if (this.bIsInitializing) {
            return;
        }
        Widget map = this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW);
        if (map == null) {
            return;
        }
        if (!map.getBounds().contains(this.client.getMouseCanvasPosition().getX(), this.client.getMouseCanvasPosition().getY())) {
            return;
        }
        this.CurrentRegion = this.GetRegionBounds(this.config.GetEditRegion());
        this.AddRightClickMenuEntries(event);
        this.lastMenuOpenedPoint = this.client.getMouseCanvasPosition();
    }

    public void QueueRefresh() {
        if (this.bIsInitializing) {
            return;
        }
        EventQueue.invokeLater(() -> {
            if (this.panel != null) {
                this.panel.refresh();
            }
            this.bMapDisplayPointsDirty = true;
        });
    }

    private boolean isTaskCompleted(Widget taskLabel) {
        return taskLabel.getTextColor() != 0x9F9F9F;
    }

    private void MarkCompletedTasksFromList() {
        Widget taskLabelsWidget = this.client.getWidget(657, 10);
        Widget taskPointsWidget = this.client.getWidget(657, 11);
        Widget taskDifficultiesWidget = this.client.getWidget(657, 16);
        if (taskLabelsWidget == null || taskPointsWidget == null || taskDifficultiesWidget == null) {
            return;
        }
        Widget[] taskLabels = taskLabelsWidget.getDynamicChildren();
        Widget[] taskPoints = taskPointsWidget.getDynamicChildren();
        Widget[] taskDifficulties = taskDifficultiesWidget.getDynamicChildren();
        if (taskLabels.length != taskPoints.length || taskPoints.length != taskDifficulties.length) {
            return;
        }
        for (Widget taskLabel : taskLabels) {
            String name = taskLabel.getText();
            for (Map.Entry<UUID, TaskData> SearchingTask : LeaguesPlannerConfig.TaskData.LeaguesTaskList.entrySet()) {
                if (!SearchingTask.getValue().TaskName.contains(name) || !this.isTaskCompleted(taskLabel)) continue;
                LeaguesPlannerConfig.UserData.CompletedTasks.add(SearchingTask.getKey());
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        WorldPoint currentLocation;
        if (this.bIsInitializing) {
            return;
        }
        Player localPlayer = this.client.getLocalPlayer();
        this.SinceLastInputTimer += (double)0.6f;
        if (this.enableAutoRecalculate) {
            this.Timer += 0.6f;
            if (this.Timer > 5.0f) {
                this.Timer = 0.0f;
                this.QueueRefresh();
            }
        }
        if (this.isTaskWindowOpen()) {
            if (!this.bWasTaskWindowOpen) {
                this.MarkCompletedTasksFromList();
            }
            this.bWasTaskWindowOpen = true;
        } else {
            this.bWasTaskWindowOpen = false;
        }
        this.CachedPlayer = localPlayer;
        if (localPlayer == null || this.pathfinder == null) {
            return;
        }
        WorldPoint worldPoint = currentLocation = this.client.isInInstancedRegion() ? WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)localPlayer.getLocalLocation()) : localPlayer.getWorldLocation();
        if (currentLocation.distanceTo(this.pathfinder.getTarget()) < this.config.reachedDistance()) {
            this.setTarget(null);
            return;
        }
        if (!this.startPointSet && !this.isNearPath(currentLocation)) {
            if (this.config.cancelInstead()) {
                this.setTarget(null);
                return;
            }
            this.restartPathfinding(currentLocation, this.pathfinder.getTarget(), false);
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        Shape minimap;
        Widget map;
        if (this.bIsInitializing) {
            return;
        }
        if (this.client.isKeyPressed(81) && event.getOption().equals(WALK_HERE) && event.getTarget().isEmpty()) {
            if (this.config.drawTransports()) {
                this.addMenuEntry(event, ADD_START, TRANSPORT, 1);
                this.addMenuEntry(event, ADD_END, TRANSPORT, 1);
            }
            this.addMenuEntry(event, SET, TARGET, 1);
            if (this.pathfinder != null) {
                if (this.pathfinder.getTarget() != null) {
                    this.addMenuEntry(event, SET, START, 1);
                }
                WorldPoint selectedTile = this.getSelectedWorldPoint();
                if (this.pathfinder.getPath() != null) {
                    for (WorldPoint tile : this.pathfinder.getPath()) {
                        if (!tile.equals((Object)selectedTile)) continue;
                        this.addMenuEntry(event, CLEAR, PATH, 1);
                        break;
                    }
                }
            }
        }
        if ((map = this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW)) != null && map.getBounds().contains(this.client.getMouseCanvasPosition().getX(), this.client.getMouseCanvasPosition().getY())) {
            this.addMenuEntry(event, SET, TARGET, 0);
            if (this.pathfinder != null && this.pathfinder.getTarget() != null) {
                this.addMenuEntry(event, SET, START, 0);
                this.addMenuEntry(event, CLEAR, PATH, 0);
            }
        }
        if ((minimap = this.getMinimapClipArea()) != null && this.pathfinder != null && minimap.contains(this.client.getMouseCanvasPosition().getX(), this.client.getMouseCanvasPosition().getY())) {
            this.addMenuEntry(event, CLEAR, PATH, 0);
        }
        if (minimap != null && this.pathfinder != null && ("Floating World Map".equals(Text.removeTags((String)event.getOption())) || "Close Floating panel".equals(Text.removeTags((String)event.getOption())))) {
            this.addMenuEntry(event, CLEAR, PATH, 1);
        }
    }

    public Map<WorldPoint, List<Transport>> getTransports() {
        return this.pathfinderConfig.getTransports();
    }

    public CollisionMap getMap() {
        return this.pathfinderConfig.getMap();
    }

    public Area ObtainWorldMapClipArea(Rectangle baseRectangle) {
        Widget overview = this.client.getWidget(WidgetInfo.WORLD_MAP_OVERVIEW_MAP);
        Widget surfaceSelector = this.client.getWidget(WidgetInfo.WORLD_MAP_SURFACE_SELECTOR);
        Area clipArea = new Area(baseRectangle);
        if (overview != null && !overview.isHidden()) {
            clipArea.subtract(new Area(overview.getBounds()));
        }
        if (surfaceSelector != null && !surfaceSelector.isHidden()) {
            clipArea.subtract(new Area(surfaceSelector.getBounds()));
        }
        return clipArea;
    }

    private void onMenuOptionClicked(MenuEntry entry) {
        WorldPoint currentLocation;
        Player localPlayer = this.client.getLocalPlayer();
        if (localPlayer == null) {
            return;
        }
        WorldPoint worldPoint = currentLocation = this.client.isInInstancedRegion() ? WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)localPlayer.getLocalLocation()) : localPlayer.getWorldLocation();
        if (entry.getOption().equals(ADD_START) && entry.getTarget().equals(TRANSPORT)) {
            this.transportStart = currentLocation;
        }
        if (entry.getOption().equals(ADD_END) && entry.getTarget().equals(TRANSPORT)) {
            WorldPoint transportEnd = this.client.isInInstancedRegion() ? WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)localPlayer.getLocalLocation()) : localPlayer.getWorldLocation();
            System.out.println(this.transportStart.getX() + " " + this.transportStart.getY() + " " + this.transportStart.getPlane() + " " + currentLocation.getX() + " " + currentLocation.getY() + " " + currentLocation.getPlane() + " " + this.lastClick.getOption() + " " + Text.removeTags((String)this.lastClick.getTarget()) + " " + this.lastClick.getIdentifier());
            Transport transport = new Transport(this.transportStart, transportEnd);
            this.pathfinderConfig.getTransports().computeIfAbsent(this.transportStart, k -> new ArrayList()).add(transport);
        }
        if (entry.getOption().equals("Copy Position")) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection("(" + currentLocation.getX() + ", " + currentLocation.getY() + ", " + currentLocation.getPlane() + ")"), null);
        }
        if (entry.getOption().equals(SET) && entry.getTarget().equals(TARGET)) {
            this.setTarget(this.getSelectedWorldPoint());
        }
        if (entry.getOption().equals(SET) && entry.getTarget().equals(START)) {
            this.setStart(this.getSelectedWorldPoint());
        }
        if (entry.getOption().equals(CLEAR) && entry.getTarget().equals(PATH)) {
            this.setTarget(null);
        }
        if (entry.getType() != MenuAction.WALK) {
            this.lastClick = entry;
        }
    }

    public WorldPoint getSelectedWorldPoint() {
        if (this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW) == null) {
            if (this.client.getSelectedSceneTile() != null) {
                return this.client.isInInstancedRegion() ? WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getSelectedSceneTile().getLocalLocation()) : this.client.getSelectedSceneTile().getWorldLocation();
            }
        } else {
            return this.calculateMapPoint(this.client.isMenuOpen() ? this.lastMenuOpenedPoint : this.client.getMouseCanvasPosition());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTarget(WorldPoint target) {
        Player localPlayer = this.client.getLocalPlayer();
        if (!this.startPointSet && localPlayer == null) {
            return;
        }
        if (target == null) {
            Object object = this.pathfinderMutex;
            synchronized (object) {
                if (this.pathfinder != null) {
                    this.pathfinder.cancel();
                }
                this.pathfinder = null;
            }
            this.worldMapPointManager.remove(this.marker);
            this.marker = null;
            this.startPointSet = false;
        } else {
            WorldPoint start;
            this.worldMapPointManager.removeIf(x -> x == this.marker);
            this.marker = new WorldMapPoint(target, MARKER_IMAGE);
            this.marker.setName("Target");
            this.marker.setTarget(this.marker.getWorldPoint());
            this.marker.setJumpOnClick(true);
            this.worldMapPointManager.add(this.marker);
            this.lastLocation = start = this.client.isInInstancedRegion() ? WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)localPlayer.getLocalLocation()) : localPlayer.getWorldLocation();
            if (this.startPointSet && this.pathfinder != null) {
                start = this.pathfinder.getStart();
            }
            this.restartPathfinding(start, target, false);
        }
    }

    private void setStart(WorldPoint start) {
        if (this.pathfinder == null) {
            return;
        }
        this.startPointSet = true;
        this.restartPathfinding(start, this.pathfinder.getTarget(), false);
    }

    public WorldPoint calculateMapPoint(Point point) {
        WorldMap worldMap = this.client.getWorldMap();
        float zoom = worldMap.getWorldMapZoom();
        WorldPoint mapPoint = new WorldPoint(worldMap.getWorldMapPosition().getX(), worldMap.getWorldMapPosition().getY(), 0);
        Point middle = this.mapWorldPointToGraphicsPoint(mapPoint);
        if (point == null || middle == null) {
            return null;
        }
        int dx = (int)((float)(point.getX() - middle.getX()) / zoom);
        int dy = (int)((float)(-(point.getY() - middle.getY())) / zoom);
        return mapPoint.dx(dx).dy(dy);
    }

    public Point mapWorldPointToGraphicsPoint(WorldPoint worldPoint) {
        WorldMap worldMap = this.client.getWorldMap();
        float pixelsPerTile = worldMap.getWorldMapZoom();
        Widget map = this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW);
        if (map != null) {
            Rectangle worldMapRect = map.getBounds();
            int widthInTiles = (int)Math.ceil(worldMapRect.getWidth() / (double)pixelsPerTile);
            int heightInTiles = (int)Math.ceil(worldMapRect.getHeight() / (double)pixelsPerTile);
            Point worldMapPosition = worldMap.getWorldMapPosition();
            int yTileMax = worldMapPosition.getY() - heightInTiles / 2;
            int yTileOffset = (yTileMax - worldPoint.getY() - 1) * -1;
            int xTileOffset = worldPoint.getX() + widthInTiles / 2 - worldMapPosition.getX();
            int xGraphDiff = (int)((float)xTileOffset * pixelsPerTile);
            int yGraphDiff = (int)((float)yTileOffset * pixelsPerTile);
            yGraphDiff = (int)((double)yGraphDiff - ((double)pixelsPerTile - Math.ceil(pixelsPerTile / 2.0f)));
            xGraphDiff = (int)((double)xGraphDiff + ((double)pixelsPerTile - Math.ceil(pixelsPerTile / 2.0f)));
            yGraphDiff = worldMapRect.height - yGraphDiff;
            return new Point(xGraphDiff += (int)worldMapRect.getX(), yGraphDiff += (int)worldMapRect.getY());
        }
        return null;
    }

    private void addMenuEntry(MenuEntryAdded event, String option, String target, int position) {
        LinkedList<MenuEntry> entries = new LinkedList<MenuEntry>(Arrays.asList(this.client.getMenuEntries()));
        if (entries.stream().anyMatch(e -> e.getOption().equals(option) && e.getTarget().equals(target))) {
            return;
        }
        this.client.createMenuEntry(position).setOption(option).setTarget(target).setParam0(event.getActionParam0()).setParam1(event.getActionParam1()).setIdentifier(event.getIdentifier()).setType(MenuAction.RUNELITE).onClick(this::onMenuOptionClicked);
    }

    private Widget getMinimapDrawWidget() {
        if (this.client.isResized()) {
            if (this.client.getVarbitValue(4607) == 1) {
                return this.client.getWidget(WidgetInfo.RESIZABLE_MINIMAP_DRAW_AREA);
            }
            return this.client.getWidget(WidgetInfo.RESIZABLE_MINIMAP_STONES_DRAW_AREA);
        }
        return this.client.getWidget(WidgetInfo.FIXED_VIEWPORT_MINIMAP_DRAW_AREA);
    }

    private Shape getMinimapClipAreaSimple() {
        Widget minimapDrawArea = this.getMinimapDrawWidget();
        if (minimapDrawArea == null || minimapDrawArea.isHidden()) {
            return null;
        }
        Rectangle bounds = minimapDrawArea.getBounds();
        return new Ellipse2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    public Shape getMinimapClipArea() {
        Widget minimapWidget = this.getMinimapDrawWidget();
        if (minimapWidget == null || minimapWidget.isHidden() || !(this.minimapRectangle = minimapWidget.getBounds()).equals(this.minimapRectangle)) {
            this.minimapClipFixed = null;
            this.minimapClipResizeable = null;
            this.minimapSpriteFixed = null;
            this.minimapSpriteResizeable = null;
        }
        if (this.client.isResized()) {
            if (this.minimapClipResizeable != null) {
                return this.minimapClipResizeable;
            }
            if (this.minimapSpriteResizeable == null) {
                this.minimapSpriteResizeable = this.spriteManager.getSprite(1178, 0);
            }
            if (this.minimapSpriteResizeable != null) {
                this.minimapClipResizeable = this.bufferedImageToPolygon(this.minimapSpriteResizeable);
                return this.minimapClipResizeable;
            }
            return this.getMinimapClipAreaSimple();
        }
        if (this.minimapClipFixed != null) {
            return this.minimapClipFixed;
        }
        if (this.minimapSpriteFixed == null) {
            this.minimapSpriteFixed = this.spriteManager.getSprite(1183, 0);
        }
        if (this.minimapSpriteFixed != null) {
            this.minimapClipFixed = this.bufferedImageToPolygon(this.minimapSpriteFixed);
            return this.minimapClipFixed;
        }
        return this.getMinimapClipAreaSimple();
    }

    private Polygon bufferedImageToPolygon(BufferedImage image) {
        Color outsideColour = null;
        int width = image.getWidth();
        int height = image.getHeight();
        ArrayList<java.awt.Point> points = new ArrayList<java.awt.Point>();
        for (int y = 0; y < height; ++y) {
            Color previousColour = outsideColour;
            for (int x = 0; x < width; ++x) {
                int rgb = image.getRGB(x, y);
                int a = (rgb & 0xFF000000) >>> 24;
                int r = (rgb & 0xFF0000) >> 16;
                int g = (rgb & 0xFF00) >> 8;
                int b = (rgb & 0xFF) >> 0;
                Color colour = new Color(r, g, b, a);
                if (x == 0 && y == 0) {
                    outsideColour = colour;
                    previousColour = colour;
                }
                if (!colour.equals(outsideColour) && previousColour.equals(outsideColour)) {
                    points.add(new java.awt.Point(x, y));
                }
                if ((colour.equals(outsideColour) || x == width - 1) && !previousColour.equals(outsideColour)) {
                    points.add(0, new java.awt.Point(x, y));
                }
                previousColour = colour;
            }
        }
        int offsetX = this.minimapRectangle.x;
        int offsetY = this.minimapRectangle.y;
        Polygon polygon = new Polygon();
        for (java.awt.Point point : points) {
            polygon.addPoint(point.x + offsetX, point.y + offsetY);
        }
        return polygon;
    }

    void SaveRegionBounds() throws IOException {
        if (this.bSaveRegionData) {
            File targ = new File("RegionBoundData.csv");
            LeaguesPlannerConfig.RegionData.exportTo(targ);
        }
    }

    void LoadRegionBounds() throws IOException {
        File targ = new File("RegionBoundData.csv");
        LeaguesPlannerConfig.RegionData.importFrom(targ);
    }

    void LoadTaskData() throws IOException {
        LeaguesPlannerConfig.TaskData.LeaguesTaskList.clear();
        LeaguesPlannerConfig.TaskData.StringToTask.clear();
        File targ = new File("ConvertedTaskData/TrailblazerTaskData.csv");
        LeaguesPlannerConfig.TaskData.importFromConverted(targ);
        targ = new File("ConvertedTaskData/ShatteredTaskData.csv");
        LeaguesPlannerConfig.TaskData.importFromConverted(targ);
        if (this.bLoadRawWikiData) {
            LeaguesPlannerConfig.TaskData.importFromRaw();
        }
        if (this.bCalculateOverworldPositions) {
            LeaguesPlannerConfig.TaskData.CalculateAndCacheOverworldLocations(this);
        }
        targ = new File("UserData.csv");
        LeaguesPlannerConfig.UserData.importFrom(targ);
    }

    private boolean GatherRegionBounds(WorldPointPolygon poly, ArrayList<RegionLine> regionLines, Set<UUID> VisitedPoints, LeagueRegionPoint nextPoint, LeagueRegionPoint parentPoint) {
        if (VisitedPoints.contains(nextPoint.GUID)) {
            return true;
        }
        VisitedPoints.add(nextPoint.GUID);
        WorldPoint end = nextPoint.OurWorldPoint;
        poly.AddWorldPoint(end);
        if (parentPoint != null) {
            WorldPoint start = parentPoint.OurWorldPoint;
            regionLines.add(new RegionLine(start, end));
        }
        for (LeagueRegionPoint connectedPoint : nextPoint.ConnectedPoints) {
            if (parentPoint == connectedPoint || !this.GatherRegionBounds(poly, regionLines, VisitedPoints, connectedPoint, nextPoint)) continue;
            return true;
        }
        return false;
    }

    private void RefreshRegionBounds() {
        HashSet VisitedPoints = new HashSet();
        for (LeagueRegionBounds regionDatum : LeaguesPlannerConfig.RegionData.RegionData) {
            Color DrawColor = RegionType.GetRegionColor(this.config, regionDatum.Type, true);
            regionDatum.RegionPolygons.clear();
            regionDatum.RegionLines.clear();
            regionDatum.RegionPoints.forEach((key, value) -> {
                if (VisitedPoints.contains(value.GUID)) {
                    return;
                }
                WorldPointPolygon newPolygon = new WorldPointPolygon();
                if (this.GatherRegionBounds(newPolygon, regionDatum.RegionLines, VisitedPoints, (LeagueRegionPoint)value, null)) {
                    regionDatum.RegionPolygons.add(newPolygon);
                    newPolygon.CacheWorldPoly();
                }
            });
        }
    }

    public void InitializeRegionData() throws Exception {
        LeaguesPlannerConfig.RegionData.RegionData.clear();
        for (RegionType CurrentRegion : RegionType.values()) {
            if (CurrentRegion == RegionType.NONE) continue;
            LeaguesPlannerConfig.RegionData.RegionData.add(new LeagueRegionBounds(CurrentRegion));
        }
        this.LoadRegionBounds();
        for (LeagueRegionBounds LocalCurrentRegion : LeaguesPlannerConfig.RegionData.RegionData) {
            LocalCurrentRegion.RegionPoints.forEach((key, value) -> this.SetMarkerActivation((LeagueRegionPoint)value, false));
        }
        this.RefreshRegionBounds();
        this.overlayManager.add((Overlay)this.regionBoundOverlay);
    }

    public void ShutdownRegionData() {
        this.overlayManager.remove((Overlay)this.regionBoundOverlay);
        this.worldMapPointManager.removeIf(x -> x.getName() != null && x.getName().contains("LP:"));
    }

    public LeagueRegionBounds GetRegionBounds(RegionType Type) {
        for (LeagueRegionBounds CurrentBounds : LeaguesPlannerConfig.RegionData.RegionData) {
            if (CurrentBounds.Type != Type) continue;
            return CurrentBounds;
        }
        return null;
    }

    public void InitializeTaskData() throws Exception {
        LeaguesPlannerConfig.TaskData.LeaguesTaskList.clear();
        this.LoadTaskData();
        this.overlayManager.add((Overlay)this.taskOverlay);
    }

    public void ShutdownTaskData() {
        this.overlayManager.remove((Overlay)this.taskOverlay);
    }

    public BufferedImage GetRegionImage(RegionType Type) {
        switch (Type) {
            case MISTHALIN: {
                return BOUNDS_MISTHALIN;
            }
            case KARAMJA: {
                return BOUNDS_KARAMJA;
            }
            case KANDARIN: {
                return BOUNDS_KANDARIN;
            }
            case ASGARNIA: {
                return BOUNDS_ASGARNIA;
            }
            case FREMENNIK: {
                return BOUNDS_FREMENNIK;
            }
            case KOUREND: {
                return BOUNDS_KOUREND;
            }
            case WILDERNESS: {
                return BOUNDS_WILDERNESS;
            }
            case MORYTANIA: {
                return BOUNDS_MORYTANIA;
            }
            case TIRANNWN: {
                return BOUNDS_TIRANNWN;
            }
            case DESERT: {
                return BOUNDS_DESERT;
            }
        }
        return MARKER_IMAGE;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            // empty if block
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (this.bIsInitializing) {
            return;
        }
        Widget map = this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW);
        if (map == null) {
            return;
        }
        if (!map.getBounds().contains(this.client.getMouseCanvasPosition().getX(), this.client.getMouseCanvasPosition().getY())) {
            return;
        }
        LeagueRegionPoint ClickedPoint = this.GetClickedRegionPoint(Collections.singletonList(event.getMenuEntry()));
        if (ClickedPoint != null && event.getMenuOption().contains("Focus on")) {
            this.SetMarkerActivation(ClickedPoint, this.CurrentFocusedPoint != ClickedPoint);
            this.RefreshRegionBounds();
        }
    }

    @Provides
    LeaguesPlannerConfig provideConfig(ConfigManager configManager) {
        return (LeaguesPlannerConfig)configManager.getConfig(LeaguesPlannerConfig.class);
    }

    private WorldPoint CalculateMapPoint(Point point) {
        if (point == null) {
            return null;
        }
        float zoom = this.client.getRenderOverview().getWorldMapZoom();
        RenderOverview renderOverview = this.client.getRenderOverview();
        WorldPoint mapPoint = new WorldPoint(renderOverview.getWorldMapPosition().getX(), renderOverview.getWorldMapPosition().getY(), 0);
        Point middle = this.worldMapOverlay.mapWorldPointToGraphicsPoint(mapPoint);
        if (middle == null) {
            return null;
        }
        int dx = (int)((float)(point.getX() - middle.getX()) / zoom);
        int dy = (int)((float)(-(point.getY() - middle.getY())) / zoom);
        return mapPoint.dx(dx).dy(dy);
    }

    private final void SetMarkerActivation(LeagueRegionPoint RegionPoint, boolean shouldActivate) {
        if (this.config.GetEditRegion() == RegionType.NONE) {
            return;
        }
        if (shouldActivate) {
            if (this.CurrentFocusedPoint != null) {
                this.SetMarkerActivation(this.CurrentFocusedPoint, false);
            }
            this.CurrentFocusedPoint = RegionPoint;
            WorldMapPoint OldMarker = RegionPoint.OurPoint;
            this.worldMapPointManager.removeIf(x -> x == OldMarker);
            WorldPoint WorldPointLocation = RegionPoint.OurWorldPoint == null ? this.LastDisplayedWorldPoint : RegionPoint.OurWorldPoint;
            RegionPoint.OurPoint = new WorldMapPoint(WorldPointLocation, BOUNDS_SELECTED);
            RegionPoint.OurWorldPoint = WorldPointLocation;
            WorldMapPoint NewMarker = RegionPoint.OurPoint;
            NewMarker.setTarget(WorldPointLocation);
            NewMarker.setJumpOnClick(true);
            NewMarker.setName("LP: Region Bounds: " + RegionPoint.Region + " " + WorldPointLocation + " guid:" + RegionPoint.GUID);
            this.worldMapPointManager.add(NewMarker);
        } else {
            WorldMapPoint OldMarker = RegionPoint.OurPoint;
            this.worldMapPointManager.removeIf(x -> x == OldMarker);
            WorldPoint WorldPointLocation = RegionPoint.OurWorldPoint == null ? this.LastDisplayedWorldPoint : RegionPoint.OurWorldPoint;
            RegionPoint.OurPoint = new WorldMapPoint(WorldPointLocation, this.GetRegionImage(RegionPoint.Region));
            RegionPoint.OurWorldPoint = WorldPointLocation;
            WorldMapPoint NewMarker = RegionPoint.OurPoint;
            NewMarker.setTarget(WorldPointLocation);
            NewMarker.setJumpOnClick(true);
            NewMarker.setName("LP: Region Bounds: " + RegionPoint.Region + " " + WorldPointLocation + " guid:" + RegionPoint.GUID);
            this.worldMapPointManager.add(NewMarker);
        }
    }

    TaskData GetTaskData(UUID TaskID, Boolean bIsCustomTask) {
        if (bIsCustomTask.booleanValue()) {
            return LeaguesPlannerConfig.UserData.CustomTasks.get(TaskID);
        }
        return LeaguesPlannerConfig.TaskData.LeaguesTaskList.get(TaskID);
    }

    public void FocusOnTaskOnWorldMap(TaskData CurrentTask) {
        if (this.bIsInitializing) {
            return;
        }
        if (this.client != null && this.client.getWorldMap() != null) {
            WorldPoint FocusLocation;
            double ShortestMapViewDistance = 1000000.0;
            WorldPoint ShortestMapViewWorldPoint = null;
            WorldMap worldMap = this.client.getWorldMap();
            if (worldMap != null) {
                double TaskDistance;
                WorldPoint mapPoint = new WorldPoint(worldMap.getWorldMapPosition().getX(), worldMap.getWorldMapPosition().getY(), 0);
                for (WorldPoint CurrentLocation : CurrentTask.Locations) {
                    TaskDistance = CurrentLocation.distanceTo(mapPoint);
                    if (!(TaskDistance < ShortestMapViewDistance)) continue;
                    ShortestMapViewDistance = TaskDistance;
                    ShortestMapViewWorldPoint = CurrentLocation;
                }
                for (WorldPoint CurrentLocation : CurrentTask.OverworldLocations) {
                    TaskDistance = CurrentLocation.distanceTo(mapPoint);
                    if (!(TaskDistance < ShortestMapViewDistance)) continue;
                    ShortestMapViewDistance = TaskDistance;
                    ShortestMapViewWorldPoint = CurrentLocation;
                }
            }
            if ((FocusLocation = ShortestMapViewWorldPoint) == null && !CurrentTask.Locations.isEmpty()) {
                FocusLocation = CurrentTask.Locations.get(0);
            }
            if (FocusLocation != null) {
                this.client.getWorldMap().setWorldMapPositionTarget(FocusLocation);
            }
        }
    }

    public void RegisterCustomIcon(String CustomIconName) {
        this.CustomIconsMap.put(CustomIconName, ImageUtil.loadImageResource(PosiedienLeaguesPlannerPlugin.class, (String)CustomIconName));
    }

    public void InitializeCustomIconsMap() {
        this.RegisterCustomIcon("/AGILITY.png");
        this.RegisterCustomIcon("/ATTACK.png");
        this.RegisterCustomIcon("/CONSTRUCTION.png");
        this.RegisterCustomIcon("/COOKING.png");
        this.RegisterCustomIcon("/CRAFTING.png");
        this.RegisterCustomIcon("/DEFENCE.png");
        this.RegisterCustomIcon("/FARMING.png");
        this.RegisterCustomIcon("/FIREMAKING.png");
        this.RegisterCustomIcon("/FISHING.png");
        this.RegisterCustomIcon("/FLETCHING.png");
        this.RegisterCustomIcon("/HERBLORE.png");
        this.RegisterCustomIcon("/HITPOINTS.png");
        this.RegisterCustomIcon("/HUNTER.png");
        this.RegisterCustomIcon("/MAGIC.png");
        this.RegisterCustomIcon("/MINING.png");
        this.RegisterCustomIcon("/PRAYER.png");
        this.RegisterCustomIcon("/RANGED.png");
        this.RegisterCustomIcon("/RUNECRAFT.png");
        this.RegisterCustomIcon("/SMITHING.png");
        this.RegisterCustomIcon("/STRENGTH.png");
        this.RegisterCustomIcon("/THIEVING.png");
        this.RegisterCustomIcon("/taskMarkerPurp.png");
        this.RegisterCustomIcon("/taskMarkerRed.png");
        this.RegisterCustomIcon("/taskMarker.png");
        this.RegisterCustomIcon("/taskMarkerGreen.png");
        this.RegisterCustomIcon("/taskMarkerGreenEasy.png");
        this.RegisterCustomIcon("/taskMarkerGreenElite.png");
        this.RegisterCustomIcon("/taskMarkerGreenHard.png");
        this.RegisterCustomIcon("/taskMarkerGreenMedium.png");
        this.RegisterCustomIcon("/STRENGTH.png");
        this.RegisterCustomIcon("/icon_background.png");
        this.RegisterCustomIcon("/BlankIcon.png");
    }

    private final LeagueRegionPoint GetClickedRegionPoint(List<MenuEntry> entries) {
        for (MenuEntry CurrentEntry : entries) {
            int index;
            String SubString;
            UUID FoundGUID;
            LeagueRegionPoint FoundPoint;
            if (!CurrentEntry.getOption().contains("Focus")) continue;
            String TargetString = CurrentEntry.getTarget();
            if (this.CurrentRegion == null || !TargetString.contains("Region Bounds: ") || (FoundPoint = this.CurrentRegion.RegionPoints.get(FoundGUID = UUID.fromString(SubString = TargetString.substring((index = TargetString.indexOf("guid:")) + 5, index + 5 + 36)))) == null) continue;
            return FoundPoint;
        }
        return null;
    }

    private void AddRightClickMenuEntries(MenuOpened event) {
        LinkedList<MenuEntry> entries = new LinkedList<MenuEntry>(Arrays.asList(event.getMenuEntries()));
        this.LastDisplayedWorldPoint = this.CalculateMapPoint(this.client.isMenuOpen() ? this.lastMenuOpenedPoint : this.client.getMouseCanvasPosition());
        if (this.LastDisplayedWorldPoint == null) {
            return;
        }
        this.LastClickedRegionPoint = this.GetClickedRegionPoint(entries);
        if (this.CurrentFocusedPoint != null && this.CurrentRegion != null && this.CurrentRegion.Type != this.CurrentFocusedPoint.Region) {
            this.SetMarkerActivation(this.CurrentFocusedPoint, false);
            this.CurrentFocusedPoint = null;
        }
        if (this.taskOverlay != null) {
            MenuEntry customtaskMenu = this.client.createMenuEntry(-1);
            customtaskMenu.setTarget(ColorUtil.wrapWithColorTag((String)"Custom Task", (Color)Color.YELLOW));
            customtaskMenu.setOption("Create");
            customtaskMenu.onClick(this.CreateCustomTask);
            customtaskMenu.setType(MenuAction.RUNELITE);
            entries.add(0, customtaskMenu);
            this.HashCodeToHash.clear();
            ArrayList<TaskDisplayPoint> ClickedPoints = this.taskOverlay.GetClickedDisplayPoint(this.getSelectedWorldPoint());
            for (TaskDisplayPoint CurrentDisplayPoint : ClickedPoints) {
                for (Map.Entry<UUID, Boolean> mapElement : CurrentDisplayPoint.Tasks.entrySet()) {
                    MenuEntry plannedTaskMenu2;
                    UUID TaskGUID = mapElement.getKey();
                    boolean bIsCustomTask = mapElement.getValue();
                    TaskData CurrentTask = this.GetTaskData(TaskGUID, bIsCustomTask);
                    this.HashCodeToHash.put(TaskGUID.hashCode(), CurrentTask);
                    if (bIsCustomTask) {
                        MenuEntry customtaskMenu2 = this.client.createMenuEntry(-1);
                        customtaskMenu2.setTarget(ColorUtil.wrapWithColorTag((String)"Custom Task", (Color)Color.YELLOW));
                        customtaskMenu2.setOption("Destroy");
                        customtaskMenu2.onClick(this.DestroyCustomTask);
                        customtaskMenu2.setType(MenuAction.RUNELITE);
                        customtaskMenu2.setParam0(TaskGUID.hashCode());
                        entries.add(0, customtaskMenu2);
                        MenuEntry customtaskMenu3 = this.client.createMenuEntry(-1);
                        customtaskMenu3.setTarget(ColorUtil.wrapWithColorTag((String)"Custom Task", (Color)Color.YELLOW));
                        customtaskMenu3.setOption("Change Icon");
                        customtaskMenu3.onClick(this.ChangeIconCustomTask);
                        customtaskMenu3.setType(MenuAction.RUNELITE);
                        customtaskMenu3.setParam0(TaskGUID.hashCode());
                        entries.add(0, customtaskMenu3);
                    }
                    if (!LeaguesPlannerConfig.UserData.PlannedTasks.containsKey(TaskGUID)) {
                        MenuEntry plannedTaskMenu = this.client.createMenuEntry(-1);
                        plannedTaskMenu.setTarget(ColorUtil.wrapWithColorTag((String)CurrentTask.TaskName, (Color)TaskDifficulty.GetTaskDifficultyColor(CurrentTask.Difficulty)));
                        plannedTaskMenu.setOption("Add to plan (back)");
                        plannedTaskMenu.onClick(this.AddTaskToBackOfPlan);
                        plannedTaskMenu.setType(MenuAction.RUNELITE);
                        plannedTaskMenu.setParam0(TaskGUID.hashCode());
                        entries.add(0, plannedTaskMenu);
                        plannedTaskMenu2 = this.client.createMenuEntry(-1);
                        plannedTaskMenu2.setTarget(ColorUtil.wrapWithColorTag((String)CurrentTask.TaskName, (Color)TaskDifficulty.GetTaskDifficultyColor(CurrentTask.Difficulty)));
                        plannedTaskMenu2.setOption("Add to plan (front)");
                        plannedTaskMenu2.onClick(this.AddTaskToFrontOfPlan);
                        plannedTaskMenu2.setType(MenuAction.RUNELITE);
                        plannedTaskMenu2.setParam0(TaskGUID.hashCode());
                        entries.add(0, plannedTaskMenu2);
                        continue;
                    }
                    MenuEntry plannedTaskMenu3 = this.client.createMenuEntry(-1);
                    plannedTaskMenu3.setTarget(ColorUtil.wrapWithColorTag((String)CurrentTask.TaskName, (Color)TaskDifficulty.GetTaskDifficultyColor(CurrentTask.Difficulty)));
                    plannedTaskMenu3.setOption("Move back on plan");
                    plannedTaskMenu3.onClick(this.MoveBackOnPlan);
                    plannedTaskMenu3.setType(MenuAction.RUNELITE);
                    plannedTaskMenu3.setParam0(TaskGUID.hashCode());
                    entries.add(0, plannedTaskMenu3);
                    plannedTaskMenu2 = this.client.createMenuEntry(-1);
                    plannedTaskMenu2.setTarget(ColorUtil.wrapWithColorTag((String)CurrentTask.TaskName, (Color)TaskDifficulty.GetTaskDifficultyColor(CurrentTask.Difficulty)));
                    plannedTaskMenu2.setOption("Move forward on plan");
                    plannedTaskMenu2.onClick(this.MoveForwardOnPlan);
                    plannedTaskMenu2.setType(MenuAction.RUNELITE);
                    plannedTaskMenu2.setParam0(TaskGUID.hashCode());
                    entries.add(0, plannedTaskMenu2);
                    MenuEntry plannedTaskMenu = this.client.createMenuEntry(-1);
                    plannedTaskMenu.setTarget(ColorUtil.wrapWithColorTag((String)CurrentTask.TaskName, (Color)TaskDifficulty.GetTaskDifficultyColor(CurrentTask.Difficulty)));
                    plannedTaskMenu.setOption("Remove from plan");
                    plannedTaskMenu.onClick(this.RemoveTaskFromPlan);
                    plannedTaskMenu.setType(MenuAction.RUNELITE);
                    plannedTaskMenu.setParam0(TaskGUID.hashCode());
                    entries.add(0, plannedTaskMenu);
                }
            }
        }
        Object nextOption = null;
        if (this.config.GetEditRegion() != RegionType.NONE) {
            if (this.LastClickedRegionPoint == null) {
                nextOption = "Set Next Region Point";
                String finalNextOption1 = nextOption;
                if (entries.stream().noneMatch(e -> e.getOption().equals(finalNextOption1))) {
                    MenuEntry SetNextRegionPointEntry = this.client.createMenuEntry(-1);
                    SetNextRegionPointEntry.setOption((String)nextOption);
                    SetNextRegionPointEntry.setType(MenuAction.RUNELITE);
                    SetNextRegionPointEntry.onClick(this.SetNextRegionPointEntryCallback);
                    entries.add(0, SetNextRegionPointEntry);
                }
            } else {
                if (this.CurrentFocusedPoint != this.LastClickedRegionPoint) {
                    Object finalNextOption2 = nextOption = "Set Active Region Point";
                    if (entries.stream().noneMatch(arg_0 -> PosiedienLeaguesPlannerPlugin.lambda$AddRightClickMenuEntries$28((String)finalNextOption2, arg_0))) {
                        MenuEntry SetActiveRegionPointEntry = this.client.createMenuEntry(-1);
                        SetActiveRegionPointEntry.setOption((String)nextOption);
                        SetActiveRegionPointEntry.setType(MenuAction.RUNELITE);
                        SetActiveRegionPointEntry.onClick(this.SetActiveRegionPointEntryCallback);
                        entries.add(0, SetActiveRegionPointEntry);
                    }
                    if (this.CurrentFocusedPoint != null) {
                        Object finalNextOption4 = nextOption = "Connect Region Point";
                        if (entries.stream().noneMatch(arg_0 -> PosiedienLeaguesPlannerPlugin.lambda$AddRightClickMenuEntries$29((String)finalNextOption4, arg_0))) {
                            MenuEntry ConnectRegionPointEntry = this.client.createMenuEntry(-1);
                            ConnectRegionPointEntry.setOption((String)nextOption);
                            ConnectRegionPointEntry.setType(MenuAction.RUNELITE);
                            ConnectRegionPointEntry.onClick(this.ConnectRegionPointEntryCallback);
                            entries.add(0, ConnectRegionPointEntry);
                        }
                    }
                }
                Object finalNextOption3 = nextOption = "Delete Region Point";
                if (entries.stream().noneMatch(arg_0 -> PosiedienLeaguesPlannerPlugin.lambda$AddRightClickMenuEntries$30((String)finalNextOption3, arg_0))) {
                    MenuEntry DeleteRegionPointEntry = this.client.createMenuEntry(-1);
                    DeleteRegionPointEntry.setOption((String)nextOption);
                    DeleteRegionPointEntry.setType(MenuAction.RUNELITE);
                    DeleteRegionPointEntry.onClick(this.DeleteRegionPointEntryCallback);
                    entries.add(0, DeleteRegionPointEntry);
                }
            }
        }
        if (this.config.GetEditRegion() == RegionType.NONE) {
            Object finalNextOption = nextOption = "Map Coordinate: " + this.LastDisplayedWorldPoint;
            if (entries.stream().noneMatch(arg_0 -> PosiedienLeaguesPlannerPlugin.lambda$AddRightClickMenuEntries$31((String)finalNextOption, arg_0))) {
                MenuEntry MapCoordEntry = this.client.createMenuEntry(-1);
                MapCoordEntry.setOption((String)nextOption);
                MapCoordEntry.setType(MenuAction.RUNELITE);
                entries.add(0, MapCoordEntry);
            }
        }
        this.client.setMenuEntries(entries.toArray(new MenuEntry[0]));
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public ClientThread getClientThread() {
        return this.clientThread;
    }

    public Pathfinder getPathfinder() {
        return this.pathfinder;
    }

    public boolean isStartPointSet() {
        return this.startPointSet;
    }

    private static /* synthetic */ boolean lambda$AddRightClickMenuEntries$31(String finalNextOption, MenuEntry e) {
        return e.getOption().equals(finalNextOption);
    }

    private static /* synthetic */ boolean lambda$AddRightClickMenuEntries$30(String finalNextOption3, MenuEntry e) {
        return e.getOption().equals(finalNextOption3);
    }

    private static /* synthetic */ boolean lambda$AddRightClickMenuEntries$29(String finalNextOption4, MenuEntry e) {
        return e.getOption().equals(finalNextOption4);
    }

    private static /* synthetic */ boolean lambda$AddRightClickMenuEntries$28(String finalNextOption2, MenuEntry e) {
        return e.getOption().equals(finalNextOption2);
    }
}

