/*
 * Decompiled with CFR 0.152.
 */
package Posiedien_Leagues_Planner;

import Posiedien_Leagues_Planner.LeaguesPlannerConfig;
import Posiedien_Leagues_Planner.PosiedienLeaguesPlannerPlugin;
import Posiedien_Leagues_Planner.TileCounter;
import Posiedien_Leagues_Planner.TileStyle;
import Posiedien_Leagues_Planner.Transport;
import Posiedien_Leagues_Planner.pathfinder.CollisionMap;
import Posiedien_Leagues_Planner.pathfinder.Pathfinder;
import com.google.inject.Inject;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;

public class PathTileOverlay
extends Overlay {
    private final Client client;
    private final PosiedienLeaguesPlannerPlugin plugin;
    private final LeaguesPlannerConfig config;

    @Inject
    public PathTileOverlay(Client client, PosiedienLeaguesPlannerPlugin plugin, LeaguesPlannerConfig config) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    private void renderTransports(Graphics2D graphics) {
        for (WorldPoint a : this.plugin.getTransports().keySet()) {
            this.drawTile(graphics, a, this.config.colourTransports(), -1, true);
            Point ca = this.tileCenter(a);
            if (ca == null) continue;
            StringBuilder s = new StringBuilder();
            for (Transport b : (List)this.plugin.getTransports().getOrDefault(a, new ArrayList())) {
                for (WorldPoint origin : WorldPoint.toLocalInstance((Client)this.client, (WorldPoint)b.getOrigin())) {
                    Point cb = this.tileCenter(origin);
                    if (cb != null) {
                        graphics.drawLine(ca.getX(), ca.getY(), cb.getX(), cb.getY());
                    }
                    if (origin.getPlane() > a.getPlane()) {
                        s.append("+");
                        continue;
                    }
                    if (origin.getPlane() < a.getPlane()) {
                        s.append("-");
                        continue;
                    }
                    s.append("=");
                }
            }
            graphics.setColor(Color.WHITE);
            graphics.drawString(s.toString(), ca.getX(), ca.getY());
        }
    }

    private void renderCollisionMap(Graphics2D graphics) {
        CollisionMap map = this.plugin.getMap();
        Tile[][] tileArray = this.client.getScene().getTiles()[this.client.getPlane()];
        int n = tileArray.length;
        for (int i = 0; i < n; ++i) {
            Tile[] row;
            for (Tile tile : row = tileArray[i]) {
                Polygon tilePolygon;
                if (tile == null || (tilePolygon = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)tile.getLocalLocation())) == null) continue;
                WorldPoint location = this.client.isInInstancedRegion() ? WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)tile.getLocalLocation()) : tile.getWorldLocation();
                int x = location.getX();
                int y = location.getY();
                int z = location.getPlane();
                String s = (!map.n(x, y, z) ? "n" : "") + (!map.s(x, y, z) ? "s" : "") + (!map.e(x, y, z) ? "e" : "") + (!map.w(x, y, z) ? "w" : "");
                if (map.isBlocked(x, y, z)) {
                    graphics.setColor(this.config.colourCollisionMap());
                    graphics.fill(tilePolygon);
                }
                if (s.isEmpty() || s.equals("nsew")) continue;
                graphics.setColor(Color.WHITE);
                int stringX = (int)(tilePolygon.getBounds().getCenterX() - graphics.getFontMetrics().getStringBounds(s, graphics).getWidth() / 2.0);
                int stringY = (int)tilePolygon.getBounds().getCenterY();
                graphics.drawString(s, stringX, stringY);
            }
        }
    }

    public Dimension render(Graphics2D graphics) {
        ArrayList<Pathfinder> pathfinderArray;
        if (this.plugin.bIsInitializing) {
            return null;
        }
        if (this.config.drawTransports()) {
            this.renderTransports(graphics);
        }
        if (this.config.drawCollisionMap()) {
            this.renderCollisionMap(graphics);
        }
        if (this.config.drawTiles() && this.plugin.getPathfinder() != null && this.plugin.getPathfinder().getPath() != null) {
            Color color = this.plugin.getPathfinder().isDone() ? new Color(this.config.colourPath().getRed(), this.config.colourPath().getGreen(), this.config.colourPath().getBlue(), this.config.colourPath().getAlpha() / 2) : new Color(this.config.colourPathCalculating().getRed(), this.config.colourPathCalculating().getGreen(), this.config.colourPathCalculating().getBlue(), this.config.colourPathCalculating().getAlpha() / 2);
            List<WorldPoint> path = this.plugin.getPathfinder().getPath();
            int counter = 0;
            if (TileStyle.LINES.equals((Object)this.config.pathStyle())) {
                for (int i = 1; i < path.size(); ++i) {
                    this.drawLine(graphics, path.get(i - 1), path.get(i), color, 1 + counter++);
                    this.drawFairyRingCode(graphics, path.get(i - 1), path.get(i));
                }
            } else {
                boolean showTiles = TileStyle.TILES.equals((Object)this.config.pathStyle());
                for (int i = 0; i < path.size(); ++i) {
                    this.drawTile(graphics, path.get(i), color, counter++, showTiles);
                    this.drawFairyRingCode(graphics, path.get(i), i + 1 == path.size() ? null : path.get(i + 1));
                }
            }
        }
        if ((pathfinderArray = this.plugin.panel.getPathfinderArray()) != null) {
            for (Pathfinder CurrentPathfinder : pathfinderArray) {
                if (!this.config.drawTiles() || CurrentPathfinder == null || CurrentPathfinder.getPath() == null) continue;
                Color color = CurrentPathfinder.isDone() ? new Color(Color.RED.getRed(), Color.RED.getGreen(), Color.RED.getBlue(), Color.RED.getAlpha() / 4) : new Color(Color.CYAN.getRed(), Color.CYAN.getGreen(), Color.CYAN.getBlue(), Color.CYAN.getAlpha() / 4);
                List<WorldPoint> path = CurrentPathfinder.getPath();
                int counter = 0;
                if (TileStyle.LINES.equals((Object)this.config.pathStyle())) {
                    for (int i = 1; i < path.size(); ++i) {
                        this.drawLine(graphics, path.get(i - 1), path.get(i), color, 1 + counter++);
                        this.drawFairyRingCode(graphics, path.get(i - 1), path.get(i));
                    }
                    continue;
                }
                boolean showTiles = TileStyle.TILES.equals((Object)this.config.pathStyle());
                for (int i = 0; i < path.size(); ++i) {
                    this.drawTile(graphics, path.get(i), color, counter++, showTiles);
                    this.drawFairyRingCode(graphics, path.get(i), i + 1 == path.size() ? null : path.get(i + 1));
                }
            }
        }
        return null;
    }

    private Point tileCenter(WorldPoint b) {
        if (b.getPlane() != this.client.getPlane()) {
            return null;
        }
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)b);
        if (lp == null) {
            return null;
        }
        Polygon poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)lp);
        if (poly == null) {
            return null;
        }
        int cx = poly.getBounds().x + poly.getBounds().width / 2;
        int cy = poly.getBounds().y + poly.getBounds().height / 2;
        return new Point(cx, cy);
    }

    private void drawTile(Graphics2D graphics, WorldPoint location, Color color, int counter, boolean draw) {
        for (WorldPoint point : WorldPoint.toLocalInstance((Client)this.client, (WorldPoint)location)) {
            Polygon poly;
            LocalPoint lp;
            if (point.getPlane() != this.client.getPlane() || (lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)point)) == null || (poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)lp)) == null) continue;
            if (draw) {
                graphics.setColor(color);
                graphics.fill(poly);
            }
            this.drawCounter(graphics, poly.getBounds().getCenterX(), poly.getBounds().getCenterY(), counter);
        }
    }

    private void drawLine(Graphics2D graphics, WorldPoint startLoc, WorldPoint endLoc, Color color, int counter) {
        WorldPoint start = (WorldPoint)WorldPoint.toLocalInstance((Client)this.client, (WorldPoint)startLoc).iterator().next();
        WorldPoint end = (WorldPoint)WorldPoint.toLocalInstance((Client)this.client, (WorldPoint)endLoc).iterator().next();
        int z = this.client.getPlane();
        if (start.getPlane() != z) {
            return;
        }
        LocalPoint lpStart = LocalPoint.fromWorld((Client)this.client, (WorldPoint)start);
        LocalPoint lpEnd = LocalPoint.fromWorld((Client)this.client, (WorldPoint)end);
        if (lpStart == null || lpEnd == null) {
            return;
        }
        int startHeight = Perspective.getTileHeight((Client)this.client, (LocalPoint)lpStart, (int)z);
        int endHeight = Perspective.getTileHeight((Client)this.client, (LocalPoint)lpEnd, (int)z);
        Point p1 = Perspective.localToCanvas((Client)this.client, (int)lpStart.getX(), (int)lpStart.getY(), (int)startHeight);
        Point p2 = Perspective.localToCanvas((Client)this.client, (int)lpEnd.getX(), (int)lpEnd.getY(), (int)endHeight);
        if (p1 == null || p2 == null) {
            return;
        }
        Line2D.Double line = new Line2D.Double(p1.getX(), p1.getY(), p2.getX(), p2.getY());
        graphics.setColor(color);
        graphics.setStroke(new BasicStroke(4.0f));
        graphics.draw(line);
        if (counter == 1) {
            this.drawCounter(graphics, p1.getX(), p1.getY(), 0);
        }
        this.drawCounter(graphics, p2.getX(), p2.getY(), counter);
    }

    private void drawCounter(Graphics2D graphics, double x, double y, int counter) {
        if (counter >= 0 && !TileCounter.DISABLED.equals((Object)this.config.showTileCounter())) {
            int n = this.config.tileCounterStep() > 0 ? this.config.tileCounterStep() : 1;
            int s = this.plugin.getPathfinder().getPath().size();
            if (counter % n != 0 && s != counter + 1) {
                return;
            }
            if (TileCounter.REMAINING.equals((Object)this.config.showTileCounter())) {
                counter = s - counter - 1;
            }
            if (n > 1 && counter == 0) {
                return;
            }
            String counterText = Integer.toString(counter);
            graphics.setColor(this.config.colourText());
            graphics.drawString(counterText, (int)(x - graphics.getFontMetrics().getStringBounds(counterText, graphics).getWidth() / 2.0), (int)y);
        }
    }

    private void drawFairyRingCode(Graphics2D graphics, WorldPoint location, WorldPoint locationEnd) {
        for (WorldPoint point : WorldPoint.toLocalInstance((Client)this.client, (WorldPoint)location)) {
            for (WorldPoint pointEnd : WorldPoint.toLocalInstance((Client)this.client, (WorldPoint)locationEnd)) {
                Point p;
                LocalPoint lp;
                String codeText;
                if (point.getPlane() != this.client.getPlane() || this.fairyRingCode(point) == null || (codeText = this.fairyRingCode(pointEnd)) == null || (lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)point)) == null || (p = Perspective.localToCanvas((Client)this.client, (LocalPoint)lp, (int)this.client.getPlane())) == null) continue;
                Rectangle2D textBounds = graphics.getFontMetrics().getStringBounds(codeText, graphics);
                int x = (int)((double)p.getX() - textBounds.getWidth() / 2.0);
                int y = (int)((double)p.getY() - textBounds.getHeight());
                graphics.setColor(Color.BLACK);
                graphics.drawString(codeText, x + 1, y + 1);
                graphics.setColor(this.config.colourText());
                graphics.drawString(codeText, x, y);
            }
        }
    }

    private String fairyRingCode(WorldPoint point) {
        if (point == null) {
            return null;
        }
        List<WorldPoint> fairyRings = Transport.getFairyRings();
        for (int i = 0; i < fairyRings.size(); ++i) {
            if (!point.equals((Object)fairyRings.get(i))) continue;
            return Transport.getFairyRingCodes().get(i);
        }
        return null;
    }
}

