/*
 * Decompiled with CFR 0.152.
 */
package Posiedien_Leagues_Planner;

import Posiedien_Leagues_Planner.LeaguesPlannerConfig;
import Posiedien_Leagues_Planner.PosiedienLeaguesPlannerPlugin;
import Posiedien_Leagues_Planner.pathfinder.Pathfinder;
import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.List;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;

public class PathMinimapOverlay
extends Overlay {
    private static final int TILE_WIDTH = 4;
    private static final int TILE_HEIGHT = 4;
    private final Client client;
    private final PosiedienLeaguesPlannerPlugin plugin;
    private final LeaguesPlannerConfig config;

    @Inject
    private PathMinimapOverlay(Client client, PosiedienLeaguesPlannerPlugin plugin, LeaguesPlannerConfig config) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
    }

    public Dimension render(Graphics2D graphics) {
        ArrayList<Pathfinder> pathfinderArray;
        if (this.plugin.bIsInitializing) {
            return null;
        }
        if (!this.config.drawMinimap() || this.plugin.getPathfinder() == null && (this.plugin.panel.getPathfinderArray() == null || this.plugin.panel.getPathfinderArray().isEmpty())) {
            return null;
        }
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics.setClip(this.plugin.getMinimapClipArea());
        if (this.plugin.getPathfinder() != null) {
            List<WorldPoint> pathPoints = this.plugin.getPathfinder().getPath();
            Color pathColor = this.plugin.getPathfinder().isDone() ? this.config.colourPath() : this.config.colourPathCalculating();
            for (WorldPoint pathPoint : pathPoints) {
                if (pathPoint.getPlane() != this.client.getPlane()) continue;
                this.drawOnMinimap(graphics, pathPoint, pathColor);
            }
        }
        if ((pathfinderArray = this.plugin.panel.getPathfinderArray()) != null) {
            for (Pathfinder CurrentPathfinder : pathfinderArray) {
                List<WorldPoint> pathPoints = CurrentPathfinder.getPath();
                Color pathColor = CurrentPathfinder.isDone() ? Color.RED : Color.CYAN;
                for (WorldPoint pathPoint : pathPoints) {
                    if (pathPoint.getPlane() != this.client.getPlane()) continue;
                    this.drawOnMinimap(graphics, pathPoint, pathColor);
                }
            }
        }
        return null;
    }

    private void drawOnMinimap(Graphics2D graphics, WorldPoint location, Color color) {
        for (WorldPoint point : WorldPoint.toLocalInstance((Client)this.client, (WorldPoint)location)) {
            Point posOnMinimap;
            LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)point);
            if (lp == null || (posOnMinimap = Perspective.localToMinimap((Client)this.client, (LocalPoint)lp)) == null) continue;
            PathMinimapOverlay.renderMinimapRect(this.client, graphics, posOnMinimap, 4, 4, color);
        }
    }

    public static void renderMinimapRect(Client client, Graphics2D graphics, Point center, int width, int height, Color color) {
        double angle = (double)client.getCameraYawTarget() * Math.PI / 1024.0;
        graphics.setColor(color);
        graphics.rotate(angle, center.getX(), center.getY());
        graphics.fillRect(center.getX() - width / 2, center.getY() - height / 2, width, height);
        graphics.rotate(-angle, center.getX(), center.getY());
    }
}

