/*
 * Decompiled with CFR 0.152.
 */
package Posiedien_Leagues_Planner;

import Posiedien_Leagues_Planner.LeaguesPlannerConfig;
import Posiedien_Leagues_Planner.PosiedienLeaguesPlannerPlugin;
import Posiedien_Leagues_Planner.Transport;
import Posiedien_Leagues_Planner.pathfinder.CollisionMap;
import Posiedien_Leagues_Planner.pathfinder.Pathfinder;
import com.google.inject.Inject;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.List;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.worldmap.WorldMapOverlay;

public class PathMapOverlay
extends Overlay {
    private final Client client;
    private final PosiedienLeaguesPlannerPlugin plugin;
    private final LeaguesPlannerConfig config;
    @Inject
    private WorldMapOverlay worldMapOverlay;

    @Inject
    private PathMapOverlay(Client client, PosiedienLeaguesPlannerPlugin plugin, LeaguesPlannerConfig config) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.MANUAL);
        this.drawAfterLayer(WidgetInfo.WORLD_MAP_VIEW);
    }

    public Dimension render(Graphics2D graphics) {
        ArrayList<Pathfinder> pathfinderArray;
        if (this.plugin.bIsInitializing) {
            return null;
        }
        if (!this.config.drawMap()) {
            return null;
        }
        if (this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW) == null) {
            return null;
        }
        Area worldMapClipArea = this.getWorldMapClipArea(this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW).getBounds());
        graphics.setClip(worldMapClipArea);
        if (this.config.drawCollisionMap()) {
            graphics.setColor(this.config.colourCollisionMap());
            Rectangle extent = this.getWorldMapExtent(this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW).getBounds());
            CollisionMap map = this.plugin.getMap();
            int z = this.client.getPlane();
            for (int x = extent.x; x < extent.x + extent.width + 1; ++x) {
                for (int y = extent.y - extent.height; y < extent.y + 1; ++y) {
                    if (!map.isBlocked(x, y, z)) continue;
                    this.drawOnMap(graphics, new WorldPoint(x, y, z), false);
                }
            }
        }
        if (this.config.drawTransports()) {
            graphics.setColor(Color.WHITE);
            for (WorldPoint a : this.plugin.getTransports().keySet()) {
                Point mapA = this.worldMapOverlay.mapWorldPointToGraphicsPoint(a);
                if (mapA == null || !worldMapClipArea.contains(mapA.getX(), mapA.getY())) continue;
                for (Transport b : (List)this.plugin.getTransports().getOrDefault(a, new ArrayList())) {
                    Point mapB = this.worldMapOverlay.mapWorldPointToGraphicsPoint(b.getDestination());
                    if (mapB == null || !worldMapClipArea.contains(mapB.getX(), mapB.getY())) continue;
                    graphics.drawLine(mapA.getX(), mapA.getY(), mapB.getX(), mapB.getY());
                }
            }
        }
        if (this.plugin.getPathfinder() != null) {
            Color colour = this.plugin.getPathfinder().isDone() ? this.config.colourPath() : this.config.colourPathCalculating();
            List<WorldPoint> path = this.plugin.getPathfinder().getPath();
            for (int i = 0; i < path.size(); ++i) {
                WorldPoint last;
                graphics.setColor(colour);
                WorldPoint point = path.get(i);
                WorldPoint worldPoint = last = i > 0 ? path.get(i - 1) : point;
                if (point.distanceTo(last) > 1) {
                    this.drawOnMap(graphics, last, point, true);
                }
                this.drawOnMap(graphics, point, true);
            }
        }
        if ((pathfinderArray = this.plugin.panel.getPathfinderArray()) != null) {
            for (Pathfinder CurrentPathfinder : pathfinderArray) {
                Color colour = CurrentPathfinder.isDone() ? Color.RED : Color.CYAN;
                List<WorldPoint> path = CurrentPathfinder.getPath();
                for (int i = 0; i < path.size(); ++i) {
                    WorldPoint last;
                    graphics.setColor(colour);
                    WorldPoint point = path.get(i);
                    WorldPoint worldPoint = last = i > 0 ? path.get(i - 1) : point;
                    if (point.distanceTo(last) > 1) {
                        this.drawOnMap(graphics, last, point, true);
                    }
                    this.drawOnMap(graphics, point, true);
                }
            }
        }
        return null;
    }

    private void drawOnMap(Graphics2D graphics, WorldPoint point, boolean checkHover) {
        this.drawOnMap(graphics, point, point.dx(1).dy(-1), checkHover);
    }

    private void drawOnMap(Graphics2D graphics, WorldPoint point, WorldPoint offset, boolean checkHover) {
        Point start = this.plugin.mapWorldPointToGraphicsPoint(point);
        Point end = this.plugin.mapWorldPointToGraphicsPoint(offset);
        if (start == null || end == null) {
            return;
        }
        int x = start.getX();
        int y = start.getY();
        int width = end.getX() - x;
        int height = end.getY() - y;
        x -= width / 2;
        y -= height / 2;
        if (point.distanceTo(offset) > 1) {
            graphics.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{9.0f}, 0.0f));
            graphics.drawLine(start.getX(), start.getY(), end.getX(), end.getY());
        } else {
            Point cursorPos = this.client.getMouseCanvasPosition();
            if (checkHover && cursorPos.getX() >= x && cursorPos.getX() <= end.getX() - width / 2 && cursorPos.getY() >= y && cursorPos.getY() <= end.getY() - width / 2) {
                graphics.setColor(graphics.getColor().darker());
            }
            graphics.fillRect(x, y, width, height);
        }
    }

    private Area getWorldMapClipArea(Rectangle baseRectangle) {
        Widget overview = this.client.getWidget(WidgetInfo.WORLD_MAP_OVERVIEW_MAP);
        Widget surfaceSelector = this.client.getWidget(WidgetInfo.WORLD_MAP_SURFACE_SELECTOR);
        Area clipArea = new Area(baseRectangle);
        if (overview != null && !overview.isHidden()) {
            clipArea.subtract(new Area(overview.getBounds()));
        }
        if (surfaceSelector != null && !surfaceSelector.isHidden()) {
            clipArea.subtract(new Area(surfaceSelector.getBounds()));
        }
        return clipArea;
    }

    private Rectangle getWorldMapExtent(Rectangle baseRectangle) {
        WorldPoint topLeft = this.plugin.calculateMapPoint(new Point(baseRectangle.x, baseRectangle.y));
        WorldPoint bottomRight = this.plugin.calculateMapPoint(new Point(baseRectangle.x + baseRectangle.width, baseRectangle.y + baseRectangle.height));
        return new Rectangle(topLeft.getX(), topLeft.getY(), bottomRight.getX() - topLeft.getX(), topLeft.getY() - bottomRight.getY());
    }
}

