/*
 * Decompiled with CFR 0.152.
 */
package Posiedien_Leagues_Planner;

import Posiedien_Leagues_Planner.RegionType;
import Posiedien_Leagues_Planner.SortedTask;
import Posiedien_Leagues_Planner.TaskData;
import Posiedien_Leagues_Planner.TaskDifficulty;
import Posiedien_Leagues_Planner.TaskSortData;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.UUID;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.achievementdiary.CombatLevelRequirement;
import net.runelite.client.plugins.achievementdiary.Requirement;
import net.runelite.client.plugins.achievementdiary.SkillRequirement;

public class FullUserData {
    HashMap<UUID, TaskData> CustomTasks = new HashMap();
    HashMap<UUID, TaskSortData> PlannedTasks = new HashMap();
    HashSet<UUID> HiddenTasks = new HashSet();
    HashSet<UUID> CompletedTasks = new HashSet();
    ArrayList<SortedTask> SortedPlannedTasks = new ArrayList();

    void CacheSortedPlannedTasks() {
        this.SortedPlannedTasks.clear();
        for (Map.Entry<UUID, TaskSortData> mapElement : this.PlannedTasks.entrySet()) {
            this.SortedPlannedTasks.add(new SortedTask(mapElement.getKey(), mapElement.getValue().SortPriority, mapElement.getValue().bIsCustomTask));
        }
        this.SortedPlannedTasks.sort(new Comparator<SortedTask>(){

            @Override
            public int compare(SortedTask o1, SortedTask o2) {
                return o1.SortPriority.compareTo(o2.SortPriority);
            }
        });
        for (int i = 0; i < this.SortedPlannedTasks.size(); ++i) {
            this.PlannedTasks.get((Object)this.SortedPlannedTasks.get((int)i).TaskGUID).LastSortOrder = i + 1;
        }
    }

    public String GetNextIgnoreBlank(Scanner sc) {
        String NextString;
        do {
            if (sc.hasNext()) continue;
            return null;
        } while (Objects.equals(NextString = sc.next(), "") || Objects.equals(NextString, "\r\n"));
        NextString = NextString.replace("\r\n", "");
        return NextString;
    }

    public void importFrom(File targ) {
        if (targ.exists()) {
            try (Scanner sc = new Scanner(targ);){
                sc.useDelimiter(",");
                Integer CustomTaskSize = Integer.valueOf(this.GetNextIgnoreBlank(sc));
                for (int i = 0; i < CustomTaskSize; ++i) {
                    TaskData NewCustomTask = new TaskData();
                    NewCustomTask.TaskName = this.GetNextIgnoreBlank(sc);
                    NewCustomTask.Difficulty = TaskDifficulty.valueOf(this.GetNextIgnoreBlank(sc));
                    NewCustomTask.TaskDescription = this.GetNextIgnoreBlank(sc);
                    NewCustomTask.GUID = UUID.fromString(this.GetNextIgnoreBlank(sc));
                    NewCustomTask.bIsCustomTask = Boolean.valueOf(this.GetNextIgnoreBlank(sc));
                    NewCustomTask.CustomIcon = this.GetNextIgnoreBlank(sc);
                    Integer RegionSize = Integer.valueOf(this.GetNextIgnoreBlank(sc));
                    for (int j = 0; j < RegionSize; ++j) {
                        RegionType NewRegionType = RegionType.valueOf(this.GetNextIgnoreBlank(sc));
                        NewCustomTask.Regions.add(NewRegionType);
                    }
                    Integer OverworldLocationsSize = Integer.valueOf(this.GetNextIgnoreBlank(sc));
                    for (int j = 0; j < OverworldLocationsSize; ++j) {
                        int WorldPointX = Integer.parseInt(this.GetNextIgnoreBlank(sc));
                        int WorldPointY = Integer.parseInt(this.GetNextIgnoreBlank(sc));
                        int WorldPointZ = Integer.parseInt(this.GetNextIgnoreBlank(sc));
                        NewCustomTask.OverworldLocations.add(new WorldPoint(WorldPointX, WorldPointY, WorldPointZ));
                    }
                    Integer LocationsSize = Integer.valueOf(this.GetNextIgnoreBlank(sc));
                    for (int j = 0; j < LocationsSize; ++j) {
                        int WorldPointX = Integer.parseInt(this.GetNextIgnoreBlank(sc));
                        int WorldPointY = Integer.parseInt(this.GetNextIgnoreBlank(sc));
                        int WorldPointZ = Integer.parseInt(this.GetNextIgnoreBlank(sc));
                        NewCustomTask.Locations.add(new WorldPoint(WorldPointX, WorldPointY, WorldPointZ));
                    }
                    Integer RequirementSize = Integer.valueOf(this.GetNextIgnoreBlank(sc));
                    for (int j = 0; j < RequirementSize; ++j) {
                        String ReqType = this.GetNextIgnoreBlank(sc);
                        Integer SkillLevel = Integer.valueOf(this.GetNextIgnoreBlank(sc));
                        if (ReqType.contains("COMBAT")) {
                            CombatLevelRequirement CombatReq = new CombatLevelRequirement(SkillLevel.intValue());
                            NewCustomTask.Requirements.add((Requirement)CombatReq);
                            continue;
                        }
                        Skill SkillVal = Skill.valueOf((String)ReqType);
                        SkillRequirement SkillReq = new SkillRequirement(SkillVal, SkillLevel.intValue());
                        NewCustomTask.Requirements.add((Requirement)SkillReq);
                    }
                    this.CustomTasks.put(NewCustomTask.GUID, NewCustomTask);
                }
                Integer PlannedTaskSize = Integer.valueOf(this.GetNextIgnoreBlank(sc));
                for (int i = 0; i < PlannedTaskSize; ++i) {
                    UUID GUID = UUID.fromString(this.GetNextIgnoreBlank(sc));
                    Integer NewSortPriority = Integer.valueOf(this.GetNextIgnoreBlank(sc));
                    Integer NewLastSortOrder = Integer.valueOf(this.GetNextIgnoreBlank(sc));
                    Boolean bNewIsCustomTask = Boolean.valueOf(this.GetNextIgnoreBlank(sc));
                    TaskSortData NewSortData = new TaskSortData(NewSortPriority, bNewIsCustomTask);
                    NewSortData.LastSortOrder = NewLastSortOrder;
                    this.PlannedTasks.put(GUID, NewSortData);
                }
                Integer HiddenTaskSize = Integer.valueOf(this.GetNextIgnoreBlank(sc));
                for (int i = 0; i < HiddenTaskSize; ++i) {
                    UUID GUID = UUID.fromString(this.GetNextIgnoreBlank(sc));
                    this.HiddenTasks.add(GUID);
                }
                Integer CompletedTaskSize = Integer.valueOf(this.GetNextIgnoreBlank(sc));
                for (int i = 0; i < CompletedTaskSize; ++i) {
                    UUID GUID = UUID.fromString(this.GetNextIgnoreBlank(sc));
                    this.CompletedTasks.add(GUID);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void exportTo(File targ) {
        try (FileWriter fw = new FileWriter(targ);){
            StringBuilder Converted = new StringBuilder();
            Converted.append(this.CustomTasks.size());
            Converted.append(",");
            for (Map.Entry<UUID, TaskData> entry : this.CustomTasks.entrySet()) {
                Converted.append(entry.getValue().ExportUserDataFormat());
            }
            Converted.append(this.PlannedTasks.size());
            Converted.append(",");
            for (Map.Entry<UUID, Object> entry : this.PlannedTasks.entrySet()) {
                Converted.append(entry.getKey());
                Converted.append(",");
                Converted.append(((TaskSortData)entry.getValue()).ExportData());
            }
            Converted.append(this.HiddenTasks.size());
            Converted.append(",");
            for (UUID uUID : this.HiddenTasks) {
                Converted.append(uUID);
                Converted.append(",");
            }
            Converted.append(this.CompletedTasks.size());
            Converted.append(",");
            for (UUID uUID : this.CompletedTasks) {
                Converted.append(uUID);
                Converted.append(",");
            }
            fw.write(Converted.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

