/*
 * Decompiled with CFR 0.152.
 */
package Posiedien_Leagues_Planner;

import Posiedien_Leagues_Planner.PosiedienLeaguesPlannerPlugin;
import Posiedien_Leagues_Planner.RegionType;
import Posiedien_Leagues_Planner.SortedTask;
import Posiedien_Leagues_Planner.TaskData;
import Posiedien_Leagues_Planner.TaskDifficulty;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.UUID;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.achievementdiary.CombatLevelRequirement;
import net.runelite.client.plugins.achievementdiary.Requirement;
import net.runelite.client.plugins.achievementdiary.SkillRequirement;

public class FullTaskData {
    ArrayList<SortedTask> SortedLeaguesTaskList = new ArrayList();
    HashMap<UUID, TaskData> LeaguesTaskList = new HashMap();
    HashMap<String, UUID> StringToTask = new HashMap();

    void AddNewTaskToDataBase(TaskData newTask) {
        if (newTask.GUID == null) {
            newTask.GUID = UUID.randomUUID();
        }
        this.LeaguesTaskList.put(newTask.GUID, newTask);
        this.StringToTask.put(newTask.TaskName, newTask.GUID);
    }

    public void CalculateAndCacheOverworldLocations(PosiedienLeaguesPlannerPlugin posiedienLeaguesPlannerPlugin) {
        for (Map.Entry<UUID, TaskData> entry : this.LeaguesTaskList.entrySet()) {
            for (WorldPoint NextLocation : entry.getValue().Locations) {
                if (this.IsOverworldLocation(NextLocation)) continue;
                posiedienLeaguesPlannerPlugin.restartPathfinding(NextLocation, new WorldPoint(3000, 3000, 0), true);
                while (posiedienLeaguesPlannerPlugin.getPathfinder() == null || !posiedienLeaguesPlannerPlugin.getPathfinder().isDone() || posiedienLeaguesPlannerPlugin.bQueuedPathfinderTask) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {}
                }
                WorldPoint LastLocation = posiedienLeaguesPlannerPlugin.getPathfinder().getPath().get(posiedienLeaguesPlannerPlugin.getPathfinder().getPath().size() - 1);
                if (!this.IsOverworldLocation(LastLocation) || entry.getValue().OverworldLocations.contains(LastLocation)) continue;
                entry.getValue().OverworldLocations.add(LastLocation);
            }
        }
    }

    public boolean IsOverworldLocation(WorldPoint testPoint) {
        if (testPoint.getPlane() == 0 && testPoint.getX() > 1022 && testPoint.getX() < 3968) {
            return testPoint.getY() > 2494 && testPoint.getY() < 4160;
        }
        return false;
    }

    public String GetNextIgnoreBlank(Scanner sc) {
        String NextString;
        do {
            if (sc.hasNext()) continue;
            return null;
        } while (Objects.equals(NextString = sc.next(), "") || Objects.equals(NextString, "\r\n"));
        NextString = NextString.replace("\r\n", "");
        return NextString;
    }

    public void importFromConverted(File file) {
        if (file.exists()) {
            try (Scanner sc = new Scanner(file);){
                sc.useDelimiter(",");
                this.GetNextIgnoreBlank(sc);
                this.GetNextIgnoreBlank(sc);
                while (sc.hasNext()) {
                    String TaskName = this.GetNextIgnoreBlank(sc);
                    if (TaskName == null) {
                        break;
                    }
                    TaskData newTask = null;
                    boolean bIsNewTask = false;
                    if (this.StringToTask.containsKey(TaskName)) {
                        newTask = this.LeaguesTaskList.get(this.StringToTask.get(TaskName));
                    } else {
                        bIsNewTask = true;
                        newTask = new TaskData();
                    }
                    String DifficultyName = this.GetNextIgnoreBlank(sc);
                    newTask.TaskName = TaskName;
                    newTask.Difficulty = TaskDifficulty.valueOf(DifficultyName);
                    newTask.TaskDescription = this.GetNextIgnoreBlank(sc);
                    if (!bIsNewTask) {
                        this.GetNextIgnoreBlank(sc);
                    } else {
                        newTask.GUID = UUID.fromString(this.GetNextIgnoreBlank(sc));
                    }
                    newTask.bIsCustomTask = Boolean.valueOf(this.GetNextIgnoreBlank(sc));
                    newTask.CustomIcon = this.GetNextIgnoreBlank(sc);
                    if (newTask.CustomIcon.contains("null")) {
                        newTask.CustomIcon = null;
                    }
                    this.GetNextIgnoreBlank(sc);
                    int RegionCount = Integer.parseInt(this.GetNextIgnoreBlank(sc));
                    for (int i = 0; i < RegionCount; ++i) {
                        newTask.Regions.add(RegionType.valueOf(this.GetNextIgnoreBlank(sc)));
                    }
                    this.GetNextIgnoreBlank(sc);
                    int OverworldPointCount = Integer.parseInt(this.GetNextIgnoreBlank(sc));
                    for (int i = 0; i < OverworldPointCount; ++i) {
                        WorldPoint newWorldPoint = new WorldPoint(Integer.parseInt(this.GetNextIgnoreBlank(sc)), Integer.parseInt(this.GetNextIgnoreBlank(sc)), Integer.parseInt(this.GetNextIgnoreBlank(sc)));
                        if (newTask.OverworldLocations.contains(newWorldPoint)) continue;
                        newTask.OverworldLocations.add(newWorldPoint);
                    }
                    this.GetNextIgnoreBlank(sc);
                    this.GetNextIgnoreBlank(sc);
                    this.GetNextIgnoreBlank(sc);
                    this.GetNextIgnoreBlank(sc);
                    this.GetNextIgnoreBlank(sc);
                    int IterationNum = 0;
                    int CurrentX = 0;
                    int CurrentY = 0;
                    int CurrentZ = 0;
                    String NextString = this.GetNextIgnoreBlank(sc);
                    while (!NextString.contains("POSITIONS_END")) {
                        switch (IterationNum) {
                            case 0: {
                                CurrentX = Integer.parseInt(NextString);
                                break;
                            }
                            case 1: {
                                CurrentY = Integer.parseInt(NextString);
                                break;
                            }
                            case 2: {
                                CurrentZ = Integer.parseInt(NextString);
                            }
                        }
                        NextString = this.GetNextIgnoreBlank(sc);
                        if (++IterationNum <= 2) continue;
                        IterationNum = 0;
                        WorldPoint newWorldPoint = new WorldPoint(CurrentX, CurrentY, CurrentZ);
                        if (newTask.Locations.contains(newWorldPoint)) continue;
                        newTask.Locations.add(newWorldPoint);
                    }
                    this.GetNextIgnoreBlank(sc);
                    this.GetNextIgnoreBlank(sc);
                    this.GetNextIgnoreBlank(sc);
                    NextString = this.GetNextIgnoreBlank(sc);
                    IterationNum = 0;
                    String CurrentSkill = null;
                    int SkillReqLevel = 0;
                    while (!NextString.contains("REQUIREMENTS_END")) {
                        switch (IterationNum) {
                            case 0: {
                                CurrentSkill = NextString;
                                break;
                            }
                            case 1: {
                                SkillReqLevel = Integer.parseInt(NextString);
                            }
                        }
                        NextString = this.GetNextIgnoreBlank(sc);
                        if (++IterationNum <= 1) continue;
                        IterationNum = 0;
                        if (CurrentSkill.contains("COMBAT")) {
                            newTask.Requirements.add((Requirement)new CombatLevelRequirement(SkillReqLevel));
                            continue;
                        }
                        Skill AddedSkill = Skill.valueOf((String)CurrentSkill);
                        newTask.Requirements.add((Requirement)new SkillRequirement(AddedSkill, SkillReqLevel));
                    }
                    if (!bIsNewTask) continue;
                    this.AddNewTaskToDataBase(newTask);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.StringToTask.clear();
        for (Map.Entry<UUID, TaskData> entry : this.LeaguesTaskList.entrySet()) {
            this.StringToTask.put(entry.getValue().TaskName, entry.getKey());
        }
    }

    public String ExportData(PosiedienLeaguesPlannerPlugin plugin) {
        StringBuilder Converted = new StringBuilder();
        Converted.append("Task Count: ,");
        Converted.append(this.LeaguesTaskList.size());
        Converted.append(",");
        Converted.append("\r\n");
        this.SortedLeaguesTaskList.clear();
        plugin.panel.AddTaskListToSortedLeaguesTasks(null, this.LeaguesTaskList);
        this.SortedLeaguesTaskList.sort(new Comparator<SortedTask>(){

            @Override
            public int compare(SortedTask o1, SortedTask o2) {
                return o1.SortPriority.compareTo(o2.SortPriority);
            }
        });
        for (SortedTask SortedTaskIter : this.SortedLeaguesTaskList) {
            TaskData data = plugin.GetTaskData(SortedTaskIter.TaskGUID, SortedTaskIter.bIsCustomTask);
            Converted.append(data.ExportData());
            Converted.append(",");
            Converted.append("\r\n");
        }
        return Converted.toString();
    }

    public void exportToConverted(File file, PosiedienLeaguesPlannerPlugin plugin) throws IOException {
        try (FileWriter fw = new FileWriter(file);){
            fw.write(this.ExportData(plugin));
        }
    }

    public void importFromRaw() {
        HashSet<UUID> TaskGUIDSet = new HashSet<UUID>();
        for (RegionType CurrentRegion : RegionType.values()) {
            File file = new File("RawWikiTaskData/" + CurrentRegion.toString() + ".txt");
            if (!file.exists()) continue;
            try (Scanner sc = new Scanner(file);){
                TaskDifficulty CurrentDifficulty = null;
                sc.useDelimiter("\n");
                while (sc.hasNext()) {
                    while (CurrentDifficulty == null && sc.hasNext()) {
                        String NextString = sc.next();
                        if (!NextString.contains("===")) continue;
                        NextString = NextString.replaceAll("===", "");
                        NextString = NextString.replaceAll("\r", "");
                        NextString = NextString.toUpperCase();
                        CurrentDifficulty = TaskDifficulty.valueOf(NextString);
                    }
                    TaskData newTask = null;
                    while (CurrentDifficulty != null && newTask == null && sc.hasNext()) {
                        String NextString = sc.next();
                        if (NextString.contains("LeagueTaskRow")) {
                            NextString = NextString.replaceAll("\\{\\{LeagueTaskRow\\|", "");
                            NextString = NextString.replaceAll("\\{\\{sic}}", "");
                            while (NextString.contains("[[")) {
                                int EndSubstring;
                                int StartSubstring = NextString.indexOf("[[");
                                String OriginalSubString = NextString.substring(StartSubstring, (EndSubstring = NextString.indexOf("]]")) + 2);
                                EndSubstring = OriginalSubString.contains("|") ? OriginalSubString.indexOf("|") : OriginalSubString.length();
                                String ModifiedSubString = OriginalSubString.substring(2, EndSubstring - 2);
                                NextString = NextString.replace(OriginalSubString, ModifiedSubString);
                            }
                            String TaskName = NextString.substring(0, NextString.indexOf("|"));
                            NextString = NextString.substring(NextString.indexOf("|") + 1);
                            TaskName = TaskName.replace(",", "");
                            boolean bIsNewTask = false;
                            if (this.StringToTask.containsKey(TaskName)) {
                                newTask = this.LeaguesTaskList.get(this.StringToTask.get(TaskName));
                            } else {
                                bIsNewTask = true;
                                newTask = new TaskData();
                            }
                            newTask.Difficulty = CurrentDifficulty;
                            if (bIsNewTask) {
                                newTask.TaskName = TaskName;
                                newTask.TaskDescription = NextString.substring(0, NextString.indexOf("|"));
                                newTask.TaskDescription = newTask.TaskDescription.replace(",", "");
                            }
                            NextString = NextString.substring(NextString.indexOf("|") + 1);
                            String SkillRequirementString = "";
                            if (NextString.contains("|")) {
                                SkillRequirementString = NextString.substring(0, NextString.indexOf("|"));
                                NextString = NextString.substring(NextString.indexOf("|") + 1);
                            }
                            while (SkillRequirementString.contains("{{") && NextString.contains("|")) {
                                SkillRequirementString = NextString.substring(0, NextString.indexOf("|"));
                                if (!(NextString = NextString.substring(NextString.indexOf("|") + 1)).contains("|")) break;
                                String SkillName = SkillRequirementString.toUpperCase();
                                try {
                                    Skill.valueOf((String)SkillName);
                                }
                                catch (IllegalArgumentException ignored) {
                                    break;
                                }
                                SkillRequirementString = NextString.substring(0, NextString.indexOf("|"));
                                NextString = NextString.substring(NextString.indexOf("|") + 1);
                                if (SkillRequirementString.contains("}}")) {
                                    SkillRequirementString = SkillRequirementString.replace("}}", "");
                                }
                                if (SkillRequirementString.contains(",")) {
                                    SkillRequirementString = SkillRequirementString.substring(0, SkillRequirementString.indexOf(","));
                                }
                                int SkillRequirementLevel = Integer.parseInt(SkillRequirementString);
                                if (SkillName.equals("COMBAT")) {
                                    CombatLevelRequirement newCombatReq = new CombatLevelRequirement(SkillRequirementLevel);
                                    newTask.Requirements.add((Requirement)newCombatReq);
                                } else {
                                    Skill ConvertedSkill = Skill.valueOf((String)SkillName);
                                    SkillRequirement newSkillReq = new SkillRequirement(ConvertedSkill, SkillRequirementLevel);
                                    newTask.Requirements.add((Requirement)newSkillReq);
                                }
                                if (!NextString.contains("|")) break;
                                SkillRequirementString = NextString.substring(0, NextString.indexOf("|"));
                                if (SkillRequirementString.contains("link")) {
                                    NextString = NextString.substring(NextString.indexOf("|") + 1);
                                }
                                if (!NextString.contains("|")) break;
                                SkillRequirementString = NextString.substring(0, NextString.indexOf("|"));
                                if (!SkillRequirementString.contains("sort")) continue;
                                NextString = NextString.substring(NextString.indexOf("|") + 1);
                            }
                            newTask.Regions.clear();
                            if (CurrentRegion != RegionType.GENERAL) {
                                newTask.Regions.add(CurrentRegion);
                            }
                            if (bIsNewTask) {
                                this.AddNewTaskToDataBase(newTask);
                            }
                            TaskGUIDSet.add(newTask.GUID);
                            continue;
                        }
                        if (!NextString.contains("LeagueTaskBottom")) continue;
                        CurrentDifficulty = null;
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        HashSet<UUID> TasksToRemove = new HashSet<UUID>();
        for (Map.Entry<UUID, TaskData> SearchingTask : this.LeaguesTaskList.entrySet()) {
            if (TaskGUIDSet.contains(SearchingTask.getKey())) continue;
            TasksToRemove.add(SearchingTask.getKey());
        }
        for (UUID SearchingTask : TasksToRemove) {
            this.LeaguesTaskList.remove(SearchingTask);
        }
        this.StringToTask.clear();
        for (Map.Entry<UUID, TaskData> entry : this.LeaguesTaskList.entrySet()) {
            this.StringToTask.put(entry.getValue().TaskName, entry.getKey());
        }
    }
}

