/*
 * Decompiled with CFR 0.152.
 */
package Posiedien_Leagues_Planner;

import Posiedien_Leagues_Planner.LeagueRegionBounds;
import Posiedien_Leagues_Planner.LeagueRegionPoint;
import Posiedien_Leagues_Planner.LeaguesPlannerConfig;
import Posiedien_Leagues_Planner.RegionType;
import Posiedien_Leagues_Planner.WorldPointPolygon;
import java.awt.Polygon;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;
import net.runelite.api.coords.WorldPoint;

public class FullRegionData {
    public ArrayList<LeagueRegionBounds> RegionData = new ArrayList();

    public boolean IsTileInUnlockedRegion(LeaguesPlannerConfig config, WorldPoint TileLocation) {
        ArrayList<RegionType> RegionsForTile = this.GetTileRegions(TileLocation);
        if (!RegionsForTile.isEmpty()) {
            for (RegionType regionType : RegionsForTile) {
                if (!RegionType.GetRegionUnlocked(config, regionType)) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public ArrayList<RegionType> GetTileRegions(WorldPoint TileLocation) {
        ArrayList<RegionType> OutRegions = new ArrayList<RegionType>();
        block0: for (LeagueRegionBounds regionDatum : this.RegionData) {
            ArrayList<WorldPointPolygon> RegionPolygons = regionDatum.RegionPolygons;
            for (WorldPointPolygon regionPolygon : RegionPolygons) {
                Polygon WorldPoly = regionPolygon.WorldPoly;
                int WorldPolyZ = regionPolygon.WorldPolyZ;
                if (WorldPolyZ != TileLocation.getPlane() || !WorldPoly.contains(TileLocation.getX(), TileLocation.getY())) continue;
                OutRegions.add(regionDatum.Type);
                continue block0;
            }
        }
        return OutRegions;
    }

    public void exportTo(File file) throws IOException {
        try (FileWriter fw = new FileWriter(file);){
            fw.write(this.ExportData());
        }
    }

    private void FixupAfterImport() {
        for (LeagueRegionBounds Region2 : this.RegionData) {
            for (Map.Entry<UUID, LeagueRegionPoint> entry : Region2.RegionPoints.entrySet()) {
                entry.getValue().ConnectedPoints.clear();
                for (UUID ConnectedGUID : entry.getValue().ConnectedPointGUIDs) {
                    entry.getValue().ConnectedPoints.add(Region2.RegionPoints.get(ConnectedGUID));
                }
            }
        }
    }

    public void importFrom(File file) {
        try (Scanner sc = new Scanner(file);){
            sc.useDelimiter(",");
            this.ImportData(sc);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.FixupAfterImport();
    }

    public String ExportData() {
        StringBuilder Converted = new StringBuilder();
        Converted.append(this.RegionData.size());
        Converted.append(",");
        for (LeagueRegionBounds Region2 : this.RegionData) {
            Converted.append(Region2.ExportData());
        }
        return Converted.toString();
    }

    public void ImportData(Scanner sc) {
        this.RegionData.clear();
        int RegionSize = Integer.parseInt(sc.next());
        for (int i = 0; i < RegionSize; ++i) {
            LeagueRegionBounds NewRegionBounds = new LeagueRegionBounds();
            NewRegionBounds.ImportData(sc);
            this.RegionData.add(NewRegionBounds);
        }
    }
}

