/*
 * Decompiled with CFR 0.152.
 */
package com.ba.call.highlight;

import com.ba.call.highlight.baCallHighlightConfig;
import com.google.inject.Provides;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="BA Call Highlight", description="Highlights the correct call option in barbarian assault", tags={"overlay", "b.a.", "barbarian assault", "minigame", "attacker", "defender", "collector", "healer", "plugin hub"})
public class baCallHighlightPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(baCallHighlightPlugin.class);
    @Inject
    private Client client;
    @Inject
    private baCallHighlightConfig config;
    private final Map<String, String> callToMenuEntry = new HashMap<String, String>();
    private Role role;

    protected void startUp() throws Exception {
        this.callToMenuEntry.put("Red egg", "Tell-red");
        this.callToMenuEntry.put("Green egg", "Tell-green");
        this.callToMenuEntry.put("Blue egg", "Tell-blue");
        this.callToMenuEntry.put("Controlled/Bullet/Wind", "Tell-controlled");
        this.callToMenuEntry.put("Accurate/Field/Water", "Tell-accurate");
        this.callToMenuEntry.put("Aggressive/Blunt/Earth", "Tell-aggressive");
        this.callToMenuEntry.put("Defensive/Barbed/Fire", "Tell-defensive");
        this.callToMenuEntry.put("Tofu", "Tell-tofu");
        this.callToMenuEntry.put("Crackers", "Tell-crackers");
        this.callToMenuEntry.put("Worms", "Tell-worms");
        this.callToMenuEntry.put("Pois. Tofu", "Tell-tofu");
        this.callToMenuEntry.put("Pois. Worms", "Tell-worms");
        this.callToMenuEntry.put("Pois. Meat", "Tell-meat");
    }

    @Provides
    baCallHighlightConfig provideConfig(ConfigManager configManager) {
        return (baCallHighlightConfig)configManager.getConfig(baCallHighlightConfig.class);
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        int groupId = event.getGroupId();
        if (groupId == Role.COLLECTOR.groupID) {
            this.role = Role.COLLECTOR;
        } else if (groupId == Role.HEALER.groupID) {
            this.role = Role.HEALER;
        } else if (groupId == Role.ATTACKER.groupID) {
            this.role = Role.ATTACKER;
        } else if (groupId == Role.DEFENDER.groupID) {
            this.role = Role.DEFENDER;
        }
    }

    @Subscribe
    public void onClientTick(ClientTick clientTick) {
        if (this.role == null) {
            return;
        }
        Widget activeWidget = this.client.getWidget(this.role.groupID, this.role.childID);
        if (activeWidget == null) {
            return;
        }
        for (MenuEntry entry : this.client.getMenuEntries()) {
            if (Text.removeTags((String)entry.getOption()).equals(this.callToMenuEntry.get(activeWidget.getText()))) {
                entry.setOption(ColorUtil.prependColorTag((String)Text.removeTags((String)entry.getOption()), (Color)this.config.highlightCallColor()));
                continue;
            }
            entry.setOption(Text.removeTags((String)entry.getOption()));
        }
    }

    private static enum Role {
        COLLECTOR(486, 9),
        HEALER(488, 9),
        ATTACKER(485, 10),
        DEFENDER(487, 9);

        public final int groupID;
        public final int childID;

        private Role(int groupID, int childID) {
            this.groupID = groupID;
            this.childID = childID;
        }
    }
}

