/*
 * Decompiled with CFR 0.152.
 */
package com.oneclick.pathfinder;

import com.oneclick.pathfinder.CollisionMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.runelite.api.coords.WorldPoint;

public class Pathfinder {
    public final CollisionMap map;
    public final Map<WorldPoint, List<WorldPoint>> transports;

    public Pathfinder(CollisionMap map, Map<WorldPoint, List<WorldPoint>> transports) {
        this.map = map;
        this.transports = transports;
    }

    private static class Node {
        public final WorldPoint position;
        public final Node previous;

        public Node(WorldPoint position, Node previous) {
            this.position = position;
            this.previous = previous;
        }

        public Set<WorldPoint> path() {
            HashSet<WorldPoint> path = new HashSet<WorldPoint>();
            Node node = this;
            while (node != null) {
                path.add(node.position);
                node = node.previous;
            }
            return path;
        }
    }

    public class Path {
        private final Node start;
        private final WorldPoint target;
        private final List<Node> boundary = new LinkedList<Node>();
        private final Set<WorldPoint> visited = new HashSet<WorldPoint>();
        public Node nearest;
        private Set<WorldPoint> path = new HashSet<WorldPoint>();
        public boolean loading;

        public Path(WorldPoint start, WorldPoint target) {
            this.target = target;
            this.start = new Node(start, null);
            this.nearest = null;
            this.loading = true;
            this.calculate();
        }

        private void addNeighbors(Node node) {
            if (Pathfinder.this.map.w(node.position.getX(), node.position.getY(), node.position.getPlane())) {
                this.addNeighbor(node, new WorldPoint(node.position.getX() - 1, node.position.getY(), node.position.getPlane()));
            }
            if (Pathfinder.this.map.e(node.position.getX(), node.position.getY(), node.position.getPlane())) {
                this.addNeighbor(node, new WorldPoint(node.position.getX() + 1, node.position.getY(), node.position.getPlane()));
            }
            if (Pathfinder.this.map.s(node.position.getX(), node.position.getY(), node.position.getPlane())) {
                this.addNeighbor(node, new WorldPoint(node.position.getX(), node.position.getY() - 1, node.position.getPlane()));
            }
            if (Pathfinder.this.map.n(node.position.getX(), node.position.getY(), node.position.getPlane())) {
                this.addNeighbor(node, new WorldPoint(node.position.getX(), node.position.getY() + 1, node.position.getPlane()));
            }
            if (Pathfinder.this.map.sw(node.position.getX(), node.position.getY(), node.position.getPlane())) {
                this.addNeighbor(node, new WorldPoint(node.position.getX() - 1, node.position.getY() - 1, node.position.getPlane()));
            }
            if (Pathfinder.this.map.se(node.position.getX(), node.position.getY(), node.position.getPlane())) {
                this.addNeighbor(node, new WorldPoint(node.position.getX() + 1, node.position.getY() - 1, node.position.getPlane()));
            }
            if (Pathfinder.this.map.nw(node.position.getX(), node.position.getY(), node.position.getPlane())) {
                this.addNeighbor(node, new WorldPoint(node.position.getX() - 1, node.position.getY() + 1, node.position.getPlane()));
            }
            if (Pathfinder.this.map.ne(node.position.getX(), node.position.getY(), node.position.getPlane())) {
                this.addNeighbor(node, new WorldPoint(node.position.getX() + 1, node.position.getY() + 1, node.position.getPlane()));
            }
            for (WorldPoint transport : (List)Pathfinder.this.transports.getOrDefault(node.position, new ArrayList())) {
                this.addNeighbor(node, transport);
            }
        }

        public Set<WorldPoint> currentBest() {
            return this.nearest == null ? null : this.nearest.path();
        }

        public Set<WorldPoint> getPath() {
            return this.path;
        }

        public WorldPoint getStart() {
            return this.start.position;
        }

        public WorldPoint getTarget() {
            return this.target;
        }

        private void addNeighbor(Node node, WorldPoint neighbor) {
            if (!this.visited.add(neighbor)) {
                return;
            }
            this.boundary.add(new Node(neighbor, node));
        }

        public void calculate() {
            this.boundary.add(this.start);
            int bestDistance = Integer.MAX_VALUE;
            while (!this.boundary.isEmpty()) {
                Node node = this.boundary.remove(0);
                if (node.position.equals((Object)this.target)) {
                    this.path = node.path();
                    this.loading = false;
                    return;
                }
                int distance = node.position.distanceTo(this.target);
                if (this.nearest == null || distance < bestDistance) {
                    this.nearest = node;
                    bestDistance = distance;
                }
                this.addNeighbors(node);
            }
            if (this.nearest != null) {
                this.path = this.nearest.path();
            }
            this.loading = false;
        }
    }
}

