/*
 * Decompiled with CFR 0.152.
 */
package com.oneclick;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Provides;
import com.oneclick.OneClickConfig;
import com.oneclick.OneClickOverlay;
import com.oneclick.TilemanModeTile;
import com.oneclick.Util;
import com.oneclick.pathfinder.CollisionMap;
import com.oneclick.pathfinder.Pathfinder;
import com.oneclick.pathfinder.SplitFlagMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="One Click Tiles", description="Highlight one-click-able tiles in Tileman Mode", tags={"overlay", "tiles", "tileman"})
public class OneClickPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(OneClickPlugin.class);
    private static final String CONFIG_GROUP = "tilemanMode";
    private static final String REGION_PREFIX = "region_";
    private static final Gson GSON = new Gson();
    public static final int MAX_DRAW_DISTANCE = 32;
    @Inject
    private Client client;
    @Inject
    private OneClickConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private OneClickOverlay overlay;
    private final List<WorldPoint> points = new ArrayList<WorldPoint>();
    public final Set<WorldPoint> oneClickTiles = new HashSet<WorldPoint>();
    private Pathfinder pathfinder;
    private LocalPoint lastTile;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        HashMap<SplitFlagMap.Position, byte[]> compressedRegions = new HashMap<SplitFlagMap.Position, byte[]>();
        HashMap<WorldPoint, List<WorldPoint>> transports = new HashMap<WorldPoint, List<WorldPoint>>();
        try (ZipInputStream in = new ZipInputStream(OneClickPlugin.class.getResourceAsStream("/collision-map.zip"));){
            ZipEntry entry;
            while ((entry = in.getNextEntry()) != null) {
                String[] n = entry.getName().split("_");
                compressedRegions.put(new SplitFlagMap.Position(Integer.parseInt(n[0]), Integer.parseInt(n[1])), Util.readAllBytes(in));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try {
            String s = new String(Util.readAllBytes(OneClickPlugin.class.getResourceAsStream("/transports.txt")), StandardCharsets.UTF_8);
            Scanner scanner = new Scanner(s);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line.startsWith("#") || line.isEmpty()) continue;
                String[] l = line.split(" ");
                WorldPoint a = new WorldPoint(Integer.parseInt(l[0]), Integer.parseInt(l[1]), Integer.parseInt(l[2]));
                WorldPoint b = new WorldPoint(Integer.parseInt(l[3]), Integer.parseInt(l[4]), Integer.parseInt(l[5]));
                transports.computeIfAbsent(a, k -> new ArrayList()).add(b);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        CollisionMap map = new CollisionMap(64, compressedRegions);
        this.pathfinder = new Pathfinder(map, transports);
        this.loadPoints();
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.points.clear();
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        LocalPoint currentPos = LocalPoint.fromWorld((Client)this.client, (WorldPoint)this.client.getLocalPlayer().getWorldLocation());
        if (!currentPos.equals((Object)this.lastTile)) {
            this.updateOneClickTiles();
            this.lastTile = currentPos;
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.loadPoints();
            this.updateOneClickTiles();
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (!configChanged.getGroup().equals(CONFIG_GROUP)) {
            return;
        }
        this.loadPoints();
        this.updateOneClickTiles();
    }

    private void loadPoints() {
        this.points.clear();
        int[] regions = this.client.getMapRegions();
        if (regions == null) {
            return;
        }
        for (int regionId : regions) {
            Collection<WorldPoint> worldPoint = this.translateToWorldPoint(this.getTiles(regionId));
            this.points.addAll(worldPoint);
        }
    }

    private Collection<TilemanModeTile> getConfiguration(String configGroup, String key) {
        String json = this.configManager.getConfiguration(configGroup, key);
        if (Strings.isNullOrEmpty((String)json)) {
            return Collections.emptyList();
        }
        return (Collection)GSON.fromJson(json, new TypeToken<List<TilemanModeTile>>(){}.getType());
    }

    Collection<TilemanModeTile> getTiles(int regionId) {
        return this.getConfiguration(CONFIG_GROUP, REGION_PREFIX + regionId);
    }

    private Collection<WorldPoint> translateToWorldPoint(Collection<TilemanModeTile> points) {
        if (points.isEmpty()) {
            return Collections.emptyList();
        }
        return points.stream().map(point -> WorldPoint.fromRegion((int)point.getRegionId(), (int)point.getRegionX(), (int)point.getRegionY(), (int)point.getZ())).flatMap(worldPoint -> {
            Collection localWorldPoints = WorldPoint.toLocalInstance((Client)this.client, (WorldPoint)worldPoint);
            return localWorldPoints.stream();
        }).collect(Collectors.toList());
    }

    private void updateOneClickTiles() {
        WorldPoint playerLocation = this.client.getLocalPlayer().getWorldLocation();
        if (playerLocation == null) {
            return;
        }
        if (this.points.isEmpty()) {
            return;
        }
        HashSet<WorldPoint> localPoints = new HashSet<WorldPoint>();
        for (WorldPoint point : this.points) {
            if (point.distanceTo(playerLocation) >= 32) continue;
            localPoints.add(point);
        }
        this.oneClickTiles.clear();
        for (WorldPoint localPoint : localPoints) {
            Pathfinder pathfinder = this.pathfinder;
            Objects.requireNonNull(pathfinder);
            Pathfinder.Path path = new Pathfinder.Path(pathfinder, playerLocation, localPoint);
            if (!localPoints.containsAll(path.getPath())) continue;
            this.oneClickTiles.add(localPoint);
        }
    }

    @Provides
    OneClickConfig provideConfig(ConfigManager configManager) {
        return (OneClickConfig)configManager.getConfig(OneClickConfig.class);
    }
}

