/*
 * Decompiled with CFR 0.152.
 */
package com.oneclick;

import com.oneclick.OneClickConfig;
import com.oneclick.OneClickPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneClickOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(OneClickOverlay.class);
    private final Client client;
    private final OneClickPlugin plugin;
    @Inject
    private OneClickConfig config;

    @Inject
    private OneClickOverlay(Client client, OneClickConfig config, OneClickPlugin plugin) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.MED);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        for (WorldPoint point : this.plugin.oneClickTiles) {
            if (point.getPlane() != this.client.getPlane()) continue;
            this.drawTile(graphics, point);
        }
        return null;
    }

    private void drawTile(Graphics2D graphics, WorldPoint point) {
        WorldPoint playerLocation = this.client.getLocalPlayer().getWorldLocation();
        if (point.distanceTo(playerLocation) >= 32) {
            return;
        }
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)point);
        if (lp == null) {
            return;
        }
        Polygon poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)lp);
        if (poly == null) {
            return;
        }
        if (this.config.drawBorders()) {
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)this.config.borderColor());
        }
        if (this.config.drawFill()) {
            graphics.setColor(this.config.fillColor());
            graphics.fill(poly);
        }
    }
}

