/*
 * Decompiled with CFR 0.152.
 */
package com.cosmetics;

import com.cosmetics.CosmeticsCache;
import com.cosmetics.CosmeticsConfig;
import com.cosmetics.CosmeticsPlayer;
import com.google.inject.Provides;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.PlayerComposition;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.PlayerChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Cosmetics", description="Allows users to customize their appearance", tags={"cosmetics", "players"})
public class CosmeticsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CosmeticsPlugin.class);
    public static String CHAT_COMMAND = "!cosmetics";
    private final int FREQUENCY = 3;
    @Inject
    private Client client;
    @Inject
    private CosmeticsConfig config;
    private boolean isPvp = false;
    private boolean wasPvp = false;
    private boolean enabled = false;
    private final CosmeticsCache cache = new CosmeticsCache();
    private final HashMap<String, int[]> preTransform = new HashMap();
    private final HashMap<String, int[]> postTransform = new HashMap();
    private int timer = 0;

    @Provides
    CosmeticsConfig getConfig(ConfigManager configManager) {
        return (CosmeticsConfig)configManager.getConfig(CosmeticsConfig.class);
    }

    protected void startUp() {
        this.enabled = true;
        this.process();
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (this.enabled && event.getMessage().toLowerCase().startsWith(CHAT_COMMAND) && !this.config.apiKey().isEmpty()) {
            for (Player p : this.client.getPlayers()) {
                if (p.getName() == null || !p.getName().equals(event.getName())) continue;
                this.wipe(p.getName(), p.getPlayerComposition().getEquipmentIds());
                this.cache.save(new CosmeticsPlayer(p), this.config.apiKey());
                break;
            }
        }
    }

    protected void shutDown() {
        this.enabled = false;
        this.process();
    }

    @Subscribe
    public void onGameTick(GameTick gt) {
        ++this.timer;
        if (this.isPvp == this.wasPvp && this.timer < 3 || !this.enabled) {
            return;
        }
        this.timer = 0;
        this.process();
        this.cache.clear();
    }

    private void wipe(String name, int[] equipmentIds) {
        if (this.postTransform.containsKey(name) && !Arrays.equals(this.postTransform.get(name), equipmentIds)) {
            this.preTransform.put(name, (int[])equipmentIds.clone());
        }
        int[] newIds = this.preTransform.get(name);
        System.arraycopy(newIds, 0, equipmentIds, 0, newIds.length);
    }

    private void process() {
        try {
            ArrayList<String> allNames = new ArrayList<String>();
            for (Player player : this.client.getPlayers()) {
                allNames.add(player.getName());
                PlayerComposition comp = player.getPlayerComposition();
                int[] equipmentIds = comp.getEquipmentIds();
                String name = player.getName();
                if (!this.preTransform.containsKey(name)) {
                    this.preTransform.put(name, (int[])equipmentIds.clone());
                }
                if (this.isPvp || !this.enabled) {
                    this.wipe(name, equipmentIds);
                } else {
                    CosmeticsPlayer p;
                    if (this.postTransform.containsKey(name) && !Arrays.equals(this.postTransform.get(name), equipmentIds)) {
                        this.preTransform.put(name, (int[])equipmentIds.clone());
                    }
                    if ((p = this.cache.getCosmetics(player.getName())) != null) {
                        p.write(equipmentIds);
                    }
                    this.postTransform.put(name, (int[])equipmentIds.clone());
                }
                comp.setHash();
            }
            this.cache.fillCache(allNames.toArray(new String[0]));
        }
        catch (Exception e) {
            log.debug("Sad: " + e.toString());
            e.printStackTrace();
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        this.wasPvp = this.isPvp;
        this.isPvp = this.client.getVar(8121) != 0;
    }

    @Subscribe
    public void onPlayerChanged(PlayerChanged event) {
        this.timer = 3;
    }
}

