/*
 * Decompiled with CFR 0.152.
 */
package com.cosmetics;

import com.cosmetics.CosmeticsData;
import com.cosmetics.CosmeticsPlayer;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosmeticsCache {
    private static final Logger log = LoggerFactory.getLogger(CosmeticsCache.class);
    private static final String DATABASE_URL = "https://billiardssketch.fun/cosmetics/";
    private static final int TIME_TO_LIVE = 300000;
    private final HashMap<String, CosmeticsData> cache = new HashMap();
    private final OkHttpClient httpClient = new OkHttpClient();

    public void clear() {
        this.cache.clear();
    }

    public CosmeticsPlayer getCosmetics(String username) {
        if (this.isValid(username)) {
            return this.cache.get(username).getPlayer();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(CosmeticsPlayer p, String apiKey) {
        HashMap<String, CosmeticsData> hashMap = this.cache;
        synchronized (hashMap) {
            this.cache.put(p.name, new CosmeticsData(System.currentTimeMillis(), p));
        }
        this.httpClient.newCall(this.buildRequestSave(p, apiKey)).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
            }

            public void onResponse(Call call, Response response) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillCache(String[] names) {
        String[] filtered = (String[])Arrays.stream(names).filter(x -> !this.isValid((String)x)).toArray(String[]::new);
        if (filtered.length == 0) {
            return;
        }
        HashMap<String, CosmeticsData> hashMap = this.cache;
        synchronized (hashMap) {
            long time = System.currentTimeMillis();
            for (String s : filtered) {
                CosmeticsData cd = this.cache.get(s);
                if (cd != null) {
                    cd.setFetchedTime(time);
                    continue;
                }
                this.cache.put(s, new CosmeticsData(time, null));
            }
        }
        this.httpClient.newCall(this.buildRequestFetch(filtered)).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) throws IOException {
                HashMap<String, CosmeticsData> hashMap = CosmeticsCache.this.cache;
                synchronized (hashMap) {
                    Gson gson = new Gson();
                    long time = System.currentTimeMillis();
                    List data = (List)gson.fromJson(response.body().string(), new TypeToken<List<CosmeticsPlayer>>(){}.getType());
                    for (CosmeticsPlayer p : data) {
                        CosmeticsCache.this.cache.put(p.name, new CosmeticsData(time, p));
                    }
                }
            }
        });
    }

    public boolean isValid(String username) {
        return this.cache.containsKey(username) && this.cache.get(username).getFetchedTime() + 300000L > System.currentTimeMillis();
    }

    public Request buildRequestFetch(String[] names) {
        HttpUrl url = null;
        try {
            url = HttpUrl.get((URL)new URL(DATABASE_URL)).newBuilder().addPathSegment(String.join((CharSequence)",", names)).build();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return new Request.Builder().url(url).build();
    }

    public Request buildRequestSave(CosmeticsPlayer p, String apiKey) {
        HttpUrl url = null;
        try {
            url = HttpUrl.get((URL)new URL(DATABASE_URL)).newBuilder().addPathSegment(apiKey).build();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
        Gson gson = new Gson();
        String s = gson.toJson((Object)p);
        RequestBody body = RequestBody.create((MediaType)JSON, (String)s);
        log.debug("{}", (Object)s);
        return new Request.Builder().url(url).put(body).build();
    }
}

