/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.CustomHotkeyListener;
import com.example.WorldCycleConfig;
import com.example.WorldCyclePanel;
import com.example.WorldCycleUpdate;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.World;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.WorldService;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.party.PartyMember;
import net.runelite.client.party.PartyService;
import net.runelite.client.party.WSClient;
import net.runelite.client.party.messages.PartyMessage;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.ClientUI;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import net.runelite.client.util.WorldUtil;
import net.runelite.http.api.worlds.WorldResult;
import net.runelite.http.api.worlds.WorldType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="World Cycle", description="Lighter, custom version of world hopper used to hop between a set of worlds circularly", tags={"switcher", "cycle", "world hopper"})
public class WorldCyclePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(WorldCyclePlugin.class);
    private static final int MAX_PLAYER_COUNT = 1950;
    private static final int DISPLAY_SWITCHER_MAX_ATTEMPTS = 3;
    @Inject
    private Client client;
    @Inject
    private ClientUI clientUI;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private KeyManager keyManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private WorldCycleConfig config;
    @Inject
    private WorldService worldService;
    @Inject
    private WSClient wsClient;
    @Inject
    private PartyService partyService;
    private NavigationButton navButton_cycle;
    public WorldCyclePanel panel_cycle;
    private World quickHopTargetWorld;
    private int displaySwitcherAttempts = 0;
    private boolean lastFocusStatus = false;
    private final CustomHotkeyListener previousKeyListener = new CustomHotkeyListener(() -> this.config.previousKey()){

        @Override
        public void hotkeyPressed() {
            WorldCyclePlugin.this.clientThread.invoke(() -> WorldCyclePlugin.this.hop(true));
        }
    };
    private final CustomHotkeyListener nextKeyListener = new CustomHotkeyListener(() -> this.config.nextKey()){

        @Override
        public void hotkeyPressed() {
            WorldCyclePlugin.this.clientThread.invoke(() -> WorldCyclePlugin.this.hop(false));
        }
    };

    @Provides
    WorldCycleConfig getConfig(ConfigManager configManager) {
        return (WorldCycleConfig)configManager.getConfig(WorldCycleConfig.class);
    }

    protected void startUp() throws Exception {
        this.wsClient.registerMessage(WorldCycleUpdate.class);
        this.keyManager.registerKeyListener((KeyListener)this.previousKeyListener);
        this.keyManager.registerKeyListener((KeyListener)this.nextKeyListener);
        this.panel_cycle = new WorldCyclePanel(this.client, this.configManager, this);
        BufferedImage icon_cycle = ImageUtil.getResourceStreamFromClass(((Object)((Object)this)).getClass(), (String)"icon_cycle.png");
        this.navButton_cycle = NavigationButton.builder().tooltip("World Cycle").icon(icon_cycle).priority(1).panel((PluginPanel)this.panel_cycle).build();
        this.clientToolbar.addNavigation(this.navButton_cycle);
    }

    protected void shutDown() throws Exception {
        this.wsClient.unregisterMessage(WorldCycleUpdate.class);
        this.keyManager.unregisterKeyListener((KeyListener)this.previousKeyListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.nextKeyListener);
        this.clientToolbar.removeNavigation(this.navButton_cycle);
    }

    private void hop(boolean previous) {
        net.runelite.http.api.worlds.World world;
        WorldResult worldResult = this.worldService.getWorlds();
        if (worldResult == null || this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        net.runelite.http.api.worlds.World currentWorld = worldResult.findWorld(this.client.getWorld());
        if (currentWorld == null) {
            return;
        }
        Object currentWorldTypes = currentWorld.getTypes().clone();
        ((AbstractCollection)currentWorldTypes).remove(WorldType.PVP);
        ((AbstractCollection)currentWorldTypes).remove(WorldType.HIGH_RISK);
        ((AbstractCollection)currentWorldTypes).remove(WorldType.BOUNTY);
        ((AbstractCollection)currentWorldTypes).remove(WorldType.SKILL_TOTAL);
        ((AbstractCollection)currentWorldTypes).remove(WorldType.LAST_MAN_STANDING);
        List customWorldCycle = this.getCustomWorldCycle();
        boolean cyclePresent = !customWorldCycle.isEmpty();
        List worlds = cyclePresent ? customWorldCycle : worldResult.getWorlds();
        int attemptedWorlds = 0;
        if (cyclePresent) {
            ((AbstractCollection)currentWorldTypes).remove(WorldType.MEMBERS);
        }
        int worldIdx = worlds.indexOf(currentWorld);
        int totalLevel = this.client.getTotalLevel();
        do {
            if (previous) {
                if (--worldIdx < 0) {
                    worldIdx = worlds.size() - 1;
                }
            } else if (++worldIdx >= worlds.size()) {
                worldIdx = 0;
            }
            world = (net.runelite.http.api.worlds.World)worlds.get(worldIdx);
            Object types = world.getTypes().clone();
            ((AbstractCollection)types).remove(WorldType.BOUNTY);
            ((AbstractCollection)types).remove(WorldType.LAST_MAN_STANDING);
            if (cyclePresent) {
                ((AbstractCollection)types).remove(WorldType.MEMBERS);
            }
            if (((AbstractCollection)types).contains(WorldType.SKILL_TOTAL)) {
                try {
                    int totalRequirement = Integer.parseInt(world.getActivity().substring(0, world.getActivity().indexOf(" ")));
                    if (totalLevel >= totalRequirement) {
                        ((AbstractCollection)types).remove(WorldType.SKILL_TOTAL);
                    }
                }
                catch (NumberFormatException ex) {
                    log.warn("Failed to parse total level requirement for target world", (Throwable)ex);
                }
            }
            if (world.getPlayers() >= 1950) {
                if (++attemptedWorlds != worlds.size()) continue;
                world = currentWorld;
                break;
            }
            if (((AbstractSet)currentWorldTypes).equals(types)) break;
            if (++attemptedWorlds != worlds.size()) continue;
            world = currentWorld;
            break;
        } while (world != currentWorld);
        if (world == currentWorld) {
            String chatMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Couldn't find a world to quick-hop to.").build();
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessage).build());
        } else {
            this.hop(world.getId());
        }
    }

    private void hop(int worldId) {
        assert (this.client.isClientThread());
        WorldResult worldResult = this.worldService.getWorlds();
        net.runelite.http.api.worlds.World world = worldResult.findWorld(worldId);
        if (world == null) {
            return;
        }
        World rsWorld = this.client.createWorld();
        rsWorld.setActivity(world.getActivity());
        rsWorld.setAddress(world.getAddress());
        rsWorld.setId(world.getId());
        rsWorld.setPlayerCount(world.getPlayers());
        rsWorld.setLocation(world.getLocation());
        rsWorld.setTypes(WorldUtil.toWorldTypes((EnumSet)world.getTypes()));
        if (this.client.getGameState() == GameState.LOGIN_SCREEN) {
            this.client.changeWorld(rsWorld);
            return;
        }
        if (this.config.showWorldHopMessage()) {
            String chatMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Quick-hopping to World ").append(ChatColorType.HIGHLIGHT).append(Integer.toString(world.getId())).append(ChatColorType.NORMAL).append("..").build();
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessage).build());
        }
        this.quickHopTargetWorld = rsWorld;
        this.displaySwitcherAttempts = 0;
    }

    @Subscribe
    public void onClientTick(ClientTick event) {
        if (this.lastFocusStatus != this.clientUI.isFocused() && !this.clientUI.isFocused()) {
            if (this.nextKeyListener.isPressed()) {
                this.nextKeyListener.ReleaseHotkey();
            }
            if (this.previousKeyListener.isPressed()) {
                this.previousKeyListener.ReleaseHotkey();
            }
        }
        this.lastFocusStatus = this.clientUI.isFocused();
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.quickHopTargetWorld == null) {
            return;
        }
        if (this.client.getWidget(WidgetInfo.WORLD_SWITCHER_LIST) == null) {
            this.client.openWorldHopper();
            if (++this.displaySwitcherAttempts >= 3) {
                String chatMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Failed to quick-hop after ").append(ChatColorType.HIGHLIGHT).append(Integer.toString(this.displaySwitcherAttempts)).append(ChatColorType.NORMAL).append(" attempts.").build();
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessage).build());
                this.resetQuickHopper();
            }
        } else {
            this.client.hopToWorld(this.quickHopTargetWorld);
            this.resetQuickHopper();
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        if (event.getMessage().equals("Please finish what you're doing before using the World Switcher.")) {
            this.resetQuickHopper();
        }
    }

    private void resetQuickHopper() {
        this.displaySwitcherAttempts = 0;
        this.quickHopTargetWorld = null;
    }

    public void ChangeWorldSet(String worldset, boolean fromServer) {
        if (!fromServer && this.LocalMemberIsValid()) {
            this.partyService.send((PartyMessage)new WorldCycleUpdate(worldset));
        }
        if (!fromServer || this.config.acceptPartyCycle()) {
            this.panel_cycle.pendingRequest = true;
            this.panel_cycle.uiInput.setWorldSetInput(worldset);
        }
    }

    public boolean LocalMemberIsValid() {
        PartyMember localMember = this.partyService.getLocalMember();
        return localMember != null;
    }

    @Subscribe
    public void onWorldCycleUpdate(WorldCycleUpdate message) {
        if (this.partyService.getLocalMember().getMemberId() == message.getMemberId()) {
            return;
        }
        if (this.LocalMemberIsValid()) {
            this.ChangeWorldSet(message.getWorldSet(), true);
        }
    }

    net.runelite.http.api.worlds.World ValidateWorld(int worldNum) {
        WorldResult worldResult = this.worldService.getWorlds();
        if (worldResult == null) {
            return null;
        }
        net.runelite.http.api.worlds.World world = worldResult.findWorld(worldNum);
        if (world == null) {
            return null;
        }
        Object currentWorldTypes = world.getTypes().clone();
        if (((AbstractCollection)currentWorldTypes).contains(WorldType.PVP) || ((AbstractCollection)currentWorldTypes).contains(WorldType.HIGH_RISK)) {
            return null;
        }
        return world;
    }

    List<net.runelite.http.api.worlds.World> getCustomWorldCycle() {
        ArrayList<net.runelite.http.api.worlds.World> worldCycleList = new ArrayList<net.runelite.http.api.worlds.World>();
        String worldList = this.GetWorldSet();
        if (worldList.isEmpty()) {
            return worldCycleList;
        }
        WorldResult worldResult = this.worldService.getWorlds();
        if (worldResult == null) {
            return worldCycleList;
        }
        Text.fromCSV((String)worldList).stream().mapToInt(s -> {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }).filter(world -> this.ValidateWorld(world) != null).forEach(world -> worldCycleList.add(worldResult.findWorld(world)));
        return worldCycleList;
    }

    public String GetWorldSet() {
        return this.panel_cycle.uiInput.getWorldSetInput();
    }
}

