/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.UICycleInputArea;
import com.example.WorldCyclePlugin;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.runelite.api.Client;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.materialtabs.MaterialTabGroup;

public class WorldCyclePanel
extends PluginPanel {
    private final MaterialTabGroup tabGroup;
    final UICycleInputArea uiInput = new UICycleInputArea();
    private Timer configUpdateTimer;
    private Timer worldSetChangeTimer;
    ConfigManager configManager;
    WorldCyclePlugin plugin;
    public boolean pendingRequest = false;

    WorldCyclePanel(Client client, ConfigManager configManager, WorldCyclePlugin plugin) {
        this.configManager = configManager;
        this.plugin = plugin;
        this.getScrollPane().setVerticalScrollBarPolicy(22);
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.tabGroup = new MaterialTabGroup();
        this.tabGroup.setLayout((LayoutManager)new GridLayout(0, 6, 7, 7));
        this.uiInput.setBorder(new EmptyBorder(15, 0, 15, 0));
        this.uiInput.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.SetFromConfig();
        this.uiInput.getUiFieldWorldSet().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!WorldCyclePanel.this.pendingRequest) {
                    WorldCyclePanel.this.RequestChangeWorldSet();
                }
                WorldCyclePanel.this.RequestConfigUpdate();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (WorldCyclePanel.this.pendingRequest) {
                    WorldCyclePanel.this.pendingRequest = false;
                } else {
                    WorldCyclePanel.this.RequestChangeWorldSet();
                }
                WorldCyclePanel.this.RequestConfigUpdate();
            }
        });
        this.add((Component)this.tabGroup, c);
        ++c.gridy;
        this.add(this.uiInput, c);
        ++c.gridy;
    }

    private void RequestChangeWorldSet() {
        if (this.worldSetChangeTimer != null) {
            this.worldSetChangeTimer.restart();
            return;
        }
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WorldCyclePanel.this.ChangeWorldSet();
            }
        };
        this.worldSetChangeTimer = new Timer(600, actionListener);
        this.worldSetChangeTimer.setRepeats(false);
        this.worldSetChangeTimer.start();
    }

    public void ChangeWorldSet() {
        this.plugin.ChangeWorldSet(this.uiInput.getWorldSetInput(), false);
    }

    private void RequestConfigUpdate() {
        if (this.configUpdateTimer != null) {
            this.configUpdateTimer.restart();
            return;
        }
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WorldCyclePanel.this.UpdateConfig();
            }
        };
        this.configUpdateTimer = new Timer(2000, actionListener);
        this.configUpdateTimer.setRepeats(false);
        this.configUpdateTimer.start();
    }

    private void UpdateConfig() {
        if (this.uiInput.getWorldSetInput().isEmpty()) {
            this.configManager.unsetConfiguration("worldcycle", "worldset");
        } else {
            this.configManager.setConfiguration("worldcycle", "worldset", this.uiInput.getWorldSetInput());
        }
        this.configUpdateTimer = null;
    }

    public void SetFromConfig() {
        if (this.configManager == null) {
            return;
        }
        String worldSet = this.configManager.getConfiguration("worldcycle", "worldset");
        if (worldSet != null) {
            this.uiInput.setWorldSetInput(this.configManager.getConfiguration("worldcycle", "worldset"));
        }
    }
}

