/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import java.awt.event.KeyEvent;
import java.util.function.Supplier;
import net.runelite.client.config.Keybind;
import net.runelite.client.input.KeyListener;

public abstract class CustomHotkeyListener
implements KeyListener {
    private final Supplier<Keybind> keybind;
    private boolean isPressed = false;
    private boolean isConsumingTyped = false;
    private boolean enabledOnLoginScreen;

    public boolean isEnabledOnLoginScreen() {
        return this.enabledOnLoginScreen;
    }

    public void keyTyped(KeyEvent e) {
        if (this.isConsumingTyped) {
            e.consume();
        }
    }

    public void keyPressed(KeyEvent e) {
        if (this.keybind.get().matches(e)) {
            boolean wasPressed = this.isPressed;
            this.isPressed = true;
            if (!wasPressed) {
                this.hotkeyPressed();
            }
            if (Keybind.getModifierForKeyCode((int)e.getKeyCode()) == null) {
                this.isConsumingTyped = true;
                e.consume();
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        if (this.keybind.get().matches(e)) {
            this.ReleaseHotkey();
        }
    }

    public void ReleaseHotkey() {
        this.isPressed = false;
        this.isConsumingTyped = false;
        this.hotkeyReleased();
    }

    public void hotkeyPressed() {
    }

    public void hotkeyReleased() {
    }

    public CustomHotkeyListener(Supplier<Keybind> keybind) {
        this.keybind = keybind;
    }

    boolean isPressed() {
        return this.isPressed;
    }

    public void setEnabledOnLoginScreen(boolean enabledOnLoginScreen) {
        this.enabledOnLoginScreen = enabledOnLoginScreen;
    }
}

