/*
 * Decompiled with CFR 0.152.
 */
package moe.cuteanimegirls.discorddeathnotifications;

import com.google.common.base.Strings;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import moe.cuteanimegirls.discorddeathnotifications.DeathNotificationsConfig;
import moe.cuteanimegirls.discorddeathnotifications.DiscordWebhookBody;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.events.ActorDeath;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.DrawManager;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Discord Death Notifications")
public class DeathNotificationsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DeathNotificationsPlugin.class);
    @Inject
    private Client client;
    @Inject
    private DeathNotificationsConfig config;
    @Inject
    private OkHttpClient okHttpClient;
    @Inject
    private DrawManager drawManager;

    @Provides
    DeathNotificationsConfig provideConfig(ConfigManager configManager) {
        return (DeathNotificationsConfig)configManager.getConfig(DeathNotificationsConfig.class);
    }

    @Subscribe
    public void onActorDeath(ActorDeath actorDeath) {
        Player player;
        Actor actor = actorDeath.getActor();
        if (actor instanceof Player && (player = (Player)actor) == this.client.getLocalPlayer()) {
            this.sendMessage();
        }
    }

    private void sendMessage() {
        String playerName = this.client.getLocalPlayer().getName();
        String deathString = this.config.includeName() ? String.format("%s %s", playerName, this.config.deathMessage()) : this.config.deathMessage();
        DiscordWebhookBody discordWebhookBody = new DiscordWebhookBody();
        discordWebhookBody.setContent(deathString);
        this.sendWebhook(discordWebhookBody);
    }

    private void sendWebhook(DiscordWebhookBody discordWebhookBody) {
        String configUrl = this.config.webhook();
        if (Strings.isNullOrEmpty((String)configUrl)) {
            return;
        }
        HttpUrl url = HttpUrl.parse((String)configUrl);
        MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("payload_json", RuneLiteAPI.GSON.toJson((Object)discordWebhookBody));
        this.sendWebhookWithScreenshot(url, requestBodyBuilder);
    }

    private void sendWebhookWithScreenshot(HttpUrl url, MultipartBody.Builder requestBodyBuilder) {
        this.drawManager.requestNextFrameListener(image -> {
            byte[] imageBytes;
            BufferedImage bufferedImage = (BufferedImage)image;
            try {
                imageBytes = DeathNotificationsPlugin.convertImageToByteArray(bufferedImage);
            }
            catch (IOException e) {
                log.warn("Error converting image to byte array", (Throwable)e);
                return;
            }
            requestBodyBuilder.addFormDataPart("file", "image.png", RequestBody.create((MediaType)MediaType.parse((String)"image/png"), (byte[])imageBytes));
            this.buildRequestAndSend(url, requestBodyBuilder);
        });
    }

    private void buildRequestAndSend(HttpUrl url, MultipartBody.Builder requestBodyBuilder) {
        MultipartBody requestBody = requestBodyBuilder.build();
        Request request = new Request.Builder().url(url).post((RequestBody)requestBody).build();
        this.sendRequest(request);
    }

    private void sendRequest(Request request) {
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.debug("Error submitting webhook", (Throwable)e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                response.close();
            }
        });
    }

    private static byte[] convertImageToByteArray(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }
}

