/*
 * Decompiled with CFR 0.152.
 */
package dekvall.fullscreen;

import java.awt.Frame;
import java.awt.GraphicsDevice;
import javax.inject.Inject;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.RuneLiteConfig;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientUI;
import net.runelite.client.ui.ContainableFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Fullscreen", description="Requires custom chrome being off.", enabledByDefault=false)
public class FullscreenPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(FullscreenPlugin.class);
    @Inject
    private ClientUI clientUI;
    @Inject
    private ConfigManager configManager;
    private GraphicsDevice gd;

    protected void startUp() throws Exception {
        Frame[] frames;
        log.info("Fullscreen started!");
        this.gd = this.clientUI.getGraphicsConfiguration().getDevice();
        Frame tempParent = Frame.getFrames()[0];
        if (((RuneLiteConfig)this.configManager.getConfig(RuneLiteConfig.class)).enableCustomChrome()) {
            log.info("You must disable custom chrome to enable fullscreen");
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(tempParent, "You must disable custom chrome to enable fullscreen", "Could not enter fullscreen mode", 0));
            return;
        }
        if (!this.gd.isFullScreenSupported()) {
            log.info("Fullscreen is not supported on your device, sorry :(");
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(tempParent, "Fullscreen is not supported on your device, sorry :(", "Could not enter fullscreen mode", 0));
            return;
        }
        for (Frame frame : frames = Frame.getFrames()) {
            if (!(frame instanceof ContainableFrame)) continue;
            this.gd.setFullScreenWindow(frame);
            return;
        }
    }

    protected void shutDown() throws Exception {
        this.gd.setFullScreenWindow(null);
        log.info("Fullscreen stopped!");
    }
}

