/*
 * Decompiled with CFR 0.152.
 */
package com.stackvalue;

import com.google.inject.Provides;
import com.stackvalue.StackValueConfig;
import com.stackvalue.StackValueOverlay;
import java.awt.Color;
import javax.inject.Inject;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Stack Value")
public class StackValuePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(StackValuePlugin.class);
    @Inject
    private StackValueConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private StackValueOverlay overlay;

    protected void startUp() throws Exception {
        log.info("ItemRarity started!");
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        log.info("ItemRarity stopped!");
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Provides
    StackValueConfig provideConfig(ConfigManager configManager) {
        return (StackValueConfig)configManager.getConfig(StackValueConfig.class);
    }

    Color getRarityColor(int itemPrice) {
        if (itemPrice < this.config.getCommonItemValue()) {
            return this.config.getCommonItemColor();
        }
        if (itemPrice < this.config.getUncommonItemValue()) {
            return this.config.getUncommonItemColor();
        }
        if (itemPrice < this.config.getRareItemValue()) {
            return this.config.getRareItemColor();
        }
        if (itemPrice < this.config.getEpicItemValue()) {
            return this.config.getEpicItemColor();
        }
        return this.config.getLegendaryItemColor();
    }
}

