/*
 * Decompiled with CFR 0.152.
 */
package com.stackvalue;

import com.google.inject.Inject;
import com.stackvalue.StackValuePlugin;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import net.runelite.api.ItemComposition;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackValueOverlay
extends WidgetItemOverlay {
    private static final Logger log = LoggerFactory.getLogger(StackValueOverlay.class);
    private static final int INVENTORY_SIZE = 28;
    private final StackValuePlugin plugin;
    private final ItemManager itemManager;

    @Inject
    private StackValueOverlay(StackValuePlugin plugin, ItemManager itemManager) {
        this.plugin = plugin;
        this.itemManager = itemManager;
        this.showOnEquipment();
        this.showOnInventory();
        this.showOnBank();
    }

    private int itemPrice(int itemId) {
        ItemComposition itemDef = this.itemManager.getItemComposition(itemId);
        int gePrice = this.itemManager.getItemPrice(itemId);
        int storePrice = itemDef.getPrice();
        int haPrice = itemDef.getHaPrice();
        int maxPrice = Integer.max(gePrice, haPrice);
        return gePrice;
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem itemWidget) {
        int price = this.itemPrice(itemId);
        Color color = this.plugin.getRarityColor(price *= itemWidget.getQuantity());
        if (color == null || color.getAlpha() == 0) {
            return;
        }
        Rectangle bounds = itemWidget.getCanvasBounds();
        BufferedImage outline = this.itemManager.getItemOutline(itemId, itemWidget.getQuantity(), color);
        graphics.drawImage((Image)outline, (int)bounds.getX(), (int)bounds.getY(), null);
    }
}

