/*
 * Decompiled with CFR 0.152.
 */
package com.dateOverlay;

import com.dateOverlay.DateOverlayConfig;
import com.dateOverlay.DateOverlayOverlay;
import com.google.inject.Provides;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.task.Schedule;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Date Overlay")
public class DateOverlayPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DateOverlayPlugin.class);
    public String currentDateTime;
    @Inject
    private Client client;
    @Inject
    private DateOverlayConfig config;
    @Inject
    private DateOverlayOverlay overlay;
    @Inject
    private OverlayManager overlayManager;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
    }

    @Schedule(period=1L, unit=ChronoUnit.SECONDS)
    public void timeSchedule() {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            String dateFormat = this.getDateFormat();
            LocalDateTime localDateTime = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateFormat);
            this.currentDateTime = localDateTime.format(formatter);
        }
    }

    public String getDateFormat() {
        Object dateformat = "dd-MM-yyyy";
        switch (this.config.dateTimeFormat()) {
            case yyyyMMdd: {
                dateformat = "yyyy-MM-dd";
                break;
            }
            case MMddyyyy: {
                dateformat = "MM-dd-yyyy";
            }
        }
        if (this.config.nameOfMonth()) {
            dateformat = ((String)dateformat).replace("MM", "MMMM");
        }
        if (this.config.shortYear()) {
            dateformat = ((String)dateformat).replace("yyyy", "yy");
        }
        if (this.config.showTime()) {
            dateformat = (String)dateformat + " HH:mm:ss";
        }
        return dateformat;
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Provides
    DateOverlayConfig provideConfig(ConfigManager configManager) {
        return (DateOverlayConfig)configManager.getConfig(DateOverlayConfig.class);
    }
}

