/*
 * Decompiled with CFR 0.152.
 */
package com.dateOverlay;

import com.dateOverlay.DateOverlayConfig;
import com.dateOverlay.DateOverlayPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class DateOverlayOverlay
extends Overlay {
    private final DateOverlayConfig config;
    private final PanelComponent panelComponent = new PanelComponent();
    private final DateOverlayPlugin dateOverlayPlugin;

    @Inject
    public DateOverlayOverlay(DateOverlayConfig config, DateOverlayPlugin dateOverlayPlugin) {
        this.setPosition(OverlayPosition.TOP_CENTER);
        this.config = config;
        this.dateOverlayPlugin = dateOverlayPlugin;
    }

    public Dimension render(Graphics2D graphics) {
        this.panelComponent.getChildren().clear();
        this.panelComponent.getChildren().add(TitleComponent.builder().text(this.dateOverlayPlugin.currentDateTime).color(Color.white).build());
        Dimension dim = new Dimension();
        float charMultiplier = this.dateOverlayPlugin.currentDateTime.length() > 10 ? 7.5f : 9.0f;
        dim.setSize((float)this.dateOverlayPlugin.currentDateTime.length() * charMultiplier, 2.0);
        this.panelComponent.setPreferredSize(dim);
        return this.panelComponent.render(graphics);
    }
}

