/*
 * Decompiled with CFR 0.152.
 */
package com.pohstorage;

import com.google.inject.Provides;
import com.pohstorage.PohSprites;
import com.pohstorage.PohStorageConfig;
import com.pohstorage.PohStorageSet;
import com.pohstorage.PohStorageWidget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.WidgetClosed;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.game.SpriteOverride;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="POH Storage", description="Filter and configure POH Storage", tags={"poh", "storage", "filter"})
public class PohStoragePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PohStoragePlugin.class);
    private boolean showEmpty = true;
    private boolean showPartial = true;
    private boolean showFull = true;
    private int originalScroll;
    private Widget emptyCheck;
    private Widget partialCheck;
    private Widget fullCheck;
    private Widget emptyTitle;
    private Widget partialTitle;
    private Widget fullTitle;
    private List<PohStorageSet> storageSets = new ArrayList<PohStorageSet>();
    private List<PohStorageWidget> junkWidgets = new ArrayList<PohStorageWidget>();
    private List<Widget> addedDividers = new ArrayList<Widget>();
    private PohSprites[] spriteDefinitions;
    private final String CONFIG_GROUP = "pohstorage";
    private final String CONTROL_ACTION = "Toggle";
    private final String TITLE_REGEX = "[\\(|:]";
    private final List<String> TITLES = Arrays.asList("Armour Case", "Cape Rack", "Toy Box", "Fancy Dress Box", "Treasure Chest", "Magic Wardrobe");
    private final int CONTAINER_HEIGHT_ADJUSTMENT = 25;
    private final int CONTROL_LABEL_COLOR = 0xCFCFCF;
    private final int CONTROL_Y = 42;
    private final int CONTROL_TITLE_WIDTH = 37;
    private final int CONTROL_TITLE_HEIGHT = 15;
    private final int CONTROL_CHECKBOX_WIDTH = 16;
    private final int CONTROL_CHECKBOX_HEIGHT = 16;
    private final int CONTROL_SPACING = 175;
    private final int WIDGET_DIVIDER_WIDTH = 16;
    private final int WIDGET_ICON_WIDTH = 36;
    private final int WIDGET_ICON_TOP_OFFSET = 20;
    private final int WIDGET_SET_WIDTH = 210;
    private final int WIDGET_SET_HEIGHT = 60;
    private final int WIDGET_OFFSET = 3;
    private final int MAX_HALF_SET = 4;
    private final int SET_TYPE_EMPTY = 0;
    private final int SET_TYPE_PARTIAL = 1;
    private final int SET_TYPE_FULL = 2;
    private final int STORAGE_GROUP_ID = 675;
    private final int STORAGE_CONTAINER = 1;
    private final int STORAGE_TITLE_CONTAINER = 2;
    private final int STORAGE_CONTENT_CONTAINER = 3;
    private final int STORAGE_ITEM_CONTAINER = 4;
    private final int STORAGE_SCROLLBAR = 5;
    private final int STORAGE_RIGHT_CONTAINER = 6;
    private final int STORAGE_TIERS_BUTTON = 7;
    private final int STORAGE_DEPOSIT_MODE_BUTTON = 8;
    private final int STORAGE_SEARCH_BUTTON = 9;
    private final int STORAGE_DEPOSIT_INVENTORY_BUTTON = 10;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private PohStorageConfig config;
    @Inject
    private SpriteManager spriteManager;

    protected void startUp() throws Exception {
        log.debug("POH Storage Started!");
        this.spriteManager.addSpriteOverrides((SpriteOverride[])PohSprites.values());
        this.loadConfig();
        if (this.pohStorageLoaded()) {
            this.clientThread.invokeLater(() -> {
                if (this.titleCheck()) {
                    this.originalScroll = this.client.getWidget(675, 4).getScrollHeight();
                    this.applyChanges();
                    this.updateWidgetHeight(25);
                    this.addControls();
                }
            });
        }
    }

    protected void shutDown() throws Exception {
        log.debug("POH Storage Stopped!");
        if (this.pohStorageLoaded()) {
            this.clientThread.invokeLater(() -> {
                if (this.titleCheck()) {
                    this.resetWidgets();
                    this.removeControls();
                    this.updateWidgetHeight(-25);
                    this.emptyCheck = null;
                    this.partialCheck = null;
                    this.fullCheck = null;
                    this.emptyTitle = null;
                    this.partialTitle = null;
                    this.fullTitle = null;
                }
            });
        }
        this.spriteManager.removeSpriteOverrides((SpriteOverride[])PohSprites.values());
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded e) {
        if (e.getGroupId() == 675 && this.pohStorageLoaded()) {
            this.clientThread.invokeLater(() -> {
                if (this.titleCheck()) {
                    this.originalScroll = this.client.getWidget(675, 4).getScrollHeight();
                    this.applyChanges();
                    this.updateWidgetHeight(25);
                    this.addControls();
                }
            });
        }
    }

    @Subscribe
    public void onWidgetClosed(WidgetClosed e) {
        if (e.getGroupId() == 675 && this.pohStorageLoaded()) {
            this.emptyCheck = null;
            this.partialCheck = null;
            this.fullCheck = null;
            this.emptyTitle = null;
            this.partialTitle = null;
            this.fullTitle = null;
            if (this.config.preserveFilters() == PohStorageConfig.preserveFilters.NEVER) {
                this.showEmpty = true;
                this.showPartial = true;
                this.showFull = true;
            }
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (this.pohStorageLoaded() && event.getContainerId() == InventoryID.INVENTORY.getId()) {
            this.clientThread.invokeLater(() -> {
                if (this.titleCheck()) {
                    this.applyChanges();
                }
            });
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (this.pohStorageLoaded() && configChanged.getGroup().equals("pohstorage") && !configChanged.getKey().equals("showEmptySets") && !configChanged.getKey().equals("showPartialSets") && !configChanged.getKey().equals("showFullSets")) {
            this.clientThread.invokeLater(() -> {
                if (this.titleCheck()) {
                    this.applyChanges();
                }
            });
        } else if (configChanged.getGroup().equals("pohstorage") && configChanged.getKey().equals("preserveFilters") && configChanged.getNewValue().equals("Never")) {
            this.showEmpty = true;
            this.showPartial = true;
            this.showFull = true;
        }
    }

    @Provides
    PohStorageConfig provideConfig(ConfigManager configManager) {
        return (PohStorageConfig)configManager.getConfig(PohStorageConfig.class);
    }

    public void loadConfig() {
        if (this.config.preserveFilters() == PohStorageConfig.preserveFilters.ACROSS_SESSIONS) {
            this.showEmpty = this.config.showEmptySets();
            this.showPartial = this.config.showPartialSets();
            this.showFull = this.config.showFullSets();
        }
    }

    public void applyChanges() {
        this.resetWidgets();
        this.updateWidgetLists();
        this.adjustWidgets();
    }

    private boolean pohStorageLoaded() {
        return this.client.getWidget(675, 2) != null && this.client.getWidget(675, 4) != null;
    }

    private boolean titleCheck() {
        return this.TITLES.contains(this.client.getWidget(675, 2).getDynamicChildren()[1].getText().split("[\\(|:]")[0].trim());
    }

    private void updateWidgetHeight(int adjustment) {
        Widget contentContainer = this.client.getWidget(675, 3);
        contentContainer.setOriginalHeight(contentContainer.getOriginalHeight() + adjustment);
        contentContainer.revalidate();
        this.client.getWidget(675, 4).revalidate();
        Widget scrollbar = this.client.getWidget(675, 5);
        scrollbar.revalidate();
        for (Widget scrollChild : scrollbar.getDynamicChildren()) {
            scrollChild.revalidate();
        }
    }

    private void resetWidgets() {
        for (PohStorageSet storageSet : this.storageSets) {
            for (PohStorageWidget storageWidget : storageSet.getAll()) {
                storageWidget.getWidget().setOriginalX(storageWidget.getOriginalX());
                storageWidget.getWidget().setOriginalY(storageWidget.getOriginalY());
                storageWidget.getWidget().setHidden(storageWidget.isOriginalHidden());
                if (!storageWidget.isIcon()) {
                    storageWidget.getWidget().setOpacity(storageWidget.getOriginalOpacity());
                    storageWidget.getWidget().setSpriteId(storageWidget.getOriginalSpriteId());
                    storageWidget.getWidget().setOriginalWidth(storageWidget.getOriginalWidth());
                    storageWidget.getWidget().setWidthMode(storageWidget.getOriginalWidthMode());
                    storageWidget.getWidget().setXPositionMode(storageWidget.getOriginalXPositionMode());
                }
                storageWidget.getWidget().revalidate();
            }
        }
        for (PohStorageWidget junk : this.junkWidgets) {
            junk.getWidget().setOriginalX(junk.getOriginalX());
            junk.getWidget().revalidate();
        }
        for (Widget addedDivider : this.addedDividers) {
            addedDivider.setHidden(true);
            addedDivider.revalidate();
        }
        Widget container = this.client.getWidget(675, 4);
        container.setScrollHeight(this.originalScroll);
        container.revalidateScroll();
        this.client.runScript(new Object[]{72, 44236805, 44236804, container.getScrollY()});
    }

    private void updateWidgetLists() {
        this.storageSets = new ArrayList<PohStorageSet>();
        this.junkWidgets = new ArrayList<PohStorageWidget>();
        this.addedDividers = new ArrayList<Widget>();
        for (Widget widgetItem : this.client.getWidget(675, 4).getDynamicChildren()) {
            if (widgetItem.getType() == 4) {
                this.storageSets.add(this.newPohStorageSet(widgetItem));
                continue;
            }
            if (widgetItem.getWidth() != 16) continue;
            this.junkWidgets.add(this.newPohStorageWidget(widgetItem));
            widgetItem.setOriginalX(-100);
            widgetItem.revalidate();
        }
    }

    private void addControls() {
        if (this.emptyTitle == null || this.emptyCheck == null) {
            this.emptyTitle = this.addControlTitle(this.client.getWidget(675, 2), 0, "Empty Sets");
            this.emptyCheck = this.addControlCheckbox(this.client.getWidget(675, 2), 0, "Empty Sets", this.showEmpty);
        } else {
            this.emptyTitle.setHidden(false);
            this.emptyCheck.setHidden(false);
        }
        if (this.partialTitle == null || this.partialCheck == null) {
            this.partialTitle = this.addControlTitle(this.client.getWidget(675, 2), 1, "Partial Sets");
            this.partialCheck = this.addControlCheckbox(this.client.getWidget(675, 2), 1, "Partial Sets", this.showPartial);
        } else {
            this.partialTitle.setHidden(false);
            this.partialCheck.setHidden(false);
        }
        if (this.fullTitle == null || this.fullCheck == null) {
            this.fullTitle = this.addControlTitle(this.client.getWidget(675, 2), 2, "Full Sets");
            this.fullCheck = this.addControlCheckbox(this.client.getWidget(675, 2), 2, "Full Sets", this.showFull);
        } else {
            this.fullTitle.setHidden(false);
            this.fullCheck.setHidden(false);
        }
    }

    private void removeControls() {
        this.emptyTitle.setHidden(true);
        this.partialTitle.setHidden(true);
        this.fullTitle.setHidden(true);
        this.emptyCheck.setHidden(true);
        this.partialCheck.setHidden(true);
        this.fullCheck.setHidden(true);
    }

    private void toggle(Widget toggle, String tooltip, boolean show) {
        if (show) {
            toggle.setOnMouseOverListener(new Object[]{ev -> toggle.setSpriteId(1218)});
            toggle.setOnMouseLeaveListener(new Object[]{ev -> toggle.setSpriteId(1215)});
            toggle.setSpriteId(1215);
        } else {
            toggle.setOnMouseOverListener(new Object[]{ev -> toggle.setSpriteId(1220)});
            toggle.setOnMouseLeaveListener(new Object[]{ev -> toggle.setSpriteId(1217)});
            toggle.setSpriteId(1217);
        }
        if (tooltip.equals("Empty Sets")) {
            this.showEmpty = !this.showEmpty;
            this.config.showEmptySets(this.showEmpty);
        } else if (tooltip.equals("Partial Sets")) {
            this.showPartial = !this.showPartial;
            this.config.showPartialSets(this.showPartial);
        } else if (tooltip.equals("Full Sets")) {
            this.showFull = !this.showFull;
            this.config.showFullSets(this.showFull);
        }
        toggle.setOnOpListener(new Object[]{ev -> this.toggle(toggle, tooltip, !show)});
        this.applyChanges();
    }

    private Widget addControlTitle(Widget parentWidget, int index, String title) {
        Widget titleWidget = parentWidget.createChild(-1, 4);
        titleWidget.setText(title);
        titleWidget.setOriginalWidth(37);
        titleWidget.setOriginalHeight(15);
        titleWidget.setFontId(494);
        titleWidget.setTextColor(0xCFCFCF);
        titleWidget.setTextShadowed(true);
        titleWidget.setOriginalY(42);
        titleWidget.setOriginalX(index * 175 + 31);
        titleWidget.revalidate();
        return titleWidget;
    }

    private Widget addControlCheckbox(Widget parentWidget, int index, String tooltip, boolean show) {
        Widget checkWidget = parentWidget.createChild(-1, 5);
        checkWidget.setOriginalWidth(16);
        checkWidget.setOriginalHeight(16);
        checkWidget.setOriginalY(40);
        checkWidget.setOriginalX(index * 175 + 11);
        checkWidget.setName(tooltip);
        checkWidget.setAction(1, "Toggle");
        checkWidget.setHasListener(true);
        checkWidget.setOnOpListener(new Object[]{ev -> this.toggle(checkWidget, tooltip, show)});
        if (show) {
            checkWidget.setSpriteId(1217);
            checkWidget.setOnMouseOverListener(new Object[]{ev -> checkWidget.setSpriteId(1220)});
            checkWidget.setOnMouseLeaveListener(new Object[]{ev -> checkWidget.setSpriteId(1217)});
        } else {
            checkWidget.setSpriteId(1215);
            checkWidget.setOnMouseOverListener(new Object[]{ev -> checkWidget.setSpriteId(1218)});
            checkWidget.setOnMouseLeaveListener(new Object[]{ev -> checkWidget.setSpriteId(1215)});
        }
        checkWidget.revalidate();
        return checkWidget;
    }

    private void addDivider(int y) {
        Widget parent = this.client.getWidget(675, 4);
        Widget child = parent.createChild(-1, 5);
        child.setOriginalWidth(16);
        child.setOriginalHeight(57);
        child.setOriginalX(194);
        child.setOriginalY(y);
        child.setSpriteId(988);
        child.setSpriteTiling(true);
        child.revalidate();
        this.addedDividers.add(child);
    }

    private void adjustWidgets() {
        int normalOpacity = this.config.shadeOpacity();
        int hoverOpacity = normalOpacity > 20 ? normalOpacity - 20 : 0;
        int x = 0;
        int top = 0;
        ArrayList<PohStorageSet> hideSets = new ArrayList<PohStorageSet>();
        ArrayList<PohStorageSet> adjustSets = new ArrayList<PohStorageSet>();
        for (PohStorageSet storageSet : this.storageSets) {
            if (storageSet.getType() == 0 && !this.showEmpty || storageSet.getType() == 1 && !this.showPartial || storageSet.getType() == 2 && !this.showFull) {
                hideSets.add(storageSet);
                continue;
            }
            adjustSets.add(storageSet);
        }
        Collections.sort(adjustSets);
        for (PohStorageSet storageSet : hideSets) {
            for (Widget hideWidget : storageSet.getAllWidgets()) {
                hideWidget.setHidden(true);
            }
        }
        for (int i = 0; i < adjustSets.size(); ++i) {
            int finalI = i;
            top = x * 60;
            ++x;
            if (i > 0 && ((PohStorageSet)adjustSets.get(i - 1)).isCollapsible() && ((PohStorageSet)adjustSets.get(i - 1)).getColumn() == 1 && ((PohStorageSet)adjustSets.get(i)).isCollapsible()) {
                ((PohStorageSet)adjustSets.get(i)).setColumn(2);
                --x;
                top -= 60;
                ((PohStorageSet)adjustSets.get(i)).getOutline().getWidget().setOriginalWidth(210);
                ((PohStorageSet)adjustSets.get(i)).getOutline().getWidget().setWidthMode(1);
                ((PohStorageSet)adjustSets.get(i)).getOutline().getWidget().setXPositionMode(2);
                ((PohStorageSet)adjustSets.get(i)).getHeader().getWidget().setOriginalWidth(207);
                ((PohStorageSet)adjustSets.get(i)).getHeader().getWidget().setXPositionMode(0);
                ((PohStorageSet)adjustSets.get(i)).getHeader().getWidget().setWidthMode(0);
                ((PohStorageSet)adjustSets.get(i)).getHeader().getWidget().setOriginalX(213);
                ((PohStorageSet)adjustSets.get(i)).getFooter().getWidget().setOriginalWidth(210);
                ((PohStorageSet)adjustSets.get(i)).getFooter().getWidget().setXPositionMode(2);
                ((PohStorageSet)adjustSets.get(i)).getFooter().getWidget().setWidthMode(1);
                ((PohStorageSet)adjustSets.get(i)).getArrow().getWidget().setOriginalX(3);
                this.shiftIcons(((PohStorageSet)adjustSets.get(i)).getWidgetItems(), 213, top + 20);
                this.addDivider(top);
            } else if (i < adjustSets.size() - 1 && ((PohStorageSet)adjustSets.get(i)).isCollapsible() && ((PohStorageSet)adjustSets.get(i + 1)).isCollapsible()) {
                ((PohStorageSet)adjustSets.get(i)).getOutline().getWidget().setOriginalWidth(210);
                ((PohStorageSet)adjustSets.get(i)).getOutline().getWidget().setWidthMode(0);
                ((PohStorageSet)adjustSets.get(i)).getOutline().getWidget().setXPositionMode(0);
                ((PohStorageSet)adjustSets.get(i)).getHeader().getWidget().setOriginalWidth(207);
                ((PohStorageSet)adjustSets.get(i)).getHeader().getWidget().setXPositionMode(0);
                ((PohStorageSet)adjustSets.get(i)).getHeader().getWidget().setWidthMode(0);
                ((PohStorageSet)adjustSets.get(i)).getHeader().getWidget().setOriginalX(3);
                ((PohStorageSet)adjustSets.get(i)).getFooter().getWidget().setOriginalWidth(210);
                ((PohStorageSet)adjustSets.get(i)).getFooter().getWidget().setXPositionMode(0);
                ((PohStorageSet)adjustSets.get(i)).getFooter().getWidget().setWidthMode(0);
                ((PohStorageSet)adjustSets.get(i)).getArrow().getWidget().setOriginalX(216);
                this.shiftIcons(((PohStorageSet)adjustSets.get(i)).getWidgetItems(), 3, top + 20);
            } else {
                ((PohStorageSet)adjustSets.get(i)).getOutline().getWidget().setOriginalWidth(0);
                ((PohStorageSet)adjustSets.get(i)).getOutline().getWidget().setWidthMode(1);
                ((PohStorageSet)adjustSets.get(i)).getOutline().getWidget().setXPositionMode(1);
                ((PohStorageSet)adjustSets.get(i)).getHeader().getWidget().setOriginalWidth(3);
                ((PohStorageSet)adjustSets.get(i)).getHeader().getWidget().setXPositionMode(2);
                ((PohStorageSet)adjustSets.get(i)).getHeader().getWidget().setWidthMode(1);
                ((PohStorageSet)adjustSets.get(i)).getHeader().getWidget().setOriginalX(0);
                ((PohStorageSet)adjustSets.get(i)).getFooter().getWidget().setOriginalWidth(0);
                ((PohStorageSet)adjustSets.get(i)).getFooter().getWidget().setXPositionMode(1);
                ((PohStorageSet)adjustSets.get(i)).getFooter().getWidget().setWidthMode(1);
                ((PohStorageSet)adjustSets.get(i)).getArrow().getWidget().setOriginalX(3);
                this.shiftIcons(((PohStorageSet)adjustSets.get(i)).getWidgetItems(), 3, top + 20);
            }
            ((PohStorageSet)adjustSets.get(i)).getOutline().getWidget().setOriginalY(top);
            if (((PohStorageSet)adjustSets.get(i)).getType() == 0 && this.config.emptySetColor().getSpriteId() != 0) {
                ((PohStorageSet)adjustSets.get(i)).getOutline().getWidget().setSpriteId(this.config.emptySetColor().getSpriteId());
                ((PohStorageSet)adjustSets.get(i)).getOutline().getWidget().setOpacity(normalOpacity);
            } else if (((PohStorageSet)adjustSets.get(i)).getType() == 1 && this.config.partialSetColor().getSpriteId() != 0) {
                ((PohStorageSet)adjustSets.get(i)).getOutline().getWidget().setSpriteId(this.config.partialSetColor().getSpriteId());
                ((PohStorageSet)adjustSets.get(i)).getOutline().getWidget().setOpacity(normalOpacity);
                ((PohStorageSet)adjustSets.get(i)).getOutline().getWidget().setOnMouseRepeatListener(new Object[]{ev -> ((PohStorageSet)adjustSets.get(finalI)).getOutline().getWidget().setOpacity(hoverOpacity)});
                ((PohStorageSet)adjustSets.get(i)).getOutline().getWidget().setOnMouseLeaveListener(new Object[]{ev -> ((PohStorageSet)adjustSets.get(finalI)).getOutline().getWidget().setOpacity(normalOpacity)});
            } else if (((PohStorageSet)adjustSets.get(i)).getType() == 2 && this.config.fullSetColor().getSpriteId() != 0) {
                ((PohStorageSet)adjustSets.get(i)).getOutline().getWidget().setSpriteId(this.config.fullSetColor().getSpriteId());
                ((PohStorageSet)adjustSets.get(i)).getOutline().getWidget().setOpacity(normalOpacity);
                ((PohStorageSet)adjustSets.get(i)).getOutline().getWidget().setOnMouseRepeatListener(new Object[]{ev -> ((PohStorageSet)adjustSets.get(finalI)).getOutline().getWidget().setOpacity(hoverOpacity)});
                ((PohStorageSet)adjustSets.get(i)).getOutline().getWidget().setOnMouseLeaveListener(new Object[]{ev -> ((PohStorageSet)adjustSets.get(finalI)).getOutline().getWidget().setOpacity(normalOpacity)});
            }
            ((PohStorageSet)adjustSets.get(i)).getOutline().getWidget().revalidate();
            ((PohStorageSet)adjustSets.get(i)).getHeader().getWidget().setOriginalY(top);
            ((PohStorageSet)adjustSets.get(i)).getHeader().getWidget().revalidate();
            ((PohStorageSet)adjustSets.get(i)).getArrow().getWidget().setOriginalY(top + 5);
            ((PohStorageSet)adjustSets.get(i)).getArrow().getWidget().revalidate();
            ((PohStorageSet)adjustSets.get(i)).getFooter().getWidget().setOriginalY(top + 40);
            ((PohStorageSet)adjustSets.get(i)).getFooter().getWidget().revalidate();
        }
        Widget container = this.client.getWidget(675, 4);
        int y = x * 60 - 3;
        if (container.getHeight() > y) {
            y = 0;
        }
        container.setScrollHeight(y);
        container.revalidateScroll();
        this.client.runScript(new Object[]{72, 44236805, 44236804, container.getScrollY()});
    }

    private void shiftIcons(List<Widget> items, int adjustmentX, int finalY) {
        for (int j = 0; j < items.size(); ++j) {
            items.get(j).setOriginalX(42 * j + adjustmentX);
            items.get(j).setOriginalY(finalY);
            items.get(j).revalidate();
        }
    }

    private PohStorageWidget newPohStorageWidget(Widget widget) {
        return new PohStorageWidget(widget, widget.getId(), widget.getOriginalX(), widget.getOriginalY(), widget.getOriginalWidth(), widget.getOpacity(), widget.getSpriteId(), widget.isHidden(), widget.getWidthMode(), widget.getXPositionMode());
    }

    private PohStorageSet newPohStorageSet(Widget headerWidget) {
        int textId = headerWidget.getIndex();
        PohStorageWidget outline = this.newPohStorageWidget(headerWidget.getParent().getChild(textId - 3));
        PohStorageWidget arrow = this.newPohStorageWidget(headerWidget.getParent().getChild(textId - 2));
        PohStorageWidget footer = this.newPohStorageWidget(headerWidget.getParent().getChild(textId - 1));
        PohStorageWidget header = this.newPohStorageWidget(headerWidget);
        int stored = 0;
        int offset = 1;
        ArrayList<PohStorageWidget> items = new ArrayList<PohStorageWidget>();
        while (headerWidget.getParent().getChild(textId + offset).getWidth() == 36) {
            if (!headerWidget.getParent().getChild(textId + offset).isHidden()) {
                items.add(this.newPohStorageWidget(headerWidget.getParent().getChild(textId + offset)));
                if (headerWidget.getParent().getChild(textId + offset).getOpacity() == 0) {
                    ++stored;
                }
            }
            ++offset;
        }
        int type = stored == items.size() ? 2 : (stored == 0 ? 0 : 1);
        return new PohStorageSet(outline, arrow, footer, header, items, headerWidget.getText(), type, items.size() <= 4);
    }
}

