/*
 * Decompiled with CFR 0.152.
 */
package com.pohstorage;

import com.pohstorage.PohSprites;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.Range;

@ConfigGroup(value="pohstorage")
public interface PohStorageConfig
extends Config {
    @ConfigItem(keyName="preserveFilters", name="Save Filters", description="Allows for saving prior filters each time a POH storage unit is opened", position=1)
    default public preserveFilters preserveFilters() {
        return preserveFilters.WITHIN_SESSION;
    }

    @ConfigItem(keyName="fullSetColor", name="Full Set Color", description="Configures the shade color of full sets", position=2)
    default public outlineColor fullSetColor() {
        return outlineColor.GREEN;
    }

    @ConfigItem(keyName="partialSetColor", name="Partial Set Color", description="Configures the shade color of partial sets", position=3)
    default public outlineColor partialSetColor() {
        return outlineColor.BLUE;
    }

    @ConfigItem(keyName="emptySetColor", name="Empty Set Color", description="Configures the shade color of empty sets", position=4)
    default public outlineColor emptySetColor() {
        return outlineColor.NONE;
    }

    @ConfigItem(keyName="shadeOpacity", name="Shade Opacity", description="Sets the opacity of shaded sets (0 = fully opaque, 255 = fully transparent)", position=5)
    @Range(min=0, max=255)
    default public int shadeOpacity() {
        return 230;
    }

    @ConfigItem(keyName="showPartialSets", name="Show Partial Sets", description="Determines whether or not partial sets are displayed in POH storage units", hidden=true)
    default public boolean showPartialSets() {
        return true;
    }

    @ConfigItem(keyName="showPartialSets", name="Show Partial Sets", description="Determines whether or not partial sets are displayed in POH storage units")
    public void showPartialSets(boolean var1);

    @ConfigItem(keyName="showEmptySets", name="Show Empty Sets", description="Determines whether or not empty sets are displayed in POH storage units", hidden=true)
    default public boolean showEmptySets() {
        return true;
    }

    @ConfigItem(keyName="showEmptySets", name="Show Empty Sets", description="Determines whether or not empty sets are displayed in POH storage units")
    public void showEmptySets(boolean var1);

    @ConfigItem(keyName="showFullSets", name="Show Full Sets", description="Determines whether or not full sets are displayed in POH storage units", hidden=true)
    default public boolean showFullSets() {
        return true;
    }

    @ConfigItem(keyName="showFullSets", name="Show Full Sets", description="Determines whether or not full sets are displayed in POH storage units")
    public void showFullSets(boolean var1);

    public static enum preserveFilters {
        NEVER("Never"),
        WITHIN_SESSION("Within Session"),
        ACROSS_SESSIONS("Across Sessions");

        private final String value;

        public String getValue() {
            return this.value;
        }

        private preserveFilters(String value) {
            this.value = value;
        }
    }

    public static enum outlineColor {
        PURPLE("Purple", PohSprites.PURPLE.getSpriteId()),
        BLUE("Blue", PohSprites.BLUE.getSpriteId()),
        GREEN("Green", PohSprites.GREEN.getSpriteId()),
        YELLOW("Yellow", PohSprites.YELLOW.getSpriteId()),
        ORANGE("Orange", PohSprites.ORANGE.getSpriteId()),
        RED("Red", PohSprites.RED.getSpriteId()),
        NONE("None", 0);

        private final String value;
        private final int spriteId;

        public String getValue() {
            return this.value;
        }

        public int getSpriteId() {
            return this.spriteId;
        }

        private outlineColor(String value, int spriteId) {
            this.value = value;
            this.spriteId = spriteId;
        }
    }
}

