/*
 * Decompiled with CFR 0.152.
 */
package at.nightfirec.roguesden;

import at.nightfirec.roguesden.Obstacles;
import at.nightfirec.roguesden.RoguesDenMinimapOverlay;
import at.nightfirec.roguesden.RoguesDenOverlay;
import java.util.HashMap;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.Tile;
import net.runelite.api.TileObject;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.DecorativeObjectDespawned;
import net.runelite.api.events.DecorativeObjectSpawned;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GroundObjectDespawned;
import net.runelite.api.events.GroundObjectSpawned;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.WallObjectDespawned;
import net.runelite.api.events.WallObjectSpawned;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Rogues' Den", description="Mark tiles and clickboxes to help traverse the maze", tags={"agility", "maze", "minigame", "overlay", "thieving"})
public class RoguesDenPlugin
extends Plugin {
    private final HashMap<TileObject, Tile> obstaclesHull = new HashMap();
    private final HashMap<TileObject, Tile> obstaclesTile = new HashMap();
    private boolean hasGem;
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private RoguesDenOverlay overlay;
    @Inject
    private RoguesDenMinimapOverlay minimapOverlay;

    protected void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
        this.overlayManager.add((Overlay)this.minimapOverlay);
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
        this.overlayManager.remove((Overlay)this.minimapOverlay);
        this.obstaclesHull.clear();
        this.obstaclesTile.clear();
        this.hasGem = false;
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getItemContainer() != this.client.getItemContainer(InventoryID.INVENTORY)) {
            return;
        }
        for (Item item : event.getItemContainer().getItems()) {
            if (item.getId() != 5561) continue;
            this.hasGem = true;
            return;
        }
        this.hasGem = false;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOADING) {
            this.obstaclesHull.clear();
            this.obstaclesTile.clear();
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        this.onTileObject(event.getTile(), null, (TileObject)event.getGameObject());
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        this.onTileObject(event.getTile(), (TileObject)event.getGameObject(), null);
    }

    @Subscribe
    public void onGroundObjectSpawned(GroundObjectSpawned event) {
        this.onTileObject(event.getTile(), null, (TileObject)event.getGroundObject());
    }

    @Subscribe
    public void onGroundObjectDespawned(GroundObjectDespawned event) {
        this.onTileObject(event.getTile(), (TileObject)event.getGroundObject(), null);
    }

    @Subscribe
    public void onWallObjectSpawned(WallObjectSpawned event) {
        this.onTileObject(event.getTile(), null, (TileObject)event.getWallObject());
    }

    @Subscribe
    public void onWallObjectDespawned(WallObjectDespawned event) {
        this.onTileObject(event.getTile(), (TileObject)event.getWallObject(), null);
    }

    @Subscribe
    public void onDecorativeObjectSpawned(DecorativeObjectSpawned event) {
        this.onTileObject(event.getTile(), null, (TileObject)event.getDecorativeObject());
    }

    @Subscribe
    public void onDecorativeObjectDespawned(DecorativeObjectDespawned event) {
        this.onTileObject(event.getTile(), (TileObject)event.getDecorativeObject(), null);
    }

    private void onTileObject(Tile tile, TileObject oldObject, TileObject newObject) {
        WorldPoint point;
        Obstacles.Obstacle obstacle;
        this.obstaclesHull.remove(oldObject);
        if (newObject != null && (obstacle = Obstacles.TILE_MAP.get(point = tile.getWorldLocation())) != null && obstacle.getObjectId() == newObject.getId()) {
            this.obstaclesHull.put(newObject, tile);
        }
    }

    HashMap<TileObject, Tile> getObstaclesHull() {
        return this.obstaclesHull;
    }

    HashMap<TileObject, Tile> getObstaclesTile() {
        return this.obstaclesTile;
    }

    boolean isHasGem() {
        return this.hasGem;
    }
}

