/*
 * Decompiled with CFR 0.152.
 */
package at.nightfirec.roguesden;

import at.nightfirec.roguesden.Obstacles;
import at.nightfirec.roguesden.RoguesDenPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;

public class RoguesDenOverlay
extends Overlay {
    private static final Color OBJECT_BORDER_COLOR = Color.RED;
    private static final Color OBJECT_COLOR = new Color(OBJECT_BORDER_COLOR.getRed(), OBJECT_BORDER_COLOR.getGreen(), OBJECT_BORDER_COLOR.getBlue(), 50);
    private static final Color OBJECT_BORDER_HOVER_COLOR = OBJECT_BORDER_COLOR.darker();
    private final Client client;
    private final RoguesDenPlugin plugin;

    @Inject
    public RoguesDenOverlay(Client client, RoguesDenPlugin plugin) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.client = client;
        this.plugin = plugin;
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isHasGem()) {
            return null;
        }
        this.plugin.getObstaclesHull().forEach((obstacle, tile) -> {
            if (tile.getPlane() == this.client.getPlane()) {
                Shape clickBox = obstacle.getClickbox();
                if (clickBox != null) {
                    Point mouse = this.client.getMouseCanvasPosition();
                    if (clickBox.contains(mouse.getX(), mouse.getY())) {
                        graphics.setColor(OBJECT_BORDER_HOVER_COLOR);
                    } else {
                        graphics.setColor(OBJECT_BORDER_COLOR);
                    }
                    graphics.draw(clickBox);
                    graphics.setColor(OBJECT_COLOR);
                    graphics.fill(clickBox);
                } else {
                    Shape p = obstacle instanceof GameObject ? ((GameObject)obstacle).getConvexHull() : obstacle.getCanvasTilePoly();
                    if (p != null) {
                        graphics.setColor(OBJECT_COLOR);
                        graphics.draw(p);
                    }
                }
            }
        });
        for (Obstacles.Obstacle obstacle2 : Obstacles.OBSTACLES) {
            Point textLocation;
            Polygon polygon;
            LocalPoint localPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)obstacle2.getTile());
            if (localPoint == null || obstacle2.getTile().getPlane() != this.client.getPlane()) continue;
            if (!obstacle2.getHint().isEmpty() && (polygon = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)localPoint)) != null) {
                graphics.setColor(obstacle2.getTileColor());
                graphics.drawPolygon(polygon);
            }
            if ((textLocation = Perspective.getCanvasTextLocation((Client)this.client, (Graphics2D)graphics, (LocalPoint)localPoint, (String)obstacle2.getHint(), (int)0)) == null) continue;
            graphics.setColor(Color.LIGHT_GRAY);
            graphics.drawString(obstacle2.getHint(), textLocation.getX(), textLocation.getY());
        }
        return null;
    }
}

