/*
 * Decompiled with CFR 0.152.
 */
package at.nightfirec.roguesden;

import at.nightfirec.roguesden.Obstacles;
import at.nightfirec.roguesden.RoguesDenPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

class RoguesDenMinimapOverlay
extends Overlay {
    private final Client client;
    private final RoguesDenPlugin plugin;

    @Inject
    public RoguesDenMinimapOverlay(Client client, RoguesDenPlugin plugin) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.client = client;
        this.plugin = plugin;
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isHasGem()) {
            return null;
        }
        for (Obstacles.Obstacle obstacle : Obstacles.OBSTACLES) {
            Point minimapPoint;
            LocalPoint localPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)obstacle.getTile());
            if (localPoint == null || obstacle.getTile().getPlane() != this.client.getPlane() || (minimapPoint = Perspective.localToMinimap((Client)this.client, (LocalPoint)localPoint)) == null) continue;
            OverlayUtil.renderMinimapLocation((Graphics2D)graphics, (Point)minimapPoint, (Color)(obstacle.getObjectId() == -1 ? Color.GREEN : Color.RED));
        }
        return null;
    }
}

